/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSegmentReferencesRequest extends EvidentlyRequest implements
        ToCopyableBuilder<ListSegmentReferencesRequest.Builder, ListSegmentReferencesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSegmentReferencesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSegmentReferencesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> SEGMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("segment")
            .getter(getter(ListSegmentReferencesRequest::segment)).setter(setter(Builder::segment))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("segment").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ListSegmentReferencesRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, SEGMENT_FIELD, TYPE_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final String segment;

    private final String type;

    private ListSegmentReferencesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.segment = builder.segment;
        this.type = builder.type;
    }

    /**
     * <p>
     * The maximum number of results to include in the response. If you omit this, the default of 50 is used.
     * </p>
     * 
     * @return The maximum number of results to include in the response. If you omit this, the default of 50 is used.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to use when requesting the next set of results. You received this token from a previous
     * <code>ListSegmentReferences</code> operation.
     * </p>
     * 
     * @return The token to use when requesting the next set of results. You received this token from a previous
     *         <code>ListSegmentReferences</code> operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The ARN of the segment that you want to view information for.
     * </p>
     * 
     * @return The ARN of the segment that you want to view information for.
     */
    public final String segment() {
        return segment;
    }

    /**
     * <p>
     * Specifies whether to return information about launches or experiments that use this segment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SegmentReferenceResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies whether to return information about launches or experiments that use this segment.
     * @see SegmentReferenceResourceType
     */
    public final SegmentReferenceResourceType type() {
        return SegmentReferenceResourceType.fromValue(type);
    }

    /**
     * <p>
     * Specifies whether to return information about launches or experiments that use this segment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SegmentReferenceResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies whether to return information about launches or experiments that use this segment.
     * @see SegmentReferenceResourceType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(segment());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSegmentReferencesRequest)) {
            return false;
        }
        ListSegmentReferencesRequest other = (ListSegmentReferencesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(segment(), other.segment()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSegmentReferencesRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Segment", segment()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "segment":
            return Optional.ofNullable(clazz.cast(segment()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSegmentReferencesRequest, T> g) {
        return obj -> g.apply((ListSegmentReferencesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EvidentlyRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSegmentReferencesRequest> {
        /**
         * <p>
         * The maximum number of results to include in the response. If you omit this, the default of 50 is used.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to include in the response. If you omit this, the default of 50 is used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to use when requesting the next set of results. You received this token from a previous
         * <code>ListSegmentReferences</code> operation.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of results. You received this token from a previous
         *        <code>ListSegmentReferences</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The ARN of the segment that you want to view information for.
         * </p>
         * 
         * @param segment
         *        The ARN of the segment that you want to view information for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segment(String segment);

        /**
         * <p>
         * Specifies whether to return information about launches or experiments that use this segment.
         * </p>
         * 
         * @param type
         *        Specifies whether to return information about launches or experiments that use this segment.
         * @see SegmentReferenceResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentReferenceResourceType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies whether to return information about launches or experiments that use this segment.
         * </p>
         * 
         * @param type
         *        Specifies whether to return information about launches or experiments that use this segment.
         * @see SegmentReferenceResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SegmentReferenceResourceType
         */
        Builder type(SegmentReferenceResourceType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EvidentlyRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String segment;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSegmentReferencesRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            segment(model.segment);
            type(model.type);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSegment() {
            return segment;
        }

        public final void setSegment(String segment) {
            this.segment = segment;
        }

        @Override
        public final Builder segment(String segment) {
            this.segment = segment;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SegmentReferenceResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSegmentReferencesRequest build() {
            return new ListSegmentReferencesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
