/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.evidently.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure containing the CloudWatch Logs log group where the project stores evaluation events.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLogsDestinationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLogsDestinationConfig.Builder, CloudWatchLogsDestinationConfig> {
    private static final SdkField<String> LOG_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logGroup").getter(getter(CloudWatchLogsDestinationConfig::logGroup)).setter(setter(Builder::logGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String logGroup;

    private CloudWatchLogsDestinationConfig(BuilderImpl builder) {
        this.logGroup = builder.logGroup;
    }

    /**
     * <p>
     * The name of the log group where the project stores evaluation events.
     * </p>
     * 
     * @return The name of the log group where the project stores evaluation events.
     */
    public final String logGroup() {
        return logGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsDestinationConfig)) {
            return false;
        }
        CloudWatchLogsDestinationConfig other = (CloudWatchLogsDestinationConfig) obj;
        return Objects.equals(logGroup(), other.logGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchLogsDestinationConfig").add("LogGroup", logGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logGroup":
            return Optional.ofNullable(clazz.cast(logGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogsDestinationConfig, T> g) {
        return obj -> g.apply((CloudWatchLogsDestinationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLogsDestinationConfig> {
        /**
         * <p>
         * The name of the log group where the project stores evaluation events.
         * </p>
         * 
         * @param logGroup
         *        The name of the log group where the project stores evaluation events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroup(String logGroup);
    }

    static final class BuilderImpl implements Builder {
        private String logGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsDestinationConfig model) {
            logGroup(model.logGroup);
        }

        public final String getLogGroup() {
            return logGroup;
        }

        public final void setLogGroup(String logGroup) {
            this.logGroup = logGroup;
        }

        @Override
        public final Builder logGroup(String logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        @Override
        public CloudWatchLogsDestinationConfig build() {
            return new CloudWatchLogsDestinationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
