/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.DeadLetterConfig;
import software.amazon.awssdk.services.eventbridge.model.EventBridgeResponse;
import software.amazon.awssdk.services.eventbridge.model.LogConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEventBusResponse
extends EventBridgeResponse
implements ToCopyableBuilder<Builder, CreateEventBusResponse> {
    private static final SdkField<String> EVENT_BUS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventBusArn").getter(CreateEventBusResponse.getter(CreateEventBusResponse::eventBusArn)).setter(CreateEventBusResponse.setter(Builder::eventBusArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBusArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateEventBusResponse.getter(CreateEventBusResponse::description)).setter(CreateEventBusResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyIdentifier").getter(CreateEventBusResponse.getter(CreateEventBusResponse::kmsKeyIdentifier)).setter(CreateEventBusResponse.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyIdentifier").build()}).build();
    private static final SdkField<DeadLetterConfig> DEAD_LETTER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeadLetterConfig").getter(CreateEventBusResponse.getter(CreateEventBusResponse::deadLetterConfig)).setter(CreateEventBusResponse.setter(Builder::deadLetterConfig)).constructor(DeadLetterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterConfig").build()}).build();
    private static final SdkField<LogConfig> LOG_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LogConfig").getter(CreateEventBusResponse.getter(CreateEventBusResponse::logConfig)).setter(CreateEventBusResponse.setter(Builder::logConfig)).constructor(LogConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_BUS_ARN_FIELD, DESCRIPTION_FIELD, KMS_KEY_IDENTIFIER_FIELD, DEAD_LETTER_CONFIG_FIELD, LOG_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEventBusResponse.memberNameToFieldInitializer();
    private final String eventBusArn;
    private final String description;
    private final String kmsKeyIdentifier;
    private final DeadLetterConfig deadLetterConfig;
    private final LogConfig logConfig;

    private CreateEventBusResponse(BuilderImpl builder) {
        super(builder);
        this.eventBusArn = builder.eventBusArn;
        this.description = builder.description;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.deadLetterConfig = builder.deadLetterConfig;
        this.logConfig = builder.logConfig;
    }

    public final String eventBusArn() {
        return this.eventBusArn;
    }

    public final String description() {
        return this.description;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final DeadLetterConfig deadLetterConfig() {
        return this.deadLetterConfig;
    }

    public final LogConfig logConfig() {
        return this.logConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBusArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventBusResponse)) {
            return false;
        }
        CreateEventBusResponse other = (CreateEventBusResponse)((Object)obj);
        return Objects.equals(this.eventBusArn(), other.eventBusArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(this.deadLetterConfig(), other.deadLetterConfig()) && Objects.equals(this.logConfig(), other.logConfig());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEventBusResponse").add("EventBusArn", (Object)this.eventBusArn()).add("Description", (Object)this.description()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).add("DeadLetterConfig", (Object)this.deadLetterConfig()).add("LogConfig", (Object)this.logConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventBusArn": {
                return Optional.ofNullable(clazz.cast(this.eventBusArn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "KmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "DeadLetterConfig": {
                return Optional.ofNullable(clazz.cast(this.deadLetterConfig()));
            }
            case "LogConfig": {
                return Optional.ofNullable(clazz.cast(this.logConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EventBusArn", EVENT_BUS_ARN_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("KmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("DeadLetterConfig", DEAD_LETTER_CONFIG_FIELD);
        map.put("LogConfig", LOG_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEventBusResponse, T> g) {
        return obj -> g.apply((CreateEventBusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EventBridgeResponse.BuilderImpl
    implements Builder {
        private String eventBusArn;
        private String description;
        private String kmsKeyIdentifier;
        private DeadLetterConfig deadLetterConfig;
        private LogConfig logConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventBusResponse model) {
            super(model);
            this.eventBusArn(model.eventBusArn);
            this.description(model.description);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.deadLetterConfig(model.deadLetterConfig);
            this.logConfig(model.logConfig);
        }

        public final String getEventBusArn() {
            return this.eventBusArn;
        }

        public final void setEventBusArn(String eventBusArn) {
            this.eventBusArn = eventBusArn;
        }

        @Override
        public final Builder eventBusArn(String eventBusArn) {
            this.eventBusArn = eventBusArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final DeadLetterConfig.Builder getDeadLetterConfig() {
            return this.deadLetterConfig != null ? this.deadLetterConfig.toBuilder() : null;
        }

        public final void setDeadLetterConfig(DeadLetterConfig.BuilderImpl deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig != null ? deadLetterConfig.build() : null;
        }

        @Override
        public final Builder deadLetterConfig(DeadLetterConfig deadLetterConfig) {
            this.deadLetterConfig = deadLetterConfig;
            return this;
        }

        public final LogConfig.Builder getLogConfig() {
            return this.logConfig != null ? this.logConfig.toBuilder() : null;
        }

        public final void setLogConfig(LogConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        @Override
        public final Builder logConfig(LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        @Override
        public CreateEventBusResponse build() {
            return new CreateEventBusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EventBridgeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEventBusResponse> {
        public Builder eventBusArn(String var1);

        public Builder description(String var1);

        public Builder kmsKeyIdentifier(String var1);

        public Builder deadLetterConfig(DeadLetterConfig var1);

        default public Builder deadLetterConfig(Consumer<DeadLetterConfig.Builder> deadLetterConfig) {
            return this.deadLetterConfig((DeadLetterConfig)((DeadLetterConfig.Builder)DeadLetterConfig.builder().applyMutation(deadLetterConfig)).build());
        }

        public Builder logConfig(LogConfig var1);

        default public Builder logConfig(Consumer<LogConfig.Builder> logConfig) {
            return this.logConfig((LogConfig)((LogConfig.Builder)LogConfig.builder().applyMutation(logConfig)).build());
        }
    }
}

