/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.endpoints.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointParams;
import software.amazon.awssdk.services.eventbridge.endpoints.EventBridgeEndpointProvider;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.Condition;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.DefaultRuleEngine;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.EndpointResult;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.EndpointRuleset;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.Expr;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.FnNode;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.Identifier;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.Literal;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.Parameter;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.ParameterType;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.Parameters;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.Rule;
import software.amazon.awssdk.services.eventbridge.endpoints.internal.Value;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.MapUtils;

@SdkInternalApi
public final class DefaultEventBridgeEndpointProvider
implements EventBridgeEndpointProvider {
    private static final EndpointRuleset ENDPOINT_RULE_SET = DefaultEventBridgeEndpointProvider.ruleSet();

    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(EventBridgeEndpointParams endpointParams) {
        Value res = new DefaultRuleEngine().evaluate(ENDPOINT_RULE_SET, DefaultEventBridgeEndpointProvider.toIdentifierValueMap(endpointParams));
        try {
            return CompletableFuture.completedFuture(AwsEndpointProviderUtils.valueAsEndpointOrThrow(res));
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static Map<Identifier, Value> toIdentifierValueMap(EventBridgeEndpointParams params) {
        HashMap<Identifier, Value> paramsMap = new HashMap<Identifier, Value>();
        if (params.region() != null) {
            paramsMap.put(Identifier.of("Region"), Value.fromStr(params.region().id()));
        }
        if (params.useDualStack() != null) {
            paramsMap.put(Identifier.of("UseDualStack"), Value.fromBool(params.useDualStack()));
        }
        if (params.useFips() != null) {
            paramsMap.put(Identifier.of("UseFIPS"), Value.fromBool(params.useFips()));
        }
        if (params.endpoint() != null) {
            paramsMap.put(Identifier.of("Endpoint"), Value.fromStr(params.endpoint()));
        }
        if (params.endpointId() != null) {
            paramsMap.put(Identifier.of("EndpointId"), Value.fromStr(params.endpointId()));
        }
        return paramsMap;
    }

    private static Rule endpointRule_6() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4a"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("events"), (Object)Identifier.of("signingRegionSet"), (Object)Literal.fromTuple(Arrays.asList(Literal.fromStr("*")))))))).build());
    }

    private static Rule endpointRule_9() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{EndpointId}.endpoint.events.{PartitionResult#dualStackDnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4a"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("events"), (Object)Identifier.of("signingRegionSet"), (Object)Literal.fromTuple(Arrays.asList(Literal.fromStr("*")))))))).build());
    }

    private static Rule endpointRule_8() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_9()));
    }

    private static Rule endpointRule_10() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_7() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_8(), DefaultEventBridgeEndpointProvider.endpointRule_10()));
    }

    private static Rule endpointRule_11() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://{EndpointId}.endpoint.events.{PartitionResult#dnsSuffix}")).addProperty(Identifier.of("authSchemes"), Literal.fromTuple(Arrays.asList(Literal.fromRecord(MapUtils.of((Object)Identifier.of("name"), (Object)Literal.fromStr("sigv4a"), (Object)Identifier.of("signingName"), (Object)Literal.fromStr("events"), (Object)Identifier.of("signingRegionSet"), (Object)Literal.fromTuple(Arrays.asList(Literal.fromStr("*")))))))).build());
    }

    private static Rule endpointRule_5() {
        return Rule.builder().treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_6(), DefaultEventBridgeEndpointProvider.endpointRule_7(), DefaultEventBridgeEndpointProvider.endpointRule_11()));
    }

    private static Rule endpointRule_4() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(false))).build().validate()).build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_5()));
    }

    private static Rule endpointRule_12() {
        return Rule.builder().error("Invalid Configuration: FIPS is not supported with EventBridge multi-region endpoints.");
    }

    private static Rule endpointRule_3() {
        return Rule.builder().treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_4(), DefaultEventBridgeEndpointProvider.endpointRule_12()));
    }

    private static Rule endpointRule_2() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isValidHostLabel").argv(Arrays.asList(Expr.ref(Identifier.of("EndpointId")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_3()));
    }

    private static Rule endpointRule_13() {
        return Rule.builder().error("EndpointId must be a valid host label.");
    }

    private static Rule endpointRule_1() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("EndpointId")))).build().validate()).build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_2(), DefaultEventBridgeEndpointProvider.endpointRule_13()));
    }

    private static Rule endpointRule_15() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: FIPS and custom endpoint are not supported");
    }

    private static Rule endpointRule_17() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).error("Invalid Configuration: Dualstack and custom endpoint are not supported");
    }

    private static Rule endpointRule_18() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.ref(Identifier.of("Endpoint"))).build());
    }

    private static Rule endpointRule_16() {
        return Rule.builder().treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_17(), DefaultEventBridgeEndpointProvider.endpointRule_18()));
    }

    private static Rule endpointRule_14() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("isSet").argv(Arrays.asList(Expr.ref(Identifier.of("Endpoint")))).build().validate()).build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_15(), DefaultEventBridgeEndpointProvider.endpointRule_16()));
    }

    private static Rule endpointRule_21() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://events-fips.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_20() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_21()));
    }

    private static Rule endpointRule_22() {
        return Rule.builder().error("FIPS and DualStack are enabled, but this partition does not support one or both");
    }

    private static Rule endpointRule_19() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_20(), DefaultEventBridgeEndpointProvider.endpointRule_22()));
    }

    private static Rule endpointRule_26() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-gov-east-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://events.us-gov-east-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_27() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("stringEquals").argv(Arrays.asList(Expr.ref(Identifier.of("Region")), Expr.of("us-gov-west-1"))).build().validate()).build()).endpoint(EndpointResult.builder().url(Expr.of("https://events.us-gov-west-1.amazonaws.com")).build());
    }

    private static Rule endpointRule_28() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://events-fips.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_25() {
        return Rule.builder().treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_26(), DefaultEventBridgeEndpointProvider.endpointRule_27(), DefaultEventBridgeEndpointProvider.endpointRule_28()));
    }

    private static Rule endpointRule_24() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsFIPS"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_25()));
    }

    private static Rule endpointRule_29() {
        return Rule.builder().error("FIPS is enabled but this partition does not support FIPS");
    }

    private static Rule endpointRule_23() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseFIPS")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_24(), DefaultEventBridgeEndpointProvider.endpointRule_29()));
    }

    private static Rule endpointRule_32() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://events.{Region}.{PartitionResult#dualStackDnsSuffix}")).build());
    }

    private static Rule endpointRule_31() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.of(true), FnNode.builder().fn("getAttr").argv(Arrays.asList(Expr.ref(Identifier.of("PartitionResult")), Expr.of("supportsDualStack"))).build().validate())).build().validate()).build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_32()));
    }

    private static Rule endpointRule_33() {
        return Rule.builder().error("DualStack is enabled but this partition does not support DualStack");
    }

    private static Rule endpointRule_30() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("booleanEquals").argv(Arrays.asList(Expr.ref(Identifier.of("UseDualStack")), Expr.of(true))).build().validate()).build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_31(), DefaultEventBridgeEndpointProvider.endpointRule_33()));
    }

    private static Rule endpointRule_34() {
        return Rule.builder().endpoint(EndpointResult.builder().url(Expr.of("https://events.{Region}.{PartitionResult#dnsSuffix}")).build());
    }

    private static Rule endpointRule_0() {
        return Rule.builder().addCondition(Condition.builder().fn(FnNode.builder().fn("aws.partition").argv(Arrays.asList(Expr.ref(Identifier.of("Region")))).build().validate()).result("PartitionResult").build()).treeRule(Arrays.asList(DefaultEventBridgeEndpointProvider.endpointRule_1(), DefaultEventBridgeEndpointProvider.endpointRule_14(), DefaultEventBridgeEndpointProvider.endpointRule_19(), DefaultEventBridgeEndpointProvider.endpointRule_23(), DefaultEventBridgeEndpointProvider.endpointRule_30(), DefaultEventBridgeEndpointProvider.endpointRule_34()));
    }

    private static EndpointRuleset ruleSet() {
        return EndpointRuleset.builder().version("1.0").serviceId(null).parameters(Parameters.builder().addParameter(Parameter.builder().name("Region").type(ParameterType.fromValue("String")).required(true).builtIn("AWS::Region").documentation("The AWS region used to dispatch the request.").build()).addParameter(Parameter.builder().name("UseDualStack").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseDualStack").documentation("When true, use the dual-stack endpoint. If the configured endpoint does not support dual-stack, dispatching the request MAY return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("UseFIPS").type(ParameterType.fromValue("Boolean")).required(true).builtIn("AWS::UseFIPS").documentation("When true, send this request to the FIPS-compliant regional endpoint. If the configured endpoint does not have a FIPS compliant endpoint, dispatching the request will return an error.").defaultValue(Value.fromBool(false)).build()).addParameter(Parameter.builder().name("Endpoint").type(ParameterType.fromValue("String")).required(false).builtIn("SDK::Endpoint").documentation("Override the endpoint used to send this request").build()).addParameter(Parameter.builder().name("EndpointId").type(ParameterType.fromValue("String")).required(false).documentation("Operation parameter for EndpointId").build()).build()).addRule(DefaultEventBridgeEndpointProvider.endpointRule_0()).build();
    }
}

