/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.eventbridge.model.LaunchType;
import software.amazon.awssdk.services.eventbridge.model.NetworkConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsParameters> {
    private static final SdkField<String> TASK_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskDefinitionArn").getter(EcsParameters.getter(EcsParameters::taskDefinitionArn)).setter(EcsParameters.setter(Builder::taskDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskDefinitionArn").build()}).build();
    private static final SdkField<Integer> TASK_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TaskCount").getter(EcsParameters.getter(EcsParameters::taskCount)).setter(EcsParameters.setter(Builder::taskCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskCount").build()}).build();
    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchType").getter(EcsParameters.getter(EcsParameters::launchTypeAsString)).setter(EcsParameters.setter(Builder::launchType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchType").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NetworkConfiguration").getter(EcsParameters.getter(EcsParameters::networkConfiguration)).setter(EcsParameters.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build()}).build();
    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlatformVersion").getter(EcsParameters.getter(EcsParameters::platformVersion)).setter(EcsParameters.setter(Builder::platformVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(EcsParameters.getter(EcsParameters::group)).setter(EcsParameters.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_DEFINITION_ARN_FIELD, TASK_COUNT_FIELD, LAUNCH_TYPE_FIELD, NETWORK_CONFIGURATION_FIELD, PLATFORM_VERSION_FIELD, GROUP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String taskDefinitionArn;
    private final Integer taskCount;
    private final String launchType;
    private final NetworkConfiguration networkConfiguration;
    private final String platformVersion;
    private final String group;

    private EcsParameters(BuilderImpl builder) {
        this.taskDefinitionArn = builder.taskDefinitionArn;
        this.taskCount = builder.taskCount;
        this.launchType = builder.launchType;
        this.networkConfiguration = builder.networkConfiguration;
        this.platformVersion = builder.platformVersion;
        this.group = builder.group;
    }

    public final String taskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public final Integer taskCount() {
        return this.taskCount;
    }

    public final LaunchType launchType() {
        return LaunchType.fromValue(this.launchType);
    }

    public final String launchTypeAsString() {
        return this.launchType;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final String platformVersion() {
        return this.platformVersion;
    }

    public final String group() {
        return this.group;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taskDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsParameters)) {
            return false;
        }
        EcsParameters other = (EcsParameters)obj;
        return Objects.equals(this.taskDefinitionArn(), other.taskDefinitionArn()) && Objects.equals(this.taskCount(), other.taskCount()) && Objects.equals(this.launchTypeAsString(), other.launchTypeAsString()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.platformVersion(), other.platformVersion()) && Objects.equals(this.group(), other.group());
    }

    public final String toString() {
        return ToString.builder((String)"EcsParameters").add("TaskDefinitionArn", (Object)this.taskDefinitionArn()).add("TaskCount", (Object)this.taskCount()).add("LaunchType", (Object)this.launchTypeAsString()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("PlatformVersion", (Object)this.platformVersion()).add("Group", (Object)this.group()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaskDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.taskDefinitionArn()));
            }
            case "TaskCount": {
                return Optional.ofNullable(clazz.cast(this.taskCount()));
            }
            case "LaunchType": {
                return Optional.ofNullable(clazz.cast(this.launchTypeAsString()));
            }
            case "NetworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "PlatformVersion": {
                return Optional.ofNullable(clazz.cast(this.platformVersion()));
            }
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EcsParameters, T> g) {
        return obj -> g.apply((EcsParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String taskDefinitionArn;
        private Integer taskCount;
        private String launchType;
        private NetworkConfiguration networkConfiguration;
        private String platformVersion;
        private String group;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsParameters model) {
            this.taskDefinitionArn(model.taskDefinitionArn);
            this.taskCount(model.taskCount);
            this.launchType(model.launchType);
            this.networkConfiguration(model.networkConfiguration);
            this.platformVersion(model.platformVersion);
            this.group(model.group);
        }

        public final String getTaskDefinitionArn() {
            return this.taskDefinitionArn;
        }

        @Override
        public final Builder taskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
            return this;
        }

        public final void setTaskDefinitionArn(String taskDefinitionArn) {
            this.taskDefinitionArn = taskDefinitionArn;
        }

        public final Integer getTaskCount() {
            return this.taskCount;
        }

        @Override
        public final Builder taskCount(Integer taskCount) {
            this.taskCount = taskCount;
            return this;
        }

        public final void setTaskCount(Integer taskCount) {
            this.taskCount = taskCount;
        }

        public final String getLaunchType() {
            return this.launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        @Override
        public final Builder launchType(LaunchType launchType) {
            this.launchType(launchType == null ? null : launchType.toString());
            return this;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        public final String getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        public final String getGroup() {
            return this.group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        public EcsParameters build() {
            return new EcsParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsParameters> {
        public Builder taskDefinitionArn(String var1);

        public Builder taskCount(Integer var1);

        public Builder launchType(String var1);

        public Builder launchType(LaunchType var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder platformVersion(String var1);

        public Builder group(String var1);
    }
}

