/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ArchiveState {
    ENABLED("ENABLED"),
    DISABLED("DISABLED"),
    CREATING("CREATING"),
    UPDATING("UPDATING"),
    CREATE_FAILED("CREATE_FAILED"),
    UPDATE_FAILED("UPDATE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ArchiveState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArchiveState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ArchiveState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArchiveState> knownValues() {
        return Stream.of(ArchiveState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

