/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobType {
    BATCH("BATCH"),
    INCREMENTAL("INCREMENTAL"),
    DELETE_ONLY("DELETE_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobType> VALUE_MAP;
    private final String value;

    private JobType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobType> knownValues() {
        EnumSet<JobType> knownValues = EnumSet.allOf(JobType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobType.class, JobType::toString);
    }
}

