/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines the <code>ruleCondition</code> and the <code>ruleName</code> to use in a matching workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleCondition implements SdkPojo, Serializable, ToCopyableBuilder<RuleCondition.Builder, RuleCondition> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleName").getter(getter(RuleCondition::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()).build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("condition").getter(getter(RuleCondition::condition)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ruleName;

    private final String condition;

    private RuleCondition(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * A name for the matching rule.
     * </p>
     * <p>
     * For example: <code>Rule1</code>
     * </p>
     * 
     * @return A name for the matching rule.</p>
     *         <p>
     *         For example: <code>Rule1</code>
     */
    public final String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * A statement that specifies the conditions for a matching rule.
     * </p>
     * <p>
     * If your data is accurate, use an Exact matching function: <code>Exact</code> or <code>ExactManyToMany</code>.
     * </p>
     * <p>
     * If your data has variations in spelling or pronunciation, use a Fuzzy matching function: <code>Cosine</code>,
     * <code>Levenshtein</code>, or <code>Soundex</code>.
     * </p>
     * <p>
     * Use operators if you want to combine (<code>AND</code>), separate (<code>OR</code>), or group matching functions
     * <code>(...)</code>.
     * </p>
     * <p>
     * For example: <code>(Cosine(a, 10) AND Exact(b, true)) OR ExactManyToMany(c, d)</code>
     * </p>
     * 
     * @return A statement that specifies the conditions for a matching rule.</p>
     *         <p>
     *         If your data is accurate, use an Exact matching function: <code>Exact</code> or
     *         <code>ExactManyToMany</code>.
     *         </p>
     *         <p>
     *         If your data has variations in spelling or pronunciation, use a Fuzzy matching function:
     *         <code>Cosine</code>, <code>Levenshtein</code>, or <code>Soundex</code>.
     *         </p>
     *         <p>
     *         Use operators if you want to combine (<code>AND</code>), separate (<code>OR</code>), or group matching
     *         functions <code>(...)</code>.
     *         </p>
     *         <p>
     *         For example: <code>(Cosine(a, 10) AND Exact(b, true)) OR ExactManyToMany(c, d)</code>
     */
    public final String condition() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleCondition)) {
            return false;
        }
        RuleCondition other = (RuleCondition) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(condition(), other.condition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleCondition").add("RuleName", ruleName()).add("Condition", condition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ruleName", RULE_NAME_FIELD);
        map.put("condition", CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleCondition, T> g) {
        return obj -> g.apply((RuleCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleCondition> {
        /**
         * <p>
         * A name for the matching rule.
         * </p>
         * <p>
         * For example: <code>Rule1</code>
         * </p>
         * 
         * @param ruleName
         *        A name for the matching rule.</p>
         *        <p>
         *        For example: <code>Rule1</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * A statement that specifies the conditions for a matching rule.
         * </p>
         * <p>
         * If your data is accurate, use an Exact matching function: <code>Exact</code> or <code>ExactManyToMany</code>.
         * </p>
         * <p>
         * If your data has variations in spelling or pronunciation, use a Fuzzy matching function: <code>Cosine</code>,
         * <code>Levenshtein</code>, or <code>Soundex</code>.
         * </p>
         * <p>
         * Use operators if you want to combine (<code>AND</code>), separate (<code>OR</code>), or group matching
         * functions <code>(...)</code>.
         * </p>
         * <p>
         * For example: <code>(Cosine(a, 10) AND Exact(b, true)) OR ExactManyToMany(c, d)</code>
         * </p>
         * 
         * @param condition
         *        A statement that specifies the conditions for a matching rule.</p>
         *        <p>
         *        If your data is accurate, use an Exact matching function: <code>Exact</code> or
         *        <code>ExactManyToMany</code>.
         *        </p>
         *        <p>
         *        If your data has variations in spelling or pronunciation, use a Fuzzy matching function:
         *        <code>Cosine</code>, <code>Levenshtein</code>, or <code>Soundex</code>.
         *        </p>
         *        <p>
         *        Use operators if you want to combine (<code>AND</code>), separate (<code>OR</code>), or group matching
         *        functions <code>(...)</code>.
         *        </p>
         *        <p>
         *        For example: <code>(Cosine(a, 10) AND Exact(b, true)) OR ExactManyToMany(c, d)</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(String condition);
    }

    static final class BuilderImpl implements Builder {
        private String ruleName;

        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleCondition model) {
            ruleName(model.ruleName);
            condition(model.condition);
        }

        public final String getRuleName() {
            return ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getCondition() {
            return condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public RuleCondition build() {
            return new RuleCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
