/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The identifiers of the provider service, from Data Exchange.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProviderMarketplaceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ProviderMarketplaceConfiguration.Builder, ProviderMarketplaceConfiguration> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSetId").getter(getter(ProviderMarketplaceConfiguration::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSetId").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(ProviderMarketplaceConfiguration::revisionId))
            .setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()).build();

    private static final SdkField<String> ASSET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetId").getter(getter(ProviderMarketplaceConfiguration::assetId)).setter(setter(Builder::assetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()).build();

    private static final SdkField<String> LISTING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listingId").getter(getter(ProviderMarketplaceConfiguration::listingId))
            .setter(setter(Builder::listingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD,
            REVISION_ID_FIELD, ASSET_ID_FIELD, LISTING_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dataSetId;

    private final String revisionId;

    private final String assetId;

    private final String listingId;

    private ProviderMarketplaceConfiguration(BuilderImpl builder) {
        this.dataSetId = builder.dataSetId;
        this.revisionId = builder.revisionId;
        this.assetId = builder.assetId;
        this.listingId = builder.listingId;
    }

    /**
     * <p>
     * The dataset ID on Data Exchange.
     * </p>
     * 
     * @return The dataset ID on Data Exchange.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * <p>
     * The revision ID on Data Exchange.
     * </p>
     * 
     * @return The revision ID on Data Exchange.
     */
    public final String revisionId() {
        return revisionId;
    }

    /**
     * <p>
     * The asset ID on Data Exchange.
     * </p>
     * 
     * @return The asset ID on Data Exchange.
     */
    public final String assetId() {
        return assetId;
    }

    /**
     * <p>
     * The listing ID on Data Exchange.
     * </p>
     * 
     * @return The listing ID on Data Exchange.
     */
    public final String listingId() {
        return listingId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(assetId());
        hashCode = 31 * hashCode + Objects.hashCode(listingId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProviderMarketplaceConfiguration)) {
            return false;
        }
        ProviderMarketplaceConfiguration other = (ProviderMarketplaceConfiguration) obj;
        return Objects.equals(dataSetId(), other.dataSetId()) && Objects.equals(revisionId(), other.revisionId())
                && Objects.equals(assetId(), other.assetId()) && Objects.equals(listingId(), other.listingId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProviderMarketplaceConfiguration").add("DataSetId", dataSetId()).add("RevisionId", revisionId())
                .add("AssetId", assetId()).add("ListingId", listingId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        case "assetId":
            return Optional.ofNullable(clazz.cast(assetId()));
        case "listingId":
            return Optional.ofNullable(clazz.cast(listingId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataSetId", DATA_SET_ID_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        map.put("assetId", ASSET_ID_FIELD);
        map.put("listingId", LISTING_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProviderMarketplaceConfiguration, T> g) {
        return obj -> g.apply((ProviderMarketplaceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProviderMarketplaceConfiguration> {
        /**
         * <p>
         * The dataset ID on Data Exchange.
         * </p>
         * 
         * @param dataSetId
         *        The dataset ID on Data Exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * The revision ID on Data Exchange.
         * </p>
         * 
         * @param revisionId
         *        The revision ID on Data Exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        /**
         * <p>
         * The asset ID on Data Exchange.
         * </p>
         * 
         * @param assetId
         *        The asset ID on Data Exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetId(String assetId);

        /**
         * <p>
         * The listing ID on Data Exchange.
         * </p>
         * 
         * @param listingId
         *        The listing ID on Data Exchange.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listingId(String listingId);
    }

    static final class BuilderImpl implements Builder {
        private String dataSetId;

        private String revisionId;

        private String assetId;

        private String listingId;

        private BuilderImpl() {
        }

        private BuilderImpl(ProviderMarketplaceConfiguration model) {
            dataSetId(model.dataSetId);
            revisionId(model.revisionId);
            assetId(model.assetId);
            listingId(model.listingId);
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getAssetId() {
            return assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getListingId() {
            return listingId;
        }

        public final void setListingId(String listingId) {
            this.listingId = listingId;
        }

        @Override
        public final Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        @Override
        public ProviderMarketplaceConfiguration build() {
            return new ProviderMarketplaceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
