/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains metrics about an ID mapping job, including counts of input records, processed records, and
 * mapped records between source and target identifiers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdMappingJobMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<IdMappingJobMetrics.Builder, IdMappingJobMetrics> {
    private static final SdkField<Integer> INPUT_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("inputRecords").getter(getter(IdMappingJobMetrics::inputRecords)).setter(setter(Builder::inputRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputRecords").build()).build();

    private static final SdkField<Integer> TOTAL_RECORDS_PROCESSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalRecordsProcessed").getter(getter(IdMappingJobMetrics::totalRecordsProcessed))
            .setter(setter(Builder::totalRecordsProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalRecordsProcessed").build())
            .build();

    private static final SdkField<Integer> RECORDS_NOT_PROCESSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("recordsNotProcessed").getter(getter(IdMappingJobMetrics::recordsNotProcessed))
            .setter(setter(Builder::recordsNotProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordsNotProcessed").build())
            .build();

    private static final SdkField<Integer> DELETE_RECORDS_PROCESSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("deleteRecordsProcessed").getter(getter(IdMappingJobMetrics::deleteRecordsProcessed))
            .setter(setter(Builder::deleteRecordsProcessed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteRecordsProcessed").build())
            .build();

    private static final SdkField<Integer> TOTAL_MAPPED_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalMappedRecords").getter(getter(IdMappingJobMetrics::totalMappedRecords))
            .setter(setter(Builder::totalMappedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalMappedRecords").build())
            .build();

    private static final SdkField<Integer> TOTAL_MAPPED_SOURCE_RECORDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("totalMappedSourceRecords")
            .getter(getter(IdMappingJobMetrics::totalMappedSourceRecords)).setter(setter(Builder::totalMappedSourceRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalMappedSourceRecords").build())
            .build();

    private static final SdkField<Integer> TOTAL_MAPPED_TARGET_RECORDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("totalMappedTargetRecords")
            .getter(getter(IdMappingJobMetrics::totalMappedTargetRecords)).setter(setter(Builder::totalMappedTargetRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalMappedTargetRecords").build())
            .build();

    private static final SdkField<Integer> UNIQUE_RECORDS_LOADED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("uniqueRecordsLoaded").getter(getter(IdMappingJobMetrics::uniqueRecordsLoaded))
            .setter(setter(Builder::uniqueRecordsLoaded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueRecordsLoaded").build())
            .build();

    private static final SdkField<Integer> NEW_MAPPED_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("newMappedRecords").getter(getter(IdMappingJobMetrics::newMappedRecords))
            .setter(setter(Builder::newMappedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newMappedRecords").build()).build();

    private static final SdkField<Integer> NEW_MAPPED_SOURCE_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("newMappedSourceRecords").getter(getter(IdMappingJobMetrics::newMappedSourceRecords))
            .setter(setter(Builder::newMappedSourceRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newMappedSourceRecords").build())
            .build();

    private static final SdkField<Integer> NEW_MAPPED_TARGET_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("newMappedTargetRecords").getter(getter(IdMappingJobMetrics::newMappedTargetRecords))
            .setter(setter(Builder::newMappedTargetRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newMappedTargetRecords").build())
            .build();

    private static final SdkField<Integer> NEW_UNIQUE_RECORDS_LOADED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("newUniqueRecordsLoaded").getter(getter(IdMappingJobMetrics::newUniqueRecordsLoaded))
            .setter(setter(Builder::newUniqueRecordsLoaded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newUniqueRecordsLoaded").build())
            .build();

    private static final SdkField<Integer> MAPPED_RECORDS_REMOVED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("mappedRecordsRemoved").getter(getter(IdMappingJobMetrics::mappedRecordsRemoved))
            .setter(setter(Builder::mappedRecordsRemoved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappedRecordsRemoved").build())
            .build();

    private static final SdkField<Integer> MAPPED_SOURCE_RECORDS_REMOVED_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("mappedSourceRecordsRemoved")
            .getter(getter(IdMappingJobMetrics::mappedSourceRecordsRemoved))
            .setter(setter(Builder::mappedSourceRecordsRemoved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappedSourceRecordsRemoved").build())
            .build();

    private static final SdkField<Integer> MAPPED_TARGET_RECORDS_REMOVED_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("mappedTargetRecordsRemoved")
            .getter(getter(IdMappingJobMetrics::mappedTargetRecordsRemoved))
            .setter(setter(Builder::mappedTargetRecordsRemoved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mappedTargetRecordsRemoved").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_RECORDS_FIELD,
            TOTAL_RECORDS_PROCESSED_FIELD, RECORDS_NOT_PROCESSED_FIELD, DELETE_RECORDS_PROCESSED_FIELD,
            TOTAL_MAPPED_RECORDS_FIELD, TOTAL_MAPPED_SOURCE_RECORDS_FIELD, TOTAL_MAPPED_TARGET_RECORDS_FIELD,
            UNIQUE_RECORDS_LOADED_FIELD, NEW_MAPPED_RECORDS_FIELD, NEW_MAPPED_SOURCE_RECORDS_FIELD,
            NEW_MAPPED_TARGET_RECORDS_FIELD, NEW_UNIQUE_RECORDS_LOADED_FIELD, MAPPED_RECORDS_REMOVED_FIELD,
            MAPPED_SOURCE_RECORDS_REMOVED_FIELD, MAPPED_TARGET_RECORDS_REMOVED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer inputRecords;

    private final Integer totalRecordsProcessed;

    private final Integer recordsNotProcessed;

    private final Integer deleteRecordsProcessed;

    private final Integer totalMappedRecords;

    private final Integer totalMappedSourceRecords;

    private final Integer totalMappedTargetRecords;

    private final Integer uniqueRecordsLoaded;

    private final Integer newMappedRecords;

    private final Integer newMappedSourceRecords;

    private final Integer newMappedTargetRecords;

    private final Integer newUniqueRecordsLoaded;

    private final Integer mappedRecordsRemoved;

    private final Integer mappedSourceRecordsRemoved;

    private final Integer mappedTargetRecordsRemoved;

    private IdMappingJobMetrics(BuilderImpl builder) {
        this.inputRecords = builder.inputRecords;
        this.totalRecordsProcessed = builder.totalRecordsProcessed;
        this.recordsNotProcessed = builder.recordsNotProcessed;
        this.deleteRecordsProcessed = builder.deleteRecordsProcessed;
        this.totalMappedRecords = builder.totalMappedRecords;
        this.totalMappedSourceRecords = builder.totalMappedSourceRecords;
        this.totalMappedTargetRecords = builder.totalMappedTargetRecords;
        this.uniqueRecordsLoaded = builder.uniqueRecordsLoaded;
        this.newMappedRecords = builder.newMappedRecords;
        this.newMappedSourceRecords = builder.newMappedSourceRecords;
        this.newMappedTargetRecords = builder.newMappedTargetRecords;
        this.newUniqueRecordsLoaded = builder.newUniqueRecordsLoaded;
        this.mappedRecordsRemoved = builder.mappedRecordsRemoved;
        this.mappedSourceRecordsRemoved = builder.mappedSourceRecordsRemoved;
        this.mappedTargetRecordsRemoved = builder.mappedTargetRecordsRemoved;
    }

    /**
     * <p>
     * The total number of records that were input for processing.
     * </p>
     * 
     * @return The total number of records that were input for processing.
     */
    public final Integer inputRecords() {
        return inputRecords;
    }

    /**
     * <p>
     * The total number of records that were processed.
     * </p>
     * 
     * @return The total number of records that were processed.
     */
    public final Integer totalRecordsProcessed() {
        return totalRecordsProcessed;
    }

    /**
     * <p>
     * The total number of records that did not get processed.
     * </p>
     * 
     * @return The total number of records that did not get processed.
     */
    public final Integer recordsNotProcessed() {
        return recordsNotProcessed;
    }

    /**
     * <p>
     * The number of records processed that were marked for deletion in the input file using the DELETE schema mapping
     * field. These are the records to be removed from the ID mapping table.
     * </p>
     * 
     * @return The number of records processed that were marked for deletion in the input file using the DELETE schema
     *         mapping field. These are the records to be removed from the ID mapping table.
     */
    public final Integer deleteRecordsProcessed() {
        return deleteRecordsProcessed;
    }

    /**
     * <p>
     * The total number of records that were mapped.
     * </p>
     * 
     * @return The total number of records that were mapped.
     */
    public final Integer totalMappedRecords() {
        return totalMappedRecords;
    }

    /**
     * <p>
     * The total number of mapped source records.
     * </p>
     * 
     * @return The total number of mapped source records.
     */
    public final Integer totalMappedSourceRecords() {
        return totalMappedSourceRecords;
    }

    /**
     * <p>
     * The total number of distinct mapped target records.
     * </p>
     * 
     * @return The total number of distinct mapped target records.
     */
    public final Integer totalMappedTargetRecords() {
        return totalMappedTargetRecords;
    }

    /**
     * <p>
     * The number of de-duplicated processed records across all runs, excluding deletion-related records. Duplicates are
     * determined by the field marked as UNIQUE_ID in your schema mapping. Records sharing the same value in this field
     * are considered duplicates. For example, if you specified "customer_id" as a UNIQUE_ID field and had three records
     * with the same customer_id value, they would count as one unique record in this metric.
     * </p>
     * 
     * @return The number of de-duplicated processed records across all runs, excluding deletion-related records.
     *         Duplicates are determined by the field marked as UNIQUE_ID in your schema mapping. Records sharing the
     *         same value in this field are considered duplicates. For example, if you specified "customer_id" as a
     *         UNIQUE_ID field and had three records with the same customer_id value, they would count as one unique
     *         record in this metric.
     */
    public final Integer uniqueRecordsLoaded() {
        return uniqueRecordsLoaded;
    }

    /**
     * <p>
     * The number of new mapped records.
     * </p>
     * 
     * @return The number of new mapped records.
     */
    public final Integer newMappedRecords() {
        return newMappedRecords;
    }

    /**
     * <p>
     * The number of new source records mapped.
     * </p>
     * 
     * @return The number of new source records mapped.
     */
    public final Integer newMappedSourceRecords() {
        return newMappedSourceRecords;
    }

    /**
     * <p>
     * The number of new mapped target records.
     * </p>
     * 
     * @return The number of new mapped target records.
     */
    public final Integer newMappedTargetRecords() {
        return newMappedTargetRecords;
    }

    /**
     * <p>
     * The number of new unique records processed in the current job run, after removing duplicates. This metric
     * excludes deletion-related records. Duplicates are determined by the field marked as UNIQUE_ID in your schema
     * mapping. Records sharing the same value in this field are considered duplicates. For example, if your current run
     * processes five new records with the same UNIQUE_ID value, they would count as one new unique record in this
     * metric.
     * </p>
     * 
     * @return The number of new unique records processed in the current job run, after removing duplicates. This metric
     *         excludes deletion-related records. Duplicates are determined by the field marked as UNIQUE_ID in your
     *         schema mapping. Records sharing the same value in this field are considered duplicates. For example, if
     *         your current run processes five new records with the same UNIQUE_ID value, they would count as one new
     *         unique record in this metric.
     */
    public final Integer newUniqueRecordsLoaded() {
        return newUniqueRecordsLoaded;
    }

    /**
     * <p>
     * The number of mapped records removed.
     * </p>
     * 
     * @return The number of mapped records removed.
     */
    public final Integer mappedRecordsRemoved() {
        return mappedRecordsRemoved;
    }

    /**
     * <p>
     * The number of source records removed due to ID mapping.
     * </p>
     * 
     * @return The number of source records removed due to ID mapping.
     */
    public final Integer mappedSourceRecordsRemoved() {
        return mappedSourceRecordsRemoved;
    }

    /**
     * <p>
     * The number of mapped target records removed.
     * </p>
     * 
     * @return The number of mapped target records removed.
     */
    public final Integer mappedTargetRecordsRemoved() {
        return mappedTargetRecordsRemoved;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputRecords());
        hashCode = 31 * hashCode + Objects.hashCode(totalRecordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(recordsNotProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(deleteRecordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(totalMappedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(totalMappedSourceRecords());
        hashCode = 31 * hashCode + Objects.hashCode(totalMappedTargetRecords());
        hashCode = 31 * hashCode + Objects.hashCode(uniqueRecordsLoaded());
        hashCode = 31 * hashCode + Objects.hashCode(newMappedRecords());
        hashCode = 31 * hashCode + Objects.hashCode(newMappedSourceRecords());
        hashCode = 31 * hashCode + Objects.hashCode(newMappedTargetRecords());
        hashCode = 31 * hashCode + Objects.hashCode(newUniqueRecordsLoaded());
        hashCode = 31 * hashCode + Objects.hashCode(mappedRecordsRemoved());
        hashCode = 31 * hashCode + Objects.hashCode(mappedSourceRecordsRemoved());
        hashCode = 31 * hashCode + Objects.hashCode(mappedTargetRecordsRemoved());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdMappingJobMetrics)) {
            return false;
        }
        IdMappingJobMetrics other = (IdMappingJobMetrics) obj;
        return Objects.equals(inputRecords(), other.inputRecords())
                && Objects.equals(totalRecordsProcessed(), other.totalRecordsProcessed())
                && Objects.equals(recordsNotProcessed(), other.recordsNotProcessed())
                && Objects.equals(deleteRecordsProcessed(), other.deleteRecordsProcessed())
                && Objects.equals(totalMappedRecords(), other.totalMappedRecords())
                && Objects.equals(totalMappedSourceRecords(), other.totalMappedSourceRecords())
                && Objects.equals(totalMappedTargetRecords(), other.totalMappedTargetRecords())
                && Objects.equals(uniqueRecordsLoaded(), other.uniqueRecordsLoaded())
                && Objects.equals(newMappedRecords(), other.newMappedRecords())
                && Objects.equals(newMappedSourceRecords(), other.newMappedSourceRecords())
                && Objects.equals(newMappedTargetRecords(), other.newMappedTargetRecords())
                && Objects.equals(newUniqueRecordsLoaded(), other.newUniqueRecordsLoaded())
                && Objects.equals(mappedRecordsRemoved(), other.mappedRecordsRemoved())
                && Objects.equals(mappedSourceRecordsRemoved(), other.mappedSourceRecordsRemoved())
                && Objects.equals(mappedTargetRecordsRemoved(), other.mappedTargetRecordsRemoved());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdMappingJobMetrics").add("InputRecords", inputRecords())
                .add("TotalRecordsProcessed", totalRecordsProcessed()).add("RecordsNotProcessed", recordsNotProcessed())
                .add("DeleteRecordsProcessed", deleteRecordsProcessed()).add("TotalMappedRecords", totalMappedRecords())
                .add("TotalMappedSourceRecords", totalMappedSourceRecords())
                .add("TotalMappedTargetRecords", totalMappedTargetRecords()).add("UniqueRecordsLoaded", uniqueRecordsLoaded())
                .add("NewMappedRecords", newMappedRecords()).add("NewMappedSourceRecords", newMappedSourceRecords())
                .add("NewMappedTargetRecords", newMappedTargetRecords()).add("NewUniqueRecordsLoaded", newUniqueRecordsLoaded())
                .add("MappedRecordsRemoved", mappedRecordsRemoved())
                .add("MappedSourceRecordsRemoved", mappedSourceRecordsRemoved())
                .add("MappedTargetRecordsRemoved", mappedTargetRecordsRemoved()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputRecords":
            return Optional.ofNullable(clazz.cast(inputRecords()));
        case "totalRecordsProcessed":
            return Optional.ofNullable(clazz.cast(totalRecordsProcessed()));
        case "recordsNotProcessed":
            return Optional.ofNullable(clazz.cast(recordsNotProcessed()));
        case "deleteRecordsProcessed":
            return Optional.ofNullable(clazz.cast(deleteRecordsProcessed()));
        case "totalMappedRecords":
            return Optional.ofNullable(clazz.cast(totalMappedRecords()));
        case "totalMappedSourceRecords":
            return Optional.ofNullable(clazz.cast(totalMappedSourceRecords()));
        case "totalMappedTargetRecords":
            return Optional.ofNullable(clazz.cast(totalMappedTargetRecords()));
        case "uniqueRecordsLoaded":
            return Optional.ofNullable(clazz.cast(uniqueRecordsLoaded()));
        case "newMappedRecords":
            return Optional.ofNullable(clazz.cast(newMappedRecords()));
        case "newMappedSourceRecords":
            return Optional.ofNullable(clazz.cast(newMappedSourceRecords()));
        case "newMappedTargetRecords":
            return Optional.ofNullable(clazz.cast(newMappedTargetRecords()));
        case "newUniqueRecordsLoaded":
            return Optional.ofNullable(clazz.cast(newUniqueRecordsLoaded()));
        case "mappedRecordsRemoved":
            return Optional.ofNullable(clazz.cast(mappedRecordsRemoved()));
        case "mappedSourceRecordsRemoved":
            return Optional.ofNullable(clazz.cast(mappedSourceRecordsRemoved()));
        case "mappedTargetRecordsRemoved":
            return Optional.ofNullable(clazz.cast(mappedTargetRecordsRemoved()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputRecords", INPUT_RECORDS_FIELD);
        map.put("totalRecordsProcessed", TOTAL_RECORDS_PROCESSED_FIELD);
        map.put("recordsNotProcessed", RECORDS_NOT_PROCESSED_FIELD);
        map.put("deleteRecordsProcessed", DELETE_RECORDS_PROCESSED_FIELD);
        map.put("totalMappedRecords", TOTAL_MAPPED_RECORDS_FIELD);
        map.put("totalMappedSourceRecords", TOTAL_MAPPED_SOURCE_RECORDS_FIELD);
        map.put("totalMappedTargetRecords", TOTAL_MAPPED_TARGET_RECORDS_FIELD);
        map.put("uniqueRecordsLoaded", UNIQUE_RECORDS_LOADED_FIELD);
        map.put("newMappedRecords", NEW_MAPPED_RECORDS_FIELD);
        map.put("newMappedSourceRecords", NEW_MAPPED_SOURCE_RECORDS_FIELD);
        map.put("newMappedTargetRecords", NEW_MAPPED_TARGET_RECORDS_FIELD);
        map.put("newUniqueRecordsLoaded", NEW_UNIQUE_RECORDS_LOADED_FIELD);
        map.put("mappedRecordsRemoved", MAPPED_RECORDS_REMOVED_FIELD);
        map.put("mappedSourceRecordsRemoved", MAPPED_SOURCE_RECORDS_REMOVED_FIELD);
        map.put("mappedTargetRecordsRemoved", MAPPED_TARGET_RECORDS_REMOVED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IdMappingJobMetrics, T> g) {
        return obj -> g.apply((IdMappingJobMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdMappingJobMetrics> {
        /**
         * <p>
         * The total number of records that were input for processing.
         * </p>
         * 
         * @param inputRecords
         *        The total number of records that were input for processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputRecords(Integer inputRecords);

        /**
         * <p>
         * The total number of records that were processed.
         * </p>
         * 
         * @param totalRecordsProcessed
         *        The total number of records that were processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRecordsProcessed(Integer totalRecordsProcessed);

        /**
         * <p>
         * The total number of records that did not get processed.
         * </p>
         * 
         * @param recordsNotProcessed
         *        The total number of records that did not get processed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordsNotProcessed(Integer recordsNotProcessed);

        /**
         * <p>
         * The number of records processed that were marked for deletion in the input file using the DELETE schema
         * mapping field. These are the records to be removed from the ID mapping table.
         * </p>
         * 
         * @param deleteRecordsProcessed
         *        The number of records processed that were marked for deletion in the input file using the DELETE
         *        schema mapping field. These are the records to be removed from the ID mapping table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteRecordsProcessed(Integer deleteRecordsProcessed);

        /**
         * <p>
         * The total number of records that were mapped.
         * </p>
         * 
         * @param totalMappedRecords
         *        The total number of records that were mapped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalMappedRecords(Integer totalMappedRecords);

        /**
         * <p>
         * The total number of mapped source records.
         * </p>
         * 
         * @param totalMappedSourceRecords
         *        The total number of mapped source records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalMappedSourceRecords(Integer totalMappedSourceRecords);

        /**
         * <p>
         * The total number of distinct mapped target records.
         * </p>
         * 
         * @param totalMappedTargetRecords
         *        The total number of distinct mapped target records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalMappedTargetRecords(Integer totalMappedTargetRecords);

        /**
         * <p>
         * The number of de-duplicated processed records across all runs, excluding deletion-related records. Duplicates
         * are determined by the field marked as UNIQUE_ID in your schema mapping. Records sharing the same value in
         * this field are considered duplicates. For example, if you specified "customer_id" as a UNIQUE_ID field and
         * had three records with the same customer_id value, they would count as one unique record in this metric.
         * </p>
         * 
         * @param uniqueRecordsLoaded
         *        The number of de-duplicated processed records across all runs, excluding deletion-related records.
         *        Duplicates are determined by the field marked as UNIQUE_ID in your schema mapping. Records sharing the
         *        same value in this field are considered duplicates. For example, if you specified "customer_id" as a
         *        UNIQUE_ID field and had three records with the same customer_id value, they would count as one unique
         *        record in this metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uniqueRecordsLoaded(Integer uniqueRecordsLoaded);

        /**
         * <p>
         * The number of new mapped records.
         * </p>
         * 
         * @param newMappedRecords
         *        The number of new mapped records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newMappedRecords(Integer newMappedRecords);

        /**
         * <p>
         * The number of new source records mapped.
         * </p>
         * 
         * @param newMappedSourceRecords
         *        The number of new source records mapped.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newMappedSourceRecords(Integer newMappedSourceRecords);

        /**
         * <p>
         * The number of new mapped target records.
         * </p>
         * 
         * @param newMappedTargetRecords
         *        The number of new mapped target records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newMappedTargetRecords(Integer newMappedTargetRecords);

        /**
         * <p>
         * The number of new unique records processed in the current job run, after removing duplicates. This metric
         * excludes deletion-related records. Duplicates are determined by the field marked as UNIQUE_ID in your schema
         * mapping. Records sharing the same value in this field are considered duplicates. For example, if your current
         * run processes five new records with the same UNIQUE_ID value, they would count as one new unique record in
         * this metric.
         * </p>
         * 
         * @param newUniqueRecordsLoaded
         *        The number of new unique records processed in the current job run, after removing duplicates. This
         *        metric excludes deletion-related records. Duplicates are determined by the field marked as UNIQUE_ID
         *        in your schema mapping. Records sharing the same value in this field are considered duplicates. For
         *        example, if your current run processes five new records with the same UNIQUE_ID value, they would
         *        count as one new unique record in this metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newUniqueRecordsLoaded(Integer newUniqueRecordsLoaded);

        /**
         * <p>
         * The number of mapped records removed.
         * </p>
         * 
         * @param mappedRecordsRemoved
         *        The number of mapped records removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappedRecordsRemoved(Integer mappedRecordsRemoved);

        /**
         * <p>
         * The number of source records removed due to ID mapping.
         * </p>
         * 
         * @param mappedSourceRecordsRemoved
         *        The number of source records removed due to ID mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappedSourceRecordsRemoved(Integer mappedSourceRecordsRemoved);

        /**
         * <p>
         * The number of mapped target records removed.
         * </p>
         * 
         * @param mappedTargetRecordsRemoved
         *        The number of mapped target records removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappedTargetRecordsRemoved(Integer mappedTargetRecordsRemoved);
    }

    static final class BuilderImpl implements Builder {
        private Integer inputRecords;

        private Integer totalRecordsProcessed;

        private Integer recordsNotProcessed;

        private Integer deleteRecordsProcessed;

        private Integer totalMappedRecords;

        private Integer totalMappedSourceRecords;

        private Integer totalMappedTargetRecords;

        private Integer uniqueRecordsLoaded;

        private Integer newMappedRecords;

        private Integer newMappedSourceRecords;

        private Integer newMappedTargetRecords;

        private Integer newUniqueRecordsLoaded;

        private Integer mappedRecordsRemoved;

        private Integer mappedSourceRecordsRemoved;

        private Integer mappedTargetRecordsRemoved;

        private BuilderImpl() {
        }

        private BuilderImpl(IdMappingJobMetrics model) {
            inputRecords(model.inputRecords);
            totalRecordsProcessed(model.totalRecordsProcessed);
            recordsNotProcessed(model.recordsNotProcessed);
            deleteRecordsProcessed(model.deleteRecordsProcessed);
            totalMappedRecords(model.totalMappedRecords);
            totalMappedSourceRecords(model.totalMappedSourceRecords);
            totalMappedTargetRecords(model.totalMappedTargetRecords);
            uniqueRecordsLoaded(model.uniqueRecordsLoaded);
            newMappedRecords(model.newMappedRecords);
            newMappedSourceRecords(model.newMappedSourceRecords);
            newMappedTargetRecords(model.newMappedTargetRecords);
            newUniqueRecordsLoaded(model.newUniqueRecordsLoaded);
            mappedRecordsRemoved(model.mappedRecordsRemoved);
            mappedSourceRecordsRemoved(model.mappedSourceRecordsRemoved);
            mappedTargetRecordsRemoved(model.mappedTargetRecordsRemoved);
        }

        public final Integer getInputRecords() {
            return inputRecords;
        }

        public final void setInputRecords(Integer inputRecords) {
            this.inputRecords = inputRecords;
        }

        @Override
        public final Builder inputRecords(Integer inputRecords) {
            this.inputRecords = inputRecords;
            return this;
        }

        public final Integer getTotalRecordsProcessed() {
            return totalRecordsProcessed;
        }

        public final void setTotalRecordsProcessed(Integer totalRecordsProcessed) {
            this.totalRecordsProcessed = totalRecordsProcessed;
        }

        @Override
        public final Builder totalRecordsProcessed(Integer totalRecordsProcessed) {
            this.totalRecordsProcessed = totalRecordsProcessed;
            return this;
        }

        public final Integer getRecordsNotProcessed() {
            return recordsNotProcessed;
        }

        public final void setRecordsNotProcessed(Integer recordsNotProcessed) {
            this.recordsNotProcessed = recordsNotProcessed;
        }

        @Override
        public final Builder recordsNotProcessed(Integer recordsNotProcessed) {
            this.recordsNotProcessed = recordsNotProcessed;
            return this;
        }

        public final Integer getDeleteRecordsProcessed() {
            return deleteRecordsProcessed;
        }

        public final void setDeleteRecordsProcessed(Integer deleteRecordsProcessed) {
            this.deleteRecordsProcessed = deleteRecordsProcessed;
        }

        @Override
        public final Builder deleteRecordsProcessed(Integer deleteRecordsProcessed) {
            this.deleteRecordsProcessed = deleteRecordsProcessed;
            return this;
        }

        public final Integer getTotalMappedRecords() {
            return totalMappedRecords;
        }

        public final void setTotalMappedRecords(Integer totalMappedRecords) {
            this.totalMappedRecords = totalMappedRecords;
        }

        @Override
        public final Builder totalMappedRecords(Integer totalMappedRecords) {
            this.totalMappedRecords = totalMappedRecords;
            return this;
        }

        public final Integer getTotalMappedSourceRecords() {
            return totalMappedSourceRecords;
        }

        public final void setTotalMappedSourceRecords(Integer totalMappedSourceRecords) {
            this.totalMappedSourceRecords = totalMappedSourceRecords;
        }

        @Override
        public final Builder totalMappedSourceRecords(Integer totalMappedSourceRecords) {
            this.totalMappedSourceRecords = totalMappedSourceRecords;
            return this;
        }

        public final Integer getTotalMappedTargetRecords() {
            return totalMappedTargetRecords;
        }

        public final void setTotalMappedTargetRecords(Integer totalMappedTargetRecords) {
            this.totalMappedTargetRecords = totalMappedTargetRecords;
        }

        @Override
        public final Builder totalMappedTargetRecords(Integer totalMappedTargetRecords) {
            this.totalMappedTargetRecords = totalMappedTargetRecords;
            return this;
        }

        public final Integer getUniqueRecordsLoaded() {
            return uniqueRecordsLoaded;
        }

        public final void setUniqueRecordsLoaded(Integer uniqueRecordsLoaded) {
            this.uniqueRecordsLoaded = uniqueRecordsLoaded;
        }

        @Override
        public final Builder uniqueRecordsLoaded(Integer uniqueRecordsLoaded) {
            this.uniqueRecordsLoaded = uniqueRecordsLoaded;
            return this;
        }

        public final Integer getNewMappedRecords() {
            return newMappedRecords;
        }

        public final void setNewMappedRecords(Integer newMappedRecords) {
            this.newMappedRecords = newMappedRecords;
        }

        @Override
        public final Builder newMappedRecords(Integer newMappedRecords) {
            this.newMappedRecords = newMappedRecords;
            return this;
        }

        public final Integer getNewMappedSourceRecords() {
            return newMappedSourceRecords;
        }

        public final void setNewMappedSourceRecords(Integer newMappedSourceRecords) {
            this.newMappedSourceRecords = newMappedSourceRecords;
        }

        @Override
        public final Builder newMappedSourceRecords(Integer newMappedSourceRecords) {
            this.newMappedSourceRecords = newMappedSourceRecords;
            return this;
        }

        public final Integer getNewMappedTargetRecords() {
            return newMappedTargetRecords;
        }

        public final void setNewMappedTargetRecords(Integer newMappedTargetRecords) {
            this.newMappedTargetRecords = newMappedTargetRecords;
        }

        @Override
        public final Builder newMappedTargetRecords(Integer newMappedTargetRecords) {
            this.newMappedTargetRecords = newMappedTargetRecords;
            return this;
        }

        public final Integer getNewUniqueRecordsLoaded() {
            return newUniqueRecordsLoaded;
        }

        public final void setNewUniqueRecordsLoaded(Integer newUniqueRecordsLoaded) {
            this.newUniqueRecordsLoaded = newUniqueRecordsLoaded;
        }

        @Override
        public final Builder newUniqueRecordsLoaded(Integer newUniqueRecordsLoaded) {
            this.newUniqueRecordsLoaded = newUniqueRecordsLoaded;
            return this;
        }

        public final Integer getMappedRecordsRemoved() {
            return mappedRecordsRemoved;
        }

        public final void setMappedRecordsRemoved(Integer mappedRecordsRemoved) {
            this.mappedRecordsRemoved = mappedRecordsRemoved;
        }

        @Override
        public final Builder mappedRecordsRemoved(Integer mappedRecordsRemoved) {
            this.mappedRecordsRemoved = mappedRecordsRemoved;
            return this;
        }

        public final Integer getMappedSourceRecordsRemoved() {
            return mappedSourceRecordsRemoved;
        }

        public final void setMappedSourceRecordsRemoved(Integer mappedSourceRecordsRemoved) {
            this.mappedSourceRecordsRemoved = mappedSourceRecordsRemoved;
        }

        @Override
        public final Builder mappedSourceRecordsRemoved(Integer mappedSourceRecordsRemoved) {
            this.mappedSourceRecordsRemoved = mappedSourceRecordsRemoved;
            return this;
        }

        public final Integer getMappedTargetRecordsRemoved() {
            return mappedTargetRecordsRemoved;
        }

        public final void setMappedTargetRecordsRemoved(Integer mappedTargetRecordsRemoved) {
            this.mappedTargetRecordsRemoved = mappedTargetRecordsRemoved;
        }

        @Override
        public final Builder mappedTargetRecordsRemoved(Integer mappedTargetRecordsRemoved) {
            this.mappedTargetRecordsRemoved = mappedTargetRecordsRemoved;
            return this;
        }

        @Override
        public IdMappingJobMetrics build() {
            return new IdMappingJobMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
