/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.AttributeMatchingModel;
import software.amazon.awssdk.services.entityresolution.model.MatchPurpose;
import software.amazon.awssdk.services.entityresolution.model.Rule;
import software.amazon.awssdk.services.entityresolution.model.RuleBasedPropertiesRulesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleBasedProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleBasedProperties> {
    private static final SdkField<List<Rule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(RuleBasedProperties.getter(RuleBasedProperties::rules)).setter(RuleBasedProperties.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Rule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ATTRIBUTE_MATCHING_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attributeMatchingModel").getter(RuleBasedProperties.getter(RuleBasedProperties::attributeMatchingModelAsString)).setter(RuleBasedProperties.setter(Builder::attributeMatchingModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeMatchingModel").build()}).build();
    private static final SdkField<String> MATCH_PURPOSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("matchPurpose").getter(RuleBasedProperties.getter(RuleBasedProperties::matchPurposeAsString)).setter(RuleBasedProperties.setter(Builder::matchPurpose)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchPurpose").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD, ATTRIBUTE_MATCHING_MODEL_FIELD, MATCH_PURPOSE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleBasedProperties.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Rule> rules;
    private final String attributeMatchingModel;
    private final String matchPurpose;

    private RuleBasedProperties(BuilderImpl builder) {
        this.rules = builder.rules;
        this.attributeMatchingModel = builder.attributeMatchingModel;
        this.matchPurpose = builder.matchPurpose;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<Rule> rules() {
        return this.rules;
    }

    public final AttributeMatchingModel attributeMatchingModel() {
        return AttributeMatchingModel.fromValue(this.attributeMatchingModel);
    }

    public final String attributeMatchingModelAsString() {
        return this.attributeMatchingModel;
    }

    public final MatchPurpose matchPurpose() {
        return MatchPurpose.fromValue(this.matchPurpose);
    }

    public final String matchPurposeAsString() {
        return this.matchPurpose;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeMatchingModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchPurposeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleBasedProperties)) {
            return false;
        }
        RuleBasedProperties other = (RuleBasedProperties)obj;
        return this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.attributeMatchingModelAsString(), other.attributeMatchingModelAsString()) && Objects.equals(this.matchPurposeAsString(), other.matchPurposeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RuleBasedProperties").add("Rules", this.hasRules() ? this.rules() : null).add("AttributeMatchingModel", (Object)this.attributeMatchingModelAsString()).add("MatchPurpose", (Object)this.matchPurposeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "attributeMatchingModel": {
                return Optional.ofNullable(clazz.cast(this.attributeMatchingModelAsString()));
            }
            case "matchPurpose": {
                return Optional.ofNullable(clazz.cast(this.matchPurposeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rules", RULES_FIELD);
        map.put("attributeMatchingModel", ATTRIBUTE_MATCHING_MODEL_FIELD);
        map.put("matchPurpose", MATCH_PURPOSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleBasedProperties, T> g) {
        return obj -> g.apply((RuleBasedProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Rule> rules = DefaultSdkAutoConstructList.getInstance();
        private String attributeMatchingModel;
        private String matchPurpose;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleBasedProperties model) {
            this.rules(model.rules);
            this.attributeMatchingModel(model.attributeMatchingModel);
            this.matchPurpose(model.matchPurpose);
        }

        public final List<Rule.Builder> getRules() {
            List<Rule.Builder> result = RuleBasedPropertiesRulesListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<Rule.BuilderImpl> rules) {
            this.rules = RuleBasedPropertiesRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<Rule> rules) {
            this.rules = RuleBasedPropertiesRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Rule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<Rule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (Rule)((Rule.Builder)Rule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAttributeMatchingModel() {
            return this.attributeMatchingModel;
        }

        public final void setAttributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
        }

        @Override
        public final Builder attributeMatchingModel(String attributeMatchingModel) {
            this.attributeMatchingModel = attributeMatchingModel;
            return this;
        }

        @Override
        public final Builder attributeMatchingModel(AttributeMatchingModel attributeMatchingModel) {
            this.attributeMatchingModel(attributeMatchingModel == null ? null : attributeMatchingModel.toString());
            return this;
        }

        public final String getMatchPurpose() {
            return this.matchPurpose;
        }

        public final void setMatchPurpose(String matchPurpose) {
            this.matchPurpose = matchPurpose;
        }

        @Override
        public final Builder matchPurpose(String matchPurpose) {
            this.matchPurpose = matchPurpose;
            return this;
        }

        @Override
        public final Builder matchPurpose(MatchPurpose matchPurpose) {
            this.matchPurpose(matchPurpose == null ? null : matchPurpose.toString());
            return this;
        }

        public RuleBasedProperties build() {
            return new RuleBasedProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleBasedProperties> {
        public Builder rules(Collection<Rule> var1);

        public Builder rules(Rule ... var1);

        public Builder rules(Consumer<Rule.Builder> ... var1);

        public Builder attributeMatchingModel(String var1);

        public Builder attributeMatchingModel(AttributeMatchingModel var1);

        public Builder matchPurpose(String var1);

        public Builder matchPurpose(MatchPurpose var1);
    }
}

