/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.entityresolution.model.EntityResolutionResponse;
import software.amazon.awssdk.services.entityresolution.model.ProviderServiceListCopier;
import software.amazon.awssdk.services.entityresolution.model.ProviderServiceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProviderServicesResponse
extends EntityResolutionResponse
implements ToCopyableBuilder<Builder, ListProviderServicesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListProviderServicesResponse.getter(ListProviderServicesResponse::nextToken)).setter(ListProviderServicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ProviderServiceSummary>> PROVIDER_SERVICE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("providerServiceSummaries").getter(ListProviderServicesResponse.getter(ListProviderServicesResponse::providerServiceSummaries)).setter(ListProviderServicesResponse.setter(Builder::providerServiceSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerServiceSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProviderServiceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PROVIDER_SERVICE_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListProviderServicesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ProviderServiceSummary> providerServiceSummaries;

    private ListProviderServicesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.providerServiceSummaries = builder.providerServiceSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasProviderServiceSummaries() {
        return this.providerServiceSummaries != null && !(this.providerServiceSummaries instanceof SdkAutoConstructList);
    }

    public final List<ProviderServiceSummary> providerServiceSummaries() {
        return this.providerServiceSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProviderServiceSummaries() ? this.providerServiceSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProviderServicesResponse)) {
            return false;
        }
        ListProviderServicesResponse other = (ListProviderServicesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasProviderServiceSummaries() == other.hasProviderServiceSummaries() && Objects.equals(this.providerServiceSummaries(), other.providerServiceSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListProviderServicesResponse").add("NextToken", (Object)this.nextToken()).add("ProviderServiceSummaries", this.hasProviderServiceSummaries() ? this.providerServiceSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "providerServiceSummaries": {
                return Optional.ofNullable(clazz.cast(this.providerServiceSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("providerServiceSummaries", PROVIDER_SERVICE_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListProviderServicesResponse, T> g) {
        return obj -> g.apply((ListProviderServicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EntityResolutionResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ProviderServiceSummary> providerServiceSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProviderServicesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.providerServiceSummaries(model.providerServiceSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ProviderServiceSummary.Builder> getProviderServiceSummaries() {
            List<ProviderServiceSummary.Builder> result = ProviderServiceListCopier.copyToBuilder(this.providerServiceSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProviderServiceSummaries(Collection<ProviderServiceSummary.BuilderImpl> providerServiceSummaries) {
            this.providerServiceSummaries = ProviderServiceListCopier.copyFromBuilder(providerServiceSummaries);
        }

        @Override
        public final Builder providerServiceSummaries(Collection<ProviderServiceSummary> providerServiceSummaries) {
            this.providerServiceSummaries = ProviderServiceListCopier.copy(providerServiceSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerServiceSummaries(ProviderServiceSummary ... providerServiceSummaries) {
            this.providerServiceSummaries(Arrays.asList(providerServiceSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder providerServiceSummaries(Consumer<ProviderServiceSummary.Builder> ... providerServiceSummaries) {
            this.providerServiceSummaries(Stream.of(providerServiceSummaries).map(c -> (ProviderServiceSummary)((ProviderServiceSummary.Builder)ProviderServiceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListProviderServicesResponse build() {
            return new ListProviderServicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EntityResolutionResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProviderServicesResponse> {
        public Builder nextToken(String var1);

        public Builder providerServiceSummaries(Collection<ProviderServiceSummary> var1);

        public Builder providerServiceSummaries(ProviderServiceSummary ... var1);

        public Builder providerServiceSummaries(Consumer<ProviderServiceSummary.Builder> ... var1);
    }
}

