/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.entityresolution.DefaultEntityResolutionBaseClientBuilder;
import software.amazon.awssdk.services.entityresolution.DefaultEntityResolutionClient;
import software.amazon.awssdk.services.entityresolution.EntityResolutionClient;
import software.amazon.awssdk.services.entityresolution.EntityResolutionClientBuilder;
import software.amazon.awssdk.services.entityresolution.EntityResolutionServiceClientConfiguration;
import software.amazon.awssdk.services.entityresolution.endpoints.EntityResolutionEndpointProvider;

@SdkInternalApi
final class DefaultEntityResolutionClientBuilder
extends DefaultEntityResolutionBaseClientBuilder<EntityResolutionClientBuilder, EntityResolutionClient>
implements EntityResolutionClientBuilder {
    DefaultEntityResolutionClientBuilder() {
    }

    @Override
    public DefaultEntityResolutionClientBuilder endpointProvider(EntityResolutionEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EntityResolutionClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEntityResolutionClientBuilder.validateClientOptions(clientConfiguration);
        EntityResolutionServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEntityResolutionClient client = new DefaultEntityResolutionClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EntityResolutionServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EntityResolutionServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

