/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.entityresolution.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResolutionType {
    RULE_MATCHING("RULE_MATCHING"),
    ML_MATCHING("ML_MATCHING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResolutionType> VALUE_MAP;
    private final String value;

    private ResolutionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResolutionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResolutionType> knownValues() {
        EnumSet<ResolutionType> knownValues = EnumSet.allOf(ResolutionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResolutionType.class, ResolutionType::toString);
    }
}

