/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 configuration for monitoring log publishing. You can configure your jobs to send log information to
 * Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3MonitoringConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3MonitoringConfiguration.Builder, S3MonitoringConfiguration> {
    private static final SdkField<String> LOG_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("logUri")
            .getter(getter(S3MonitoringConfiguration::logUri)).setter(setter(Builder::logUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logUri").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("encryptionKeyArn").getter(getter(S3MonitoringConfiguration::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_URI_FIELD,
            ENCRYPTION_KEY_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logUri;

    private final String encryptionKeyArn;

    private S3MonitoringConfiguration(BuilderImpl builder) {
        this.logUri = builder.logUri;
        this.encryptionKeyArn = builder.encryptionKeyArn;
    }

    /**
     * <p>
     * The Amazon S3 destination URI for log publishing.
     * </p>
     * 
     * @return The Amazon S3 destination URI for log publishing.
     */
    public final String logUri() {
        return logUri;
    }

    /**
     * <p>
     * The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
     * </p>
     * 
     * @return The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logUri());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3MonitoringConfiguration)) {
            return false;
        }
        S3MonitoringConfiguration other = (S3MonitoringConfiguration) obj;
        return Objects.equals(logUri(), other.logUri()) && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3MonitoringConfiguration").add("LogUri", logUri()).add("EncryptionKeyArn", encryptionKeyArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "logUri":
            return Optional.ofNullable(clazz.cast(logUri()));
        case "encryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("logUri", LOG_URI_FIELD);
        map.put("encryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3MonitoringConfiguration, T> g) {
        return obj -> g.apply((S3MonitoringConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3MonitoringConfiguration> {
        /**
         * <p>
         * The Amazon S3 destination URI for log publishing.
         * </p>
         * 
         * @param logUri
         *        The Amazon S3 destination URI for log publishing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logUri(String logUri);

        /**
         * <p>
         * The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The KMS key ARN to encrypt the logs published to the given Amazon S3 destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String logUri;

        private String encryptionKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3MonitoringConfiguration model) {
            logUri(model.logUri);
            encryptionKeyArn(model.encryptionKeyArn);
        }

        public final String getLogUri() {
            return logUri;
        }

        public final void setLogUri(String logUri) {
            this.logUri = logUri;
        }

        @Override
        public final Builder logUri(String logUri) {
            this.logUri = logUri;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        @Override
        public S3MonitoringConfiguration build() {
            return new S3MonitoringConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
