/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.emrserverless.model.ConfigurationOverrides;
import software.amazon.awssdk.services.emrserverless.model.JobDriver;
import software.amazon.awssdk.services.emrserverless.model.JobRunMode;
import software.amazon.awssdk.services.emrserverless.model.JobRunState;
import software.amazon.awssdk.services.emrserverless.model.NetworkConfiguration;
import software.amazon.awssdk.services.emrserverless.model.ResourceUtilization;
import software.amazon.awssdk.services.emrserverless.model.RetryPolicy;
import software.amazon.awssdk.services.emrserverless.model.TagMapCopier;
import software.amazon.awssdk.services.emrserverless.model.TotalResourceUtilization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobRun
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobRun> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationId").getter(JobRun.getter(JobRun::applicationId)).setter(JobRun.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationId").build()}).build();
    private static final SdkField<String> JOB_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobRunId").getter(JobRun.getter(JobRun::jobRunId)).setter(JobRun.setter(Builder::jobRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobRunId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(JobRun.getter(JobRun::name)).setter(JobRun.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(JobRun.getter(JobRun::arn)).setter(JobRun.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(JobRun.getter(JobRun::createdBy)).setter(JobRun.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(JobRun.getter(JobRun::createdAt)).setter(JobRun.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(JobRun.getter(JobRun::updatedAt)).setter(JobRun.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionRole").getter(JobRun.getter(JobRun::executionRole)).setter(JobRun.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(JobRun.getter(JobRun::stateAsString)).setter(JobRun.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stateDetails").getter(JobRun.getter(JobRun::stateDetails)).setter(JobRun.setter(Builder::stateDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateDetails").build()}).build();
    private static final SdkField<String> RELEASE_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("releaseLabel").getter(JobRun.getter(JobRun::releaseLabel)).setter(JobRun.setter(Builder::releaseLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releaseLabel").build()}).build();
    private static final SdkField<ConfigurationOverrides> CONFIGURATION_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configurationOverrides").getter(JobRun.getter(JobRun::configurationOverrides)).setter(JobRun.setter(Builder::configurationOverrides)).constructor(ConfigurationOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configurationOverrides").build()}).build();
    private static final SdkField<JobDriver> JOB_DRIVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobDriver").getter(JobRun.getter(JobRun::jobDriver)).setter(JobRun.setter(Builder::jobDriver)).constructor(JobDriver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobDriver").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(JobRun.getter(JobRun::tags)).setter(JobRun.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TotalResourceUtilization> TOTAL_RESOURCE_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("totalResourceUtilization").getter(JobRun.getter(JobRun::totalResourceUtilization)).setter(JobRun.setter(Builder::totalResourceUtilization)).constructor(TotalResourceUtilization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResourceUtilization").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(JobRun.getter(JobRun::networkConfiguration)).setter(JobRun.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<Integer> TOTAL_EXECUTION_DURATION_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalExecutionDurationSeconds").getter(JobRun.getter(JobRun::totalExecutionDurationSeconds)).setter(JobRun.setter(Builder::totalExecutionDurationSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalExecutionDurationSeconds").build()}).build();
    private static final SdkField<Long> EXECUTION_TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("executionTimeoutMinutes").getter(JobRun.getter(JobRun::executionTimeoutMinutes)).setter(JobRun.setter(Builder::executionTimeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimeoutMinutes").build()}).build();
    private static final SdkField<ResourceUtilization> BILLED_RESOURCE_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("billedResourceUtilization").getter(JobRun.getter(JobRun::billedResourceUtilization)).setter(JobRun.setter(Builder::billedResourceUtilization)).constructor(ResourceUtilization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billedResourceUtilization").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mode").getter(JobRun.getter(JobRun::modeAsString)).setter(JobRun.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()}).build();
    private static final SdkField<RetryPolicy> RETRY_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retryPolicy").getter(JobRun.getter(JobRun::retryPolicy)).setter(JobRun.setter(Builder::retryPolicy)).constructor(RetryPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retryPolicy").build()}).build();
    private static final SdkField<Integer> ATTEMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("attempt").getter(JobRun.getter(JobRun::attempt)).setter(JobRun.setter(Builder::attempt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attempt").build()}).build();
    private static final SdkField<Instant> ATTEMPT_CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("attemptCreatedAt").getter(JobRun.getter(JobRun::attemptCreatedAt)).setter(JobRun.setter(Builder::attemptCreatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attemptCreatedAt").build()}).build();
    private static final SdkField<Instant> ATTEMPT_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("attemptUpdatedAt").getter(JobRun.getter(JobRun::attemptUpdatedAt)).setter(JobRun.setter(Builder::attemptUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attemptUpdatedAt").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(JobRun.getter(JobRun::startedAt)).setter(JobRun.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build()}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(JobRun.getter(JobRun::endedAt)).setter(JobRun.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build()}).build();
    private static final SdkField<Long> QUEUED_DURATION_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("queuedDurationMilliseconds").getter(JobRun.getter(JobRun::queuedDurationMilliseconds)).setter(JobRun.setter(Builder::queuedDurationMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedDurationMilliseconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, JOB_RUN_ID_FIELD, NAME_FIELD, ARN_FIELD, CREATED_BY_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, EXECUTION_ROLE_FIELD, STATE_FIELD, STATE_DETAILS_FIELD, RELEASE_LABEL_FIELD, CONFIGURATION_OVERRIDES_FIELD, JOB_DRIVER_FIELD, TAGS_FIELD, TOTAL_RESOURCE_UTILIZATION_FIELD, NETWORK_CONFIGURATION_FIELD, TOTAL_EXECUTION_DURATION_SECONDS_FIELD, EXECUTION_TIMEOUT_MINUTES_FIELD, BILLED_RESOURCE_UTILIZATION_FIELD, MODE_FIELD, RETRY_POLICY_FIELD, ATTEMPT_FIELD, ATTEMPT_CREATED_AT_FIELD, ATTEMPT_UPDATED_AT_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, QUEUED_DURATION_MILLISECONDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("applicationId", APPLICATION_ID_FIELD);
            this.put("jobRunId", JOB_RUN_ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("executionRole", EXECUTION_ROLE_FIELD);
            this.put("state", STATE_FIELD);
            this.put("stateDetails", STATE_DETAILS_FIELD);
            this.put("releaseLabel", RELEASE_LABEL_FIELD);
            this.put("configurationOverrides", CONFIGURATION_OVERRIDES_FIELD);
            this.put("jobDriver", JOB_DRIVER_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("totalResourceUtilization", TOTAL_RESOURCE_UTILIZATION_FIELD);
            this.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
            this.put("totalExecutionDurationSeconds", TOTAL_EXECUTION_DURATION_SECONDS_FIELD);
            this.put("executionTimeoutMinutes", EXECUTION_TIMEOUT_MINUTES_FIELD);
            this.put("billedResourceUtilization", BILLED_RESOURCE_UTILIZATION_FIELD);
            this.put("mode", MODE_FIELD);
            this.put("retryPolicy", RETRY_POLICY_FIELD);
            this.put("attempt", ATTEMPT_FIELD);
            this.put("attemptCreatedAt", ATTEMPT_CREATED_AT_FIELD);
            this.put("attemptUpdatedAt", ATTEMPT_UPDATED_AT_FIELD);
            this.put("startedAt", STARTED_AT_FIELD);
            this.put("endedAt", ENDED_AT_FIELD);
            this.put("queuedDurationMilliseconds", QUEUED_DURATION_MILLISECONDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String applicationId;
    private final String jobRunId;
    private final String name;
    private final String arn;
    private final String createdBy;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final String executionRole;
    private final String state;
    private final String stateDetails;
    private final String releaseLabel;
    private final ConfigurationOverrides configurationOverrides;
    private final JobDriver jobDriver;
    private final Map<String, String> tags;
    private final TotalResourceUtilization totalResourceUtilization;
    private final NetworkConfiguration networkConfiguration;
    private final Integer totalExecutionDurationSeconds;
    private final Long executionTimeoutMinutes;
    private final ResourceUtilization billedResourceUtilization;
    private final String mode;
    private final RetryPolicy retryPolicy;
    private final Integer attempt;
    private final Instant attemptCreatedAt;
    private final Instant attemptUpdatedAt;
    private final Instant startedAt;
    private final Instant endedAt;
    private final Long queuedDurationMilliseconds;

    private JobRun(BuilderImpl builder) {
        this.applicationId = builder.applicationId;
        this.jobRunId = builder.jobRunId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.createdBy = builder.createdBy;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.executionRole = builder.executionRole;
        this.state = builder.state;
        this.stateDetails = builder.stateDetails;
        this.releaseLabel = builder.releaseLabel;
        this.configurationOverrides = builder.configurationOverrides;
        this.jobDriver = builder.jobDriver;
        this.tags = builder.tags;
        this.totalResourceUtilization = builder.totalResourceUtilization;
        this.networkConfiguration = builder.networkConfiguration;
        this.totalExecutionDurationSeconds = builder.totalExecutionDurationSeconds;
        this.executionTimeoutMinutes = builder.executionTimeoutMinutes;
        this.billedResourceUtilization = builder.billedResourceUtilization;
        this.mode = builder.mode;
        this.retryPolicy = builder.retryPolicy;
        this.attempt = builder.attempt;
        this.attemptCreatedAt = builder.attemptCreatedAt;
        this.attemptUpdatedAt = builder.attemptUpdatedAt;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.queuedDurationMilliseconds = builder.queuedDurationMilliseconds;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String jobRunId() {
        return this.jobRunId;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final JobRunState state() {
        return JobRunState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateDetails() {
        return this.stateDetails;
    }

    public final String releaseLabel() {
        return this.releaseLabel;
    }

    public final ConfigurationOverrides configurationOverrides() {
        return this.configurationOverrides;
    }

    public final JobDriver jobDriver() {
        return this.jobDriver;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final TotalResourceUtilization totalResourceUtilization() {
        return this.totalResourceUtilization;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final Integer totalExecutionDurationSeconds() {
        return this.totalExecutionDurationSeconds;
    }

    public final Long executionTimeoutMinutes() {
        return this.executionTimeoutMinutes;
    }

    public final ResourceUtilization billedResourceUtilization() {
        return this.billedResourceUtilization;
    }

    public final JobRunMode mode() {
        return JobRunMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final RetryPolicy retryPolicy() {
        return this.retryPolicy;
    }

    public final Integer attempt() {
        return this.attempt;
    }

    public final Instant attemptCreatedAt() {
        return this.attemptCreatedAt;
    }

    public final Instant attemptUpdatedAt() {
        return this.attemptUpdatedAt;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final Long queuedDurationMilliseconds() {
        return this.queuedDurationMilliseconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.releaseLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationOverrides());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDriver());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResourceUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalExecutionDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.billedResourceUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.attempt());
        hashCode = 31 * hashCode + Objects.hashCode(this.attemptCreatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.attemptUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedDurationMilliseconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRun)) {
            return false;
        }
        JobRun other = (JobRun)obj;
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.jobRunId(), other.jobRunId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateDetails(), other.stateDetails()) && Objects.equals(this.releaseLabel(), other.releaseLabel()) && Objects.equals(this.configurationOverrides(), other.configurationOverrides()) && Objects.equals(this.jobDriver(), other.jobDriver()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.totalResourceUtilization(), other.totalResourceUtilization()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.totalExecutionDurationSeconds(), other.totalExecutionDurationSeconds()) && Objects.equals(this.executionTimeoutMinutes(), other.executionTimeoutMinutes()) && Objects.equals(this.billedResourceUtilization(), other.billedResourceUtilization()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.retryPolicy(), other.retryPolicy()) && Objects.equals(this.attempt(), other.attempt()) && Objects.equals(this.attemptCreatedAt(), other.attemptCreatedAt()) && Objects.equals(this.attemptUpdatedAt(), other.attemptUpdatedAt()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.queuedDurationMilliseconds(), other.queuedDurationMilliseconds());
    }

    public final String toString() {
        return ToString.builder((String)"JobRun").add("ApplicationId", (Object)this.applicationId()).add("JobRunId", (Object)this.jobRunId()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("CreatedBy", (Object)this.createdBy()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("ExecutionRole", (Object)this.executionRole()).add("State", (Object)this.stateAsString()).add("StateDetails", (Object)this.stateDetails()).add("ReleaseLabel", (Object)this.releaseLabel()).add("ConfigurationOverrides", (Object)this.configurationOverrides()).add("JobDriver", (Object)this.jobDriver()).add("Tags", this.hasTags() ? this.tags() : null).add("TotalResourceUtilization", (Object)this.totalResourceUtilization()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("TotalExecutionDurationSeconds", (Object)this.totalExecutionDurationSeconds()).add("ExecutionTimeoutMinutes", (Object)this.executionTimeoutMinutes()).add("BilledResourceUtilization", (Object)this.billedResourceUtilization()).add("Mode", (Object)this.modeAsString()).add("RetryPolicy", (Object)this.retryPolicy()).add("Attempt", (Object)this.attempt()).add("AttemptCreatedAt", (Object)this.attemptCreatedAt()).add("AttemptUpdatedAt", (Object)this.attemptUpdatedAt()).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).add("QueuedDurationMilliseconds", (Object)this.queuedDurationMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "jobRunId": {
                return Optional.ofNullable(clazz.cast(this.jobRunId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "executionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "stateDetails": {
                return Optional.ofNullable(clazz.cast(this.stateDetails()));
            }
            case "releaseLabel": {
                return Optional.ofNullable(clazz.cast(this.releaseLabel()));
            }
            case "configurationOverrides": {
                return Optional.ofNullable(clazz.cast(this.configurationOverrides()));
            }
            case "jobDriver": {
                return Optional.ofNullable(clazz.cast(this.jobDriver()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "totalResourceUtilization": {
                return Optional.ofNullable(clazz.cast(this.totalResourceUtilization()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "totalExecutionDurationSeconds": {
                return Optional.ofNullable(clazz.cast(this.totalExecutionDurationSeconds()));
            }
            case "executionTimeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.executionTimeoutMinutes()));
            }
            case "billedResourceUtilization": {
                return Optional.ofNullable(clazz.cast(this.billedResourceUtilization()));
            }
            case "mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "retryPolicy": {
                return Optional.ofNullable(clazz.cast(this.retryPolicy()));
            }
            case "attempt": {
                return Optional.ofNullable(clazz.cast(this.attempt()));
            }
            case "attemptCreatedAt": {
                return Optional.ofNullable(clazz.cast(this.attemptCreatedAt()));
            }
            case "attemptUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.attemptUpdatedAt()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "queuedDurationMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.queuedDurationMilliseconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<JobRun, T> g) {
        return obj -> g.apply((JobRun)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationId;
        private String jobRunId;
        private String name;
        private String arn;
        private String createdBy;
        private Instant createdAt;
        private Instant updatedAt;
        private String executionRole;
        private String state;
        private String stateDetails;
        private String releaseLabel;
        private ConfigurationOverrides configurationOverrides;
        private JobDriver jobDriver;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private TotalResourceUtilization totalResourceUtilization;
        private NetworkConfiguration networkConfiguration;
        private Integer totalExecutionDurationSeconds;
        private Long executionTimeoutMinutes;
        private ResourceUtilization billedResourceUtilization;
        private String mode;
        private RetryPolicy retryPolicy;
        private Integer attempt;
        private Instant attemptCreatedAt;
        private Instant attemptUpdatedAt;
        private Instant startedAt;
        private Instant endedAt;
        private Long queuedDurationMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(JobRun model) {
            this.applicationId(model.applicationId);
            this.jobRunId(model.jobRunId);
            this.name(model.name);
            this.arn(model.arn);
            this.createdBy(model.createdBy);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.executionRole(model.executionRole);
            this.state(model.state);
            this.stateDetails(model.stateDetails);
            this.releaseLabel(model.releaseLabel);
            this.configurationOverrides(model.configurationOverrides);
            this.jobDriver(model.jobDriver);
            this.tags(model.tags);
            this.totalResourceUtilization(model.totalResourceUtilization);
            this.networkConfiguration(model.networkConfiguration);
            this.totalExecutionDurationSeconds(model.totalExecutionDurationSeconds);
            this.executionTimeoutMinutes(model.executionTimeoutMinutes);
            this.billedResourceUtilization(model.billedResourceUtilization);
            this.mode(model.mode);
            this.retryPolicy(model.retryPolicy);
            this.attempt(model.attempt);
            this.attemptCreatedAt(model.attemptCreatedAt);
            this.attemptUpdatedAt(model.attemptUpdatedAt);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
            this.queuedDurationMilliseconds(model.queuedDurationMilliseconds);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getJobRunId() {
            return this.jobRunId;
        }

        public final void setJobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
        }

        @Override
        public final Builder jobRunId(String jobRunId) {
            this.jobRunId = jobRunId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateDetails() {
            return this.stateDetails;
        }

        public final void setStateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
        }

        @Override
        public final Builder stateDetails(String stateDetails) {
            this.stateDetails = stateDetails;
            return this;
        }

        public final String getReleaseLabel() {
            return this.releaseLabel;
        }

        public final void setReleaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
        }

        @Override
        public final Builder releaseLabel(String releaseLabel) {
            this.releaseLabel = releaseLabel;
            return this;
        }

        public final ConfigurationOverrides.Builder getConfigurationOverrides() {
            return this.configurationOverrides != null ? this.configurationOverrides.toBuilder() : null;
        }

        public final void setConfigurationOverrides(ConfigurationOverrides.BuilderImpl configurationOverrides) {
            this.configurationOverrides = configurationOverrides != null ? configurationOverrides.build() : null;
        }

        @Override
        public final Builder configurationOverrides(ConfigurationOverrides configurationOverrides) {
            this.configurationOverrides = configurationOverrides;
            return this;
        }

        public final JobDriver.Builder getJobDriver() {
            return this.jobDriver != null ? this.jobDriver.toBuilder() : null;
        }

        public final void setJobDriver(JobDriver.BuilderImpl jobDriver) {
            this.jobDriver = jobDriver != null ? jobDriver.build() : null;
        }

        @Override
        public final Builder jobDriver(JobDriver jobDriver) {
            this.jobDriver = jobDriver;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final TotalResourceUtilization.Builder getTotalResourceUtilization() {
            return this.totalResourceUtilization != null ? this.totalResourceUtilization.toBuilder() : null;
        }

        public final void setTotalResourceUtilization(TotalResourceUtilization.BuilderImpl totalResourceUtilization) {
            this.totalResourceUtilization = totalResourceUtilization != null ? totalResourceUtilization.build() : null;
        }

        @Override
        public final Builder totalResourceUtilization(TotalResourceUtilization totalResourceUtilization) {
            this.totalResourceUtilization = totalResourceUtilization;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final Integer getTotalExecutionDurationSeconds() {
            return this.totalExecutionDurationSeconds;
        }

        public final void setTotalExecutionDurationSeconds(Integer totalExecutionDurationSeconds) {
            this.totalExecutionDurationSeconds = totalExecutionDurationSeconds;
        }

        @Override
        public final Builder totalExecutionDurationSeconds(Integer totalExecutionDurationSeconds) {
            this.totalExecutionDurationSeconds = totalExecutionDurationSeconds;
            return this;
        }

        public final Long getExecutionTimeoutMinutes() {
            return this.executionTimeoutMinutes;
        }

        public final void setExecutionTimeoutMinutes(Long executionTimeoutMinutes) {
            this.executionTimeoutMinutes = executionTimeoutMinutes;
        }

        @Override
        public final Builder executionTimeoutMinutes(Long executionTimeoutMinutes) {
            this.executionTimeoutMinutes = executionTimeoutMinutes;
            return this;
        }

        public final ResourceUtilization.Builder getBilledResourceUtilization() {
            return this.billedResourceUtilization != null ? this.billedResourceUtilization.toBuilder() : null;
        }

        public final void setBilledResourceUtilization(ResourceUtilization.BuilderImpl billedResourceUtilization) {
            this.billedResourceUtilization = billedResourceUtilization != null ? billedResourceUtilization.build() : null;
        }

        @Override
        public final Builder billedResourceUtilization(ResourceUtilization billedResourceUtilization) {
            this.billedResourceUtilization = billedResourceUtilization;
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(JobRunMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final RetryPolicy.Builder getRetryPolicy() {
            return this.retryPolicy != null ? this.retryPolicy.toBuilder() : null;
        }

        public final void setRetryPolicy(RetryPolicy.BuilderImpl retryPolicy) {
            this.retryPolicy = retryPolicy != null ? retryPolicy.build() : null;
        }

        @Override
        public final Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public final Integer getAttempt() {
            return this.attempt;
        }

        public final void setAttempt(Integer attempt) {
            this.attempt = attempt;
        }

        @Override
        public final Builder attempt(Integer attempt) {
            this.attempt = attempt;
            return this;
        }

        public final Instant getAttemptCreatedAt() {
            return this.attemptCreatedAt;
        }

        public final void setAttemptCreatedAt(Instant attemptCreatedAt) {
            this.attemptCreatedAt = attemptCreatedAt;
        }

        @Override
        public final Builder attemptCreatedAt(Instant attemptCreatedAt) {
            this.attemptCreatedAt = attemptCreatedAt;
            return this;
        }

        public final Instant getAttemptUpdatedAt() {
            return this.attemptUpdatedAt;
        }

        public final void setAttemptUpdatedAt(Instant attemptUpdatedAt) {
            this.attemptUpdatedAt = attemptUpdatedAt;
        }

        @Override
        public final Builder attemptUpdatedAt(Instant attemptUpdatedAt) {
            this.attemptUpdatedAt = attemptUpdatedAt;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Long getQueuedDurationMilliseconds() {
            return this.queuedDurationMilliseconds;
        }

        public final void setQueuedDurationMilliseconds(Long queuedDurationMilliseconds) {
            this.queuedDurationMilliseconds = queuedDurationMilliseconds;
        }

        @Override
        public final Builder queuedDurationMilliseconds(Long queuedDurationMilliseconds) {
            this.queuedDurationMilliseconds = queuedDurationMilliseconds;
            return this;
        }

        public JobRun build() {
            return new JobRun(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobRun> {
        public Builder applicationId(String var1);

        public Builder jobRunId(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder createdBy(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder executionRole(String var1);

        public Builder state(String var1);

        public Builder state(JobRunState var1);

        public Builder stateDetails(String var1);

        public Builder releaseLabel(String var1);

        public Builder configurationOverrides(ConfigurationOverrides var1);

        default public Builder configurationOverrides(Consumer<ConfigurationOverrides.Builder> configurationOverrides) {
            return this.configurationOverrides((ConfigurationOverrides)((ConfigurationOverrides.Builder)ConfigurationOverrides.builder().applyMutation(configurationOverrides)).build());
        }

        public Builder jobDriver(JobDriver var1);

        default public Builder jobDriver(Consumer<JobDriver.Builder> jobDriver) {
            return this.jobDriver((JobDriver)((JobDriver.Builder)JobDriver.builder().applyMutation(jobDriver)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder totalResourceUtilization(TotalResourceUtilization var1);

        default public Builder totalResourceUtilization(Consumer<TotalResourceUtilization.Builder> totalResourceUtilization) {
            return this.totalResourceUtilization((TotalResourceUtilization)((TotalResourceUtilization.Builder)TotalResourceUtilization.builder().applyMutation(totalResourceUtilization)).build());
        }

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder totalExecutionDurationSeconds(Integer var1);

        public Builder executionTimeoutMinutes(Long var1);

        public Builder billedResourceUtilization(ResourceUtilization var1);

        default public Builder billedResourceUtilization(Consumer<ResourceUtilization.Builder> billedResourceUtilization) {
            return this.billedResourceUtilization((ResourceUtilization)((ResourceUtilization.Builder)ResourceUtilization.builder().applyMutation(billedResourceUtilization)).build());
        }

        public Builder mode(String var1);

        public Builder mode(JobRunMode var1);

        public Builder retryPolicy(RetryPolicy var1);

        default public Builder retryPolicy(Consumer<RetryPolicy.Builder> retryPolicy) {
            return this.retryPolicy((RetryPolicy)((RetryPolicy.Builder)RetryPolicy.builder().applyMutation(retryPolicy)).build());
        }

        public Builder attempt(Integer var1);

        public Builder attemptCreatedAt(Instant var1);

        public Builder attemptUpdatedAt(Instant var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder queuedDurationMilliseconds(Long var1);
    }
}

