/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emrserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoStopConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoStopConfig> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(AutoStopConfig.getter(AutoStopConfig::enabled)).setter(AutoStopConfig.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<Integer> IDLE_TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("idleTimeoutMinutes").getter(AutoStopConfig.getter(AutoStopConfig::idleTimeoutMinutes)).setter(AutoStopConfig.setter(Builder::idleTimeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleTimeoutMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, IDLE_TIMEOUT_MINUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("enabled", ENABLED_FIELD);
            this.put("idleTimeoutMinutes", IDLE_TIMEOUT_MINUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final Integer idleTimeoutMinutes;

    private AutoStopConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.idleTimeoutMinutes = builder.idleTimeoutMinutes;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    public final Integer idleTimeoutMinutes() {
        return this.idleTimeoutMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleTimeoutMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoStopConfig)) {
            return false;
        }
        AutoStopConfig other = (AutoStopConfig)obj;
        return Objects.equals(this.enabled(), other.enabled()) && Objects.equals(this.idleTimeoutMinutes(), other.idleTimeoutMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"AutoStopConfig").add("Enabled", (Object)this.enabled()).add("IdleTimeoutMinutes", (Object)this.idleTimeoutMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "idleTimeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.idleTimeoutMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AutoStopConfig, T> g) {
        return obj -> g.apply((AutoStopConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private Integer idleTimeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoStopConfig model) {
            this.enabled(model.enabled);
            this.idleTimeoutMinutes(model.idleTimeoutMinutes);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getIdleTimeoutMinutes() {
            return this.idleTimeoutMinutes;
        }

        public final void setIdleTimeoutMinutes(Integer idleTimeoutMinutes) {
            this.idleTimeoutMinutes = idleTimeoutMinutes;
        }

        @Override
        public final Builder idleTimeoutMinutes(Integer idleTimeoutMinutes) {
            this.idleTimeoutMinutes = idleTimeoutMinutes;
            return this;
        }

        public AutoStopConfig build() {
            return new AutoStopConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoStopConfig> {
        public Builder enabled(Boolean var1);

        public Builder idleTimeoutMinutes(Integer var1);
    }
}

