/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.Instance;
import software.amazon.awssdk.services.emr.model.InstanceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstancesResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, ListInstancesResponse> {
    private static final SdkField<List<Instance>> INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListInstancesResponse.getter(ListInstancesResponse::instances)).setter(ListInstancesResponse.setter(Builder::instances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Instances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListInstancesResponse.getter(ListInstancesResponse::marker)).setter(ListInstancesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_FIELD, MARKER_FIELD));
    private final List<Instance> instances;
    private final String marker;

    private ListInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instances = builder.instances;
        this.marker = builder.marker;
    }

    public List<Instance> instances() {
        return this.instances;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instances());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesResponse)) {
            return false;
        }
        ListInstancesResponse other = (ListInstancesResponse)((Object)obj);
        return Objects.equals(this.instances(), other.instances()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListInstancesResponse").add("Instances", this.instances()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Instances": {
                return Optional.ofNullable(clazz.cast(this.instances()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstancesResponse, T> g) {
        return obj -> g.apply((ListInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<Instance> instances = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesResponse model) {
            super(model);
            this.instances(model.instances);
            this.marker(model.marker);
        }

        public final Collection<Instance.Builder> getInstances() {
            return this.instances != null ? (Collection)this.instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstanceListCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance ... instances) {
            this.instances(Arrays.asList(instances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Consumer<Instance.Builder> ... instances) {
            this.instances(Stream.of(instances).map(c -> (Instance)((Instance.Builder)Instance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstanceListCopier.copyFromBuilder(instances);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListInstancesResponse build() {
            return new ListInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInstancesResponse> {
        public Builder instances(Collection<Instance> var1);

        public Builder instances(Instance ... var1);

        public Builder instances(Consumer<Instance.Builder> ... var1);

        public Builder marker(String var1);
    }
}

