/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.NotebookExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotebookExecutionsRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, ListNotebookExecutionsRequest> {
    private static final SdkField<String> EDITOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EditorId").getter(ListNotebookExecutionsRequest.getter(ListNotebookExecutionsRequest::editorId)).setter(ListNotebookExecutionsRequest.setter(Builder::editorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EditorId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListNotebookExecutionsRequest.getter(ListNotebookExecutionsRequest::statusAsString)).setter(ListNotebookExecutionsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("From").getter(ListNotebookExecutionsRequest.getter(ListNotebookExecutionsRequest::from)).setter(ListNotebookExecutionsRequest.setter(Builder::from)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("From").build()}).build();
    private static final SdkField<Instant> TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("To").getter(ListNotebookExecutionsRequest.getter(ListNotebookExecutionsRequest::to)).setter(ListNotebookExecutionsRequest.setter(Builder::to)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("To").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListNotebookExecutionsRequest.getter(ListNotebookExecutionsRequest::marker)).setter(ListNotebookExecutionsRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<String> EXECUTION_ENGINE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionEngineId").getter(ListNotebookExecutionsRequest.getter(ListNotebookExecutionsRequest::executionEngineId)).setter(ListNotebookExecutionsRequest.setter(Builder::executionEngineId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEngineId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDITOR_ID_FIELD, STATUS_FIELD, FROM_FIELD, TO_FIELD, MARKER_FIELD, EXECUTION_ENGINE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNotebookExecutionsRequest.memberNameToFieldInitializer();
    private final String editorId;
    private final String status;
    private final Instant from;
    private final Instant to;
    private final String marker;
    private final String executionEngineId;

    private ListNotebookExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.editorId = builder.editorId;
        this.status = builder.status;
        this.from = builder.from;
        this.to = builder.to;
        this.marker = builder.marker;
        this.executionEngineId = builder.executionEngineId;
    }

    public final String editorId() {
        return this.editorId;
    }

    public final NotebookExecutionStatus status() {
        return NotebookExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant from() {
        return this.from;
    }

    public final Instant to() {
        return this.to;
    }

    public final String marker() {
        return this.marker;
    }

    public final String executionEngineId() {
        return this.executionEngineId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.editorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.from());
        hashCode = 31 * hashCode + Objects.hashCode(this.to());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEngineId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookExecutionsRequest)) {
            return false;
        }
        ListNotebookExecutionsRequest other = (ListNotebookExecutionsRequest)((Object)obj);
        return Objects.equals(this.editorId(), other.editorId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.from(), other.from()) && Objects.equals(this.to(), other.to()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.executionEngineId(), other.executionEngineId());
    }

    public final String toString() {
        return ToString.builder((String)"ListNotebookExecutionsRequest").add("EditorId", (Object)this.editorId()).add("Status", (Object)this.statusAsString()).add("From", (Object)this.from()).add("To", (Object)this.to()).add("Marker", (Object)this.marker()).add("ExecutionEngineId", (Object)this.executionEngineId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EditorId": {
                return Optional.ofNullable(clazz.cast(this.editorId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "From": {
                return Optional.ofNullable(clazz.cast(this.from()));
            }
            case "To": {
                return Optional.ofNullable(clazz.cast(this.to()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ExecutionEngineId": {
                return Optional.ofNullable(clazz.cast(this.executionEngineId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EditorId", EDITOR_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("From", FROM_FIELD);
        map.put("To", TO_FIELD);
        map.put("Marker", MARKER_FIELD);
        map.put("ExecutionEngineId", EXECUTION_ENGINE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotebookExecutionsRequest, T> g) {
        return obj -> g.apply((ListNotebookExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String editorId;
        private String status;
        private Instant from;
        private Instant to;
        private String marker;
        private String executionEngineId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookExecutionsRequest model) {
            super(model);
            this.editorId(model.editorId);
            this.status(model.status);
            this.from(model.from);
            this.to(model.to);
            this.marker(model.marker);
            this.executionEngineId(model.executionEngineId);
        }

        public final String getEditorId() {
            return this.editorId;
        }

        public final void setEditorId(String editorId) {
            this.editorId = editorId;
        }

        @Override
        public final Builder editorId(String editorId) {
            this.editorId = editorId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(NotebookExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getFrom() {
            return this.from;
        }

        public final void setFrom(Instant from) {
            this.from = from;
        }

        @Override
        public final Builder from(Instant from) {
            this.from = from;
            return this;
        }

        public final Instant getTo() {
            return this.to;
        }

        public final void setTo(Instant to) {
            this.to = to;
        }

        @Override
        public final Builder to(Instant to) {
            this.to = to;
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final String getExecutionEngineId() {
            return this.executionEngineId;
        }

        public final void setExecutionEngineId(String executionEngineId) {
            this.executionEngineId = executionEngineId;
        }

        @Override
        public final Builder executionEngineId(String executionEngineId) {
            this.executionEngineId = executionEngineId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListNotebookExecutionsRequest build() {
            return new ListNotebookExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotebookExecutionsRequest> {
        public Builder editorId(String var1);

        public Builder status(String var1);

        public Builder status(NotebookExecutionStatus var1);

        public Builder from(Instant var1);

        public Builder to(Instant var1);

        public Builder marker(String var1);

        public Builder executionEngineId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

