/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.CancelStepsInfo;
import software.amazon.awssdk.services.emr.model.CancelStepsInfoListCopier;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelStepsResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, CancelStepsResponse> {
    private static final SdkField<List<CancelStepsInfo>> CANCEL_STEPS_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CancelStepsResponse.getter(CancelStepsResponse::cancelStepsInfoList)).setter(CancelStepsResponse.setter(Builder::cancelStepsInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelStepsInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CancelStepsInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CANCEL_STEPS_INFO_LIST_FIELD));
    private final List<CancelStepsInfo> cancelStepsInfoList;

    private CancelStepsResponse(BuilderImpl builder) {
        super(builder);
        this.cancelStepsInfoList = builder.cancelStepsInfoList;
    }

    public List<CancelStepsInfo> cancelStepsInfoList() {
        return this.cancelStepsInfoList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cancelStepsInfoList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsResponse)) {
            return false;
        }
        CancelStepsResponse other = (CancelStepsResponse)((Object)obj);
        return Objects.equals(this.cancelStepsInfoList(), other.cancelStepsInfoList());
    }

    public String toString() {
        return ToString.builder((String)"CancelStepsResponse").add("CancelStepsInfoList", this.cancelStepsInfoList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CancelStepsInfoList": {
                return Optional.ofNullable(clazz.cast(this.cancelStepsInfoList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelStepsResponse, T> g) {
        return obj -> g.apply((CancelStepsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<CancelStepsInfo> cancelStepsInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CancelStepsResponse model) {
            super(model);
            this.cancelStepsInfoList(model.cancelStepsInfoList);
        }

        public final Collection<CancelStepsInfo.Builder> getCancelStepsInfoList() {
            return this.cancelStepsInfoList != null ? (Collection)this.cancelStepsInfoList.stream().map(CancelStepsInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder cancelStepsInfoList(Collection<CancelStepsInfo> cancelStepsInfoList) {
            this.cancelStepsInfoList = CancelStepsInfoListCopier.copy(cancelStepsInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelStepsInfoList(CancelStepsInfo ... cancelStepsInfoList) {
            this.cancelStepsInfoList(Arrays.asList(cancelStepsInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cancelStepsInfoList(Consumer<CancelStepsInfo.Builder> ... cancelStepsInfoList) {
            this.cancelStepsInfoList(Stream.of(cancelStepsInfoList).map(c -> (CancelStepsInfo)((CancelStepsInfo.Builder)CancelStepsInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCancelStepsInfoList(Collection<CancelStepsInfo.BuilderImpl> cancelStepsInfoList) {
            this.cancelStepsInfoList = CancelStepsInfoListCopier.copyFromBuilder(cancelStepsInfoList);
        }

        @Override
        public CancelStepsResponse build() {
            return new CancelStepsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelStepsResponse> {
        public Builder cancelStepsInfoList(Collection<CancelStepsInfo> var1);

        public Builder cancelStepsInfoList(CancelStepsInfo ... var1);

        public Builder cancelStepsInfoList(Consumer<CancelStepsInfo.Builder> ... var1);
    }
}

