/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceCollectionType {
    INSTANCE_FLEET("INSTANCE_FLEET"),
    INSTANCE_GROUP("INSTANCE_GROUP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceCollectionType> VALUE_MAP;
    private final String value;

    private InstanceCollectionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceCollectionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceCollectionType> knownValues() {
        EnumSet<InstanceCollectionType> knownValues = EnumSet.allOf(InstanceCollectionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceCollectionType.class, InstanceCollectionType::toString);
    }
}

