/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrResponse;
import software.amazon.awssdk.services.emr.model.SupportedInstanceType;
import software.amazon.awssdk.services.emr.model.SupportedInstanceTypesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSupportedInstanceTypesResponse
extends EmrResponse
implements ToCopyableBuilder<Builder, ListSupportedInstanceTypesResponse> {
    private static final SdkField<List<SupportedInstanceType>> SUPPORTED_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedInstanceTypes").getter(ListSupportedInstanceTypesResponse.getter(ListSupportedInstanceTypesResponse::supportedInstanceTypes)).setter(ListSupportedInstanceTypesResponse.setter(Builder::supportedInstanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SupportedInstanceType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListSupportedInstanceTypesResponse.getter(ListSupportedInstanceTypesResponse::marker)).setter(ListSupportedInstanceTypesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUPPORTED_INSTANCE_TYPES_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSupportedInstanceTypesResponse.memberNameToFieldInitializer();
    private final List<SupportedInstanceType> supportedInstanceTypes;
    private final String marker;

    private ListSupportedInstanceTypesResponse(BuilderImpl builder) {
        super(builder);
        this.supportedInstanceTypes = builder.supportedInstanceTypes;
        this.marker = builder.marker;
    }

    public final boolean hasSupportedInstanceTypes() {
        return this.supportedInstanceTypes != null && !(this.supportedInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<SupportedInstanceType> supportedInstanceTypes() {
        return this.supportedInstanceTypes;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedInstanceTypes() ? this.supportedInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSupportedInstanceTypesResponse)) {
            return false;
        }
        ListSupportedInstanceTypesResponse other = (ListSupportedInstanceTypesResponse)((Object)obj);
        return this.hasSupportedInstanceTypes() == other.hasSupportedInstanceTypes() && Objects.equals(this.supportedInstanceTypes(), other.supportedInstanceTypes()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListSupportedInstanceTypesResponse").add("SupportedInstanceTypes", this.hasSupportedInstanceTypes() ? this.supportedInstanceTypes() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SupportedInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedInstanceTypes()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SupportedInstanceTypes", SUPPORTED_INSTANCE_TYPES_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSupportedInstanceTypesResponse, T> g) {
        return obj -> g.apply((ListSupportedInstanceTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrResponse.BuilderImpl
    implements Builder {
        private List<SupportedInstanceType> supportedInstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSupportedInstanceTypesResponse model) {
            super(model);
            this.supportedInstanceTypes(model.supportedInstanceTypes);
            this.marker(model.marker);
        }

        public final List<SupportedInstanceType.Builder> getSupportedInstanceTypes() {
            List<SupportedInstanceType.Builder> result = SupportedInstanceTypesListCopier.copyToBuilder(this.supportedInstanceTypes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSupportedInstanceTypes(Collection<SupportedInstanceType.BuilderImpl> supportedInstanceTypes) {
            this.supportedInstanceTypes = SupportedInstanceTypesListCopier.copyFromBuilder(supportedInstanceTypes);
        }

        @Override
        public final Builder supportedInstanceTypes(Collection<SupportedInstanceType> supportedInstanceTypes) {
            this.supportedInstanceTypes = SupportedInstanceTypesListCopier.copy(supportedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedInstanceTypes(SupportedInstanceType ... supportedInstanceTypes) {
            this.supportedInstanceTypes(Arrays.asList(supportedInstanceTypes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedInstanceTypes(Consumer<SupportedInstanceType.Builder> ... supportedInstanceTypes) {
            this.supportedInstanceTypes(Stream.of(supportedInstanceTypes).map(c -> (SupportedInstanceType)((SupportedInstanceType.Builder)SupportedInstanceType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public ListSupportedInstanceTypesResponse build() {
            return new ListSupportedInstanceTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSupportedInstanceTypesResponse> {
        public Builder supportedInstanceTypes(Collection<SupportedInstanceType> var1);

        public Builder supportedInstanceTypes(SupportedInstanceType ... var1);

        public Builder supportedInstanceTypes(Consumer<SupportedInstanceType.Builder> ... var1);

        public Builder marker(String var1);
    }
}

