/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KerberosAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KerberosAttributes> {
    private static final SdkField<String> REALM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Realm").getter(KerberosAttributes.getter(KerberosAttributes::realm)).setter(KerberosAttributes.setter(Builder::realm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()}).build();
    private static final SdkField<String> KDC_ADMIN_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KdcAdminPassword").getter(KerberosAttributes.getter(KerberosAttributes::kdcAdminPassword)).setter(KerberosAttributes.setter(Builder::kdcAdminPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KdcAdminPassword").build()}).build();
    private static final SdkField<String> CROSS_REALM_TRUST_PRINCIPAL_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CrossRealmTrustPrincipalPassword").getter(KerberosAttributes.getter(KerberosAttributes::crossRealmTrustPrincipalPassword)).setter(KerberosAttributes.setter(Builder::crossRealmTrustPrincipalPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrossRealmTrustPrincipalPassword").build()}).build();
    private static final SdkField<String> AD_DOMAIN_JOIN_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ADDomainJoinUser").getter(KerberosAttributes.getter(KerberosAttributes::adDomainJoinUser)).setter(KerberosAttributes.setter(Builder::adDomainJoinUser)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADDomainJoinUser").build()}).build();
    private static final SdkField<String> AD_DOMAIN_JOIN_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ADDomainJoinPassword").getter(KerberosAttributes.getter(KerberosAttributes::adDomainJoinPassword)).setter(KerberosAttributes.setter(Builder::adDomainJoinPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ADDomainJoinPassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REALM_FIELD, KDC_ADMIN_PASSWORD_FIELD, CROSS_REALM_TRUST_PRINCIPAL_PASSWORD_FIELD, AD_DOMAIN_JOIN_USER_FIELD, AD_DOMAIN_JOIN_PASSWORD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KerberosAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String realm;
    private final String kdcAdminPassword;
    private final String crossRealmTrustPrincipalPassword;
    private final String adDomainJoinUser;
    private final String adDomainJoinPassword;

    private KerberosAttributes(BuilderImpl builder) {
        this.realm = builder.realm;
        this.kdcAdminPassword = builder.kdcAdminPassword;
        this.crossRealmTrustPrincipalPassword = builder.crossRealmTrustPrincipalPassword;
        this.adDomainJoinUser = builder.adDomainJoinUser;
        this.adDomainJoinPassword = builder.adDomainJoinPassword;
    }

    public final String realm() {
        return this.realm;
    }

    public final String kdcAdminPassword() {
        return this.kdcAdminPassword;
    }

    public final String crossRealmTrustPrincipalPassword() {
        return this.crossRealmTrustPrincipalPassword;
    }

    public final String adDomainJoinUser() {
        return this.adDomainJoinUser;
    }

    public final String adDomainJoinPassword() {
        return this.adDomainJoinPassword;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.realm());
        hashCode = 31 * hashCode + Objects.hashCode(this.kdcAdminPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.crossRealmTrustPrincipalPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.adDomainJoinUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.adDomainJoinPassword());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KerberosAttributes)) {
            return false;
        }
        KerberosAttributes other = (KerberosAttributes)obj;
        return Objects.equals(this.realm(), other.realm()) && Objects.equals(this.kdcAdminPassword(), other.kdcAdminPassword()) && Objects.equals(this.crossRealmTrustPrincipalPassword(), other.crossRealmTrustPrincipalPassword()) && Objects.equals(this.adDomainJoinUser(), other.adDomainJoinUser()) && Objects.equals(this.adDomainJoinPassword(), other.adDomainJoinPassword());
    }

    public final String toString() {
        return ToString.builder((String)"KerberosAttributes").add("Realm", (Object)this.realm()).add("KdcAdminPassword", (Object)this.kdcAdminPassword()).add("CrossRealmTrustPrincipalPassword", (Object)this.crossRealmTrustPrincipalPassword()).add("ADDomainJoinUser", (Object)this.adDomainJoinUser()).add("ADDomainJoinPassword", (Object)this.adDomainJoinPassword()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Realm": {
                return Optional.ofNullable(clazz.cast(this.realm()));
            }
            case "KdcAdminPassword": {
                return Optional.ofNullable(clazz.cast(this.kdcAdminPassword()));
            }
            case "CrossRealmTrustPrincipalPassword": {
                return Optional.ofNullable(clazz.cast(this.crossRealmTrustPrincipalPassword()));
            }
            case "ADDomainJoinUser": {
                return Optional.ofNullable(clazz.cast(this.adDomainJoinUser()));
            }
            case "ADDomainJoinPassword": {
                return Optional.ofNullable(clazz.cast(this.adDomainJoinPassword()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Realm", REALM_FIELD);
        map.put("KdcAdminPassword", KDC_ADMIN_PASSWORD_FIELD);
        map.put("CrossRealmTrustPrincipalPassword", CROSS_REALM_TRUST_PRINCIPAL_PASSWORD_FIELD);
        map.put("ADDomainJoinUser", AD_DOMAIN_JOIN_USER_FIELD);
        map.put("ADDomainJoinPassword", AD_DOMAIN_JOIN_PASSWORD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KerberosAttributes, T> g) {
        return obj -> g.apply((KerberosAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String realm;
        private String kdcAdminPassword;
        private String crossRealmTrustPrincipalPassword;
        private String adDomainJoinUser;
        private String adDomainJoinPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(KerberosAttributes model) {
            this.realm(model.realm);
            this.kdcAdminPassword(model.kdcAdminPassword);
            this.crossRealmTrustPrincipalPassword(model.crossRealmTrustPrincipalPassword);
            this.adDomainJoinUser(model.adDomainJoinUser);
            this.adDomainJoinPassword(model.adDomainJoinPassword);
        }

        public final String getRealm() {
            return this.realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final String getKdcAdminPassword() {
            return this.kdcAdminPassword;
        }

        public final void setKdcAdminPassword(String kdcAdminPassword) {
            this.kdcAdminPassword = kdcAdminPassword;
        }

        @Override
        public final Builder kdcAdminPassword(String kdcAdminPassword) {
            this.kdcAdminPassword = kdcAdminPassword;
            return this;
        }

        public final String getCrossRealmTrustPrincipalPassword() {
            return this.crossRealmTrustPrincipalPassword;
        }

        public final void setCrossRealmTrustPrincipalPassword(String crossRealmTrustPrincipalPassword) {
            this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
        }

        @Override
        public final Builder crossRealmTrustPrincipalPassword(String crossRealmTrustPrincipalPassword) {
            this.crossRealmTrustPrincipalPassword = crossRealmTrustPrincipalPassword;
            return this;
        }

        public final String getAdDomainJoinUser() {
            return this.adDomainJoinUser;
        }

        public final void setAdDomainJoinUser(String adDomainJoinUser) {
            this.adDomainJoinUser = adDomainJoinUser;
        }

        @Override
        public final Builder adDomainJoinUser(String adDomainJoinUser) {
            this.adDomainJoinUser = adDomainJoinUser;
            return this;
        }

        public final String getAdDomainJoinPassword() {
            return this.adDomainJoinPassword;
        }

        public final void setAdDomainJoinPassword(String adDomainJoinPassword) {
            this.adDomainJoinPassword = adDomainJoinPassword;
        }

        @Override
        public final Builder adDomainJoinPassword(String adDomainJoinPassword) {
            this.adDomainJoinPassword = adDomainJoinPassword;
            return this;
        }

        public KerberosAttributes build() {
            return new KerberosAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KerberosAttributes> {
        public Builder realm(String var1);

        public Builder kdcAdminPassword(String var1);

        public Builder crossRealmTrustPrincipalPassword(String var1);

        public Builder adDomainJoinUser(String var1);

        public Builder adDomainJoinPassword(String var1);
    }
}

