/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EbsConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceTypeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceTypeConfig> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceTypeConfig.getter(InstanceTypeConfig::instanceType)).setter(InstanceTypeConfig.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> WEIGHTED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(InstanceTypeConfig.getter(InstanceTypeConfig::weightedCapacity)).setter(InstanceTypeConfig.setter(Builder::weightedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity").build()}).build();
    private static final SdkField<String> BID_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(InstanceTypeConfig.getter(InstanceTypeConfig::bidPrice)).setter(InstanceTypeConfig.setter(Builder::bidPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BidPrice").build()}).build();
    private static final SdkField<Double> BID_PRICE_AS_PERCENTAGE_OF_ON_DEMAND_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(InstanceTypeConfig.getter(InstanceTypeConfig::bidPriceAsPercentageOfOnDemandPrice)).setter(InstanceTypeConfig.setter(Builder::bidPriceAsPercentageOfOnDemandPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BidPriceAsPercentageOfOnDemandPrice").build()}).build();
    private static final SdkField<EbsConfiguration> EBS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(InstanceTypeConfig.getter(InstanceTypeConfig::ebsConfiguration)).setter(InstanceTypeConfig.setter(Builder::ebsConfiguration)).constructor(EbsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsConfiguration").build()}).build();
    private static final SdkField<List<Configuration>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceTypeConfig.getter(InstanceTypeConfig::configurations)).setter(InstanceTypeConfig.setter(Builder::configurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, WEIGHTED_CAPACITY_FIELD, BID_PRICE_FIELD, BID_PRICE_AS_PERCENTAGE_OF_ON_DEMAND_PRICE_FIELD, EBS_CONFIGURATION_FIELD, CONFIGURATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final Integer weightedCapacity;
    private final String bidPrice;
    private final Double bidPriceAsPercentageOfOnDemandPrice;
    private final EbsConfiguration ebsConfiguration;
    private final List<Configuration> configurations;

    private InstanceTypeConfig(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.weightedCapacity = builder.weightedCapacity;
        this.bidPrice = builder.bidPrice;
        this.bidPriceAsPercentageOfOnDemandPrice = builder.bidPriceAsPercentageOfOnDemandPrice;
        this.ebsConfiguration = builder.ebsConfiguration;
        this.configurations = builder.configurations;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer weightedCapacity() {
        return this.weightedCapacity;
    }

    public String bidPrice() {
        return this.bidPrice;
    }

    public Double bidPriceAsPercentageOfOnDemandPrice() {
        return this.bidPriceAsPercentageOfOnDemandPrice;
    }

    public EbsConfiguration ebsConfiguration() {
        return this.ebsConfiguration;
    }

    public List<Configuration> configurations() {
        return this.configurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPriceAsPercentageOfOnDemandPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurations());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeConfig)) {
            return false;
        }
        InstanceTypeConfig other = (InstanceTypeConfig)obj;
        return Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.weightedCapacity(), other.weightedCapacity()) && Objects.equals(this.bidPrice(), other.bidPrice()) && Objects.equals(this.bidPriceAsPercentageOfOnDemandPrice(), other.bidPriceAsPercentageOfOnDemandPrice()) && Objects.equals(this.ebsConfiguration(), other.ebsConfiguration()) && Objects.equals(this.configurations(), other.configurations());
    }

    public String toString() {
        return ToString.builder((String)"InstanceTypeConfig").add("InstanceType", (Object)this.instanceType()).add("WeightedCapacity", (Object)this.weightedCapacity()).add("BidPrice", (Object)this.bidPrice()).add("BidPriceAsPercentageOfOnDemandPrice", (Object)this.bidPriceAsPercentageOfOnDemandPrice()).add("EbsConfiguration", (Object)this.ebsConfiguration()).add("Configurations", this.configurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "WeightedCapacity": {
                return Optional.ofNullable(clazz.cast(this.weightedCapacity()));
            }
            case "BidPrice": {
                return Optional.ofNullable(clazz.cast(this.bidPrice()));
            }
            case "BidPriceAsPercentageOfOnDemandPrice": {
                return Optional.ofNullable(clazz.cast(this.bidPriceAsPercentageOfOnDemandPrice()));
            }
            case "EbsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.ebsConfiguration()));
            }
            case "Configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceTypeConfig, T> g) {
        return obj -> g.apply((InstanceTypeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Integer weightedCapacity;
        private String bidPrice;
        private Double bidPriceAsPercentageOfOnDemandPrice;
        private EbsConfiguration ebsConfiguration;
        private List<Configuration> configurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTypeConfig model) {
            this.instanceType(model.instanceType);
            this.weightedCapacity(model.weightedCapacity);
            this.bidPrice(model.bidPrice);
            this.bidPriceAsPercentageOfOnDemandPrice(model.bidPriceAsPercentageOfOnDemandPrice);
            this.ebsConfiguration(model.ebsConfiguration);
            this.configurations(model.configurations);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getWeightedCapacity() {
            return this.weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Integer weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final void setWeightedCapacity(Integer weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        public final String getBidPrice() {
            return this.bidPrice;
        }

        @Override
        public final Builder bidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        public final void setBidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
        }

        public final Double getBidPriceAsPercentageOfOnDemandPrice() {
            return this.bidPriceAsPercentageOfOnDemandPrice;
        }

        @Override
        public final Builder bidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
            this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
            return this;
        }

        public final void setBidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
            this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
        }

        public final EbsConfiguration.Builder getEbsConfiguration() {
            return this.ebsConfiguration != null ? this.ebsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder ebsConfiguration(EbsConfiguration ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration;
            return this;
        }

        public final void setEbsConfiguration(EbsConfiguration.BuilderImpl ebsConfiguration) {
            this.ebsConfiguration = ebsConfiguration != null ? ebsConfiguration.build() : null;
        }

        public final Collection<Configuration.Builder> getConfigurations() {
            return this.configurations != null ? (Collection)this.configurations.stream().map(Configuration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurations(Consumer<Configuration.Builder> ... configurations) {
            this.configurations(Stream.of(configurations).map(c -> (Configuration)((Configuration.Builder)Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        public InstanceTypeConfig build() {
            return new InstanceTypeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceTypeConfig> {
        public Builder instanceType(String var1);

        public Builder weightedCapacity(Integer var1);

        public Builder bidPrice(String var1);

        public Builder bidPriceAsPercentageOfOnDemandPrice(Double var1);

        public Builder ebsConfiguration(EbsConfiguration var1);

        default public Builder ebsConfiguration(Consumer<EbsConfiguration.Builder> ebsConfiguration) {
            return this.ebsConfiguration((EbsConfiguration)((EbsConfiguration.Builder)EbsConfiguration.builder().applyMutation(ebsConfiguration)).build());
        }

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder configurations(Consumer<Configuration.Builder> ... var1);
    }
}

