/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveAutoScalingPolicyRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, RemoveAutoScalingPolicyRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoveAutoScalingPolicyRequest.getter(RemoveAutoScalingPolicyRequest::clusterId)).setter(RemoveAutoScalingPolicyRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RemoveAutoScalingPolicyRequest.getter(RemoveAutoScalingPolicyRequest::instanceGroupId)).setter(RemoveAutoScalingPolicyRequest.setter(Builder::instanceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, INSTANCE_GROUP_ID_FIELD));
    private final String clusterId;
    private final String instanceGroupId;

    private RemoveAutoScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceGroupId = builder.instanceGroupId;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public String instanceGroupId() {
        return this.instanceGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveAutoScalingPolicyRequest)) {
            return false;
        }
        RemoveAutoScalingPolicyRequest other = (RemoveAutoScalingPolicyRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceGroupId(), other.instanceGroupId());
    }

    public String toString() {
        return ToString.builder((String)"RemoveAutoScalingPolicyRequest").add("ClusterId", (Object)this.clusterId()).add("InstanceGroupId", (Object)this.instanceGroupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "InstanceGroupId": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveAutoScalingPolicyRequest, T> g) {
        return obj -> g.apply((RemoveAutoScalingPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private String instanceGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveAutoScalingPolicyRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.instanceGroupId(model.instanceGroupId);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveAutoScalingPolicyRequest build() {
            return new RemoveAutoScalingPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveAutoScalingPolicyRequest> {
        public Builder clusterId(String var1);

        public Builder instanceGroupId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

