/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elastictranscoder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elastictranscoder.model.AccessControlsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Permission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Permission> {
    private static final SdkField<String> GRANTEE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GranteeType").getter(Permission.getter(Permission::granteeType)).setter(Permission.setter(Builder::granteeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeType").build()}).build();
    private static final SdkField<String> GRANTEE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Grantee").getter(Permission.getter(Permission::grantee)).setter(Permission.setter(Builder::grantee)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Grantee").build()}).build();
    private static final SdkField<List<String>> ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Access").getter(Permission.getter(Permission::access)).setter(Permission.setter(Builder::access)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Access").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANTEE_TYPE_FIELD, GRANTEE_FIELD, ACCESS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String granteeType;
    private final String grantee;
    private final List<String> access;

    private Permission(BuilderImpl builder) {
        this.granteeType = builder.granteeType;
        this.grantee = builder.grantee;
        this.access = builder.access;
    }

    public final String granteeType() {
        return this.granteeType;
    }

    public final String grantee() {
        return this.grantee;
    }

    public final boolean hasAccess() {
        return this.access != null && !(this.access instanceof SdkAutoConstructList);
    }

    public final List<String> access() {
        return this.access;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.granteeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantee());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccess() ? this.access() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        return Objects.equals(this.granteeType(), other.granteeType()) && Objects.equals(this.grantee(), other.grantee()) && this.hasAccess() == other.hasAccess() && Objects.equals(this.access(), other.access());
    }

    public final String toString() {
        return ToString.builder((String)"Permission").add("GranteeType", (Object)this.granteeType()).add("Grantee", (Object)this.grantee()).add("Access", this.hasAccess() ? this.access() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GranteeType": {
                return Optional.ofNullable(clazz.cast(this.granteeType()));
            }
            case "Grantee": {
                return Optional.ofNullable(clazz.cast(this.grantee()));
            }
            case "Access": {
                return Optional.ofNullable(clazz.cast(this.access()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Permission, T> g) {
        return obj -> g.apply((Permission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String granteeType;
        private String grantee;
        private List<String> access = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Permission model) {
            this.granteeType(model.granteeType);
            this.grantee(model.grantee);
            this.access(model.access);
        }

        public final String getGranteeType() {
            return this.granteeType;
        }

        @Override
        public final Builder granteeType(String granteeType) {
            this.granteeType = granteeType;
            return this;
        }

        public final void setGranteeType(String granteeType) {
            this.granteeType = granteeType;
        }

        public final String getGrantee() {
            return this.grantee;
        }

        @Override
        public final Builder grantee(String grantee) {
            this.grantee = grantee;
            return this;
        }

        public final void setGrantee(String grantee) {
            this.grantee = grantee;
        }

        public final Collection<String> getAccess() {
            if (this.access instanceof SdkAutoConstructList) {
                return null;
            }
            return this.access;
        }

        @Override
        public final Builder access(Collection<String> access) {
            this.access = AccessControlsCopier.copy(access);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder access(String ... access) {
            this.access(Arrays.asList(access));
            return this;
        }

        public final void setAccess(Collection<String> access) {
            this.access = AccessControlsCopier.copy(access);
        }

        public Permission build() {
            return new Permission(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Permission> {
        public Builder granteeType(String var1);

        public Builder grantee(String var1);

        public Builder access(Collection<String> var1);

        public Builder access(String ... var1);
    }
}

