/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>ListJobsByStatusRequest</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobsByStatusRequest extends ElasticTranscoderRequest implements
        ToCopyableBuilder<ListJobsByStatusRequest.Builder, ListJobsByStatusRequest> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListJobsByStatusRequest::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Status").build()).build();

    private static final SdkField<String> ASCENDING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ascending").getter(getter(ListJobsByStatusRequest::ascending)).setter(setter(Builder::ascending))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("Ascending").build()).build();

    private static final SdkField<String> PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PageToken").getter(getter(ListJobsByStatusRequest::pageToken)).setter(setter(Builder::pageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("PageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ASCENDING_FIELD,
            PAGE_TOKEN_FIELD));

    private final String status;

    private final String ascending;

    private final String pageToken;

    private ListJobsByStatusRequest(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.ascending = builder.ascending;
        this.pageToken = builder.pageToken;
    }

    /**
     * <p>
     * To get information about all of the jobs associated with the current AWS account that have a given status,
     * specify the following status: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>,
     * <code>Canceled</code>, or <code>Error</code>.
     * </p>
     * 
     * @return To get information about all of the jobs associated with the current AWS account that have a given
     *         status, specify the following status: <code>Submitted</code>, <code>Progressing</code>,
     *         <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * To list jobs in chronological order by the date and time that they were submitted, enter <code>true</code>. To
     * list jobs in reverse chronological order, enter <code>false</code>.
     * </p>
     * 
     * @return To list jobs in chronological order by the date and time that they were submitted, enter
     *         <code>true</code>. To list jobs in reverse chronological order, enter <code>false</code>.
     */
    public final String ascending() {
        return ascending;
    }

    /**
     * <p>
     * When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent
     * <code>GET</code> requests to get each successive page of results.
     * </p>
     * 
     * @return When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent
     *         <code>GET</code> requests to get each successive page of results.
     */
    public final String pageToken() {
        return pageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(ascending());
        hashCode = 31 * hashCode + Objects.hashCode(pageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobsByStatusRequest)) {
            return false;
        }
        ListJobsByStatusRequest other = (ListJobsByStatusRequest) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(ascending(), other.ascending())
                && Objects.equals(pageToken(), other.pageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobsByStatusRequest").add("Status", status()).add("Ascending", ascending())
                .add("PageToken", pageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Ascending":
            return Optional.ofNullable(clazz.cast(ascending()));
        case "PageToken":
            return Optional.ofNullable(clazz.cast(pageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListJobsByStatusRequest, T> g) {
        return obj -> g.apply((ListJobsByStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListJobsByStatusRequest> {
        /**
         * <p>
         * To get information about all of the jobs associated with the current AWS account that have a given status,
         * specify the following status: <code>Submitted</code>, <code>Progressing</code>, <code>Complete</code>,
         * <code>Canceled</code>, or <code>Error</code>.
         * </p>
         * 
         * @param status
         *        To get information about all of the jobs associated with the current AWS account that have a given
         *        status, specify the following status: <code>Submitted</code>, <code>Progressing</code>,
         *        <code>Complete</code>, <code>Canceled</code>, or <code>Error</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * To list jobs in chronological order by the date and time that they were submitted, enter <code>true</code>.
         * To list jobs in reverse chronological order, enter <code>false</code>.
         * </p>
         * 
         * @param ascending
         *        To list jobs in chronological order by the date and time that they were submitted, enter
         *        <code>true</code>. To list jobs in reverse chronological order, enter <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ascending(String ascending);

        /**
         * <p>
         * When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in subsequent
         * <code>GET</code> requests to get each successive page of results.
         * </p>
         * 
         * @param pageToken
         *        When Elastic Transcoder returns more than one page of results, use <code>pageToken</code> in
         *        subsequent <code>GET</code> requests to get each successive page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageToken(String pageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticTranscoderRequest.BuilderImpl implements Builder {
        private String status;

        private String ascending;

        private String pageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobsByStatusRequest model) {
            super(model);
            status(model.status);
            ascending(model.ascending);
            pageToken(model.pageToken);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getAscending() {
            return ascending;
        }

        @Override
        public final Builder ascending(String ascending) {
            this.ascending = ascending;
            return this;
        }

        public final void setAscending(String ascending) {
            this.ascending = ascending;
        }

        public final String getPageToken() {
            return pageToken;
        }

        @Override
        public final Builder pageToken(String pageToken) {
            this.pageToken = pageToken;
            return this;
        }

        public final void setPageToken(String pageToken) {
            this.pageToken = pageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListJobsByStatusRequest build() {
            return new ListJobsByStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
