/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elastictranscoder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>CreatePresetResponse</code> structure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePresetResponse extends ElasticTranscoderResponse implements
        ToCopyableBuilder<CreatePresetResponse.Builder, CreatePresetResponse> {
    private static final SdkField<Preset> PRESET_FIELD = SdkField.<Preset> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreatePresetResponse::preset)).setter(setter(Builder::preset)).constructor(Preset::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Preset").build()).build();

    private static final SdkField<String> WARNING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreatePresetResponse::warning)).setter(setter(Builder::warning))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warning").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRESET_FIELD, WARNING_FIELD));

    private final Preset preset;

    private final String warning;

    private CreatePresetResponse(BuilderImpl builder) {
        super(builder);
        this.preset = builder.preset;
        this.warning = builder.warning;
    }

    /**
     * <p>
     * A section of the response body that provides information about the preset that is created.
     * </p>
     * 
     * @return A section of the response body that provides information about the preset that is created.
     */
    public Preset preset() {
        return preset;
    }

    /**
     * <p>
     * If the preset settings don't comply with the standards for the video codec but Elastic Transcoder created the
     * preset, this message explains the reason the preset settings don't meet the standard. Elastic Transcoder created
     * the preset because the settings might produce acceptable output.
     * </p>
     * 
     * @return If the preset settings don't comply with the standards for the video codec but Elastic Transcoder created
     *         the preset, this message explains the reason the preset settings don't meet the standard. Elastic
     *         Transcoder created the preset because the settings might produce acceptable output.
     */
    public String warning() {
        return warning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(preset());
        hashCode = 31 * hashCode + Objects.hashCode(warning());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePresetResponse)) {
            return false;
        }
        CreatePresetResponse other = (CreatePresetResponse) obj;
        return Objects.equals(preset(), other.preset()) && Objects.equals(warning(), other.warning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreatePresetResponse").add("Preset", preset()).add("Warning", warning()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Preset":
            return Optional.ofNullable(clazz.cast(preset()));
        case "Warning":
            return Optional.ofNullable(clazz.cast(warning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePresetResponse, T> g) {
        return obj -> g.apply((CreatePresetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticTranscoderResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePresetResponse> {
        /**
         * <p>
         * A section of the response body that provides information about the preset that is created.
         * </p>
         * 
         * @param preset
         *        A section of the response body that provides information about the preset that is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preset(Preset preset);

        /**
         * <p>
         * A section of the response body that provides information about the preset that is created.
         * </p>
         * This is a convenience that creates an instance of the {@link Preset.Builder} avoiding the need to create one
         * manually via {@link Preset#builder()}.
         *
         * When the {@link Consumer} completes, {@link Preset.Builder#build()} is called immediately and its result is
         * passed to {@link #preset(Preset)}.
         * 
         * @param preset
         *        a consumer that will call methods on {@link Preset.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #preset(Preset)
         */
        default Builder preset(Consumer<Preset.Builder> preset) {
            return preset(Preset.builder().applyMutation(preset).build());
        }

        /**
         * <p>
         * If the preset settings don't comply with the standards for the video codec but Elastic Transcoder created the
         * preset, this message explains the reason the preset settings don't meet the standard. Elastic Transcoder
         * created the preset because the settings might produce acceptable output.
         * </p>
         * 
         * @param warning
         *        If the preset settings don't comply with the standards for the video codec but Elastic Transcoder
         *        created the preset, this message explains the reason the preset settings don't meet the standard.
         *        Elastic Transcoder created the preset because the settings might produce acceptable output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warning(String warning);
    }

    static final class BuilderImpl extends ElasticTranscoderResponse.BuilderImpl implements Builder {
        private Preset preset;

        private String warning;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePresetResponse model) {
            super(model);
            preset(model.preset);
            warning(model.warning);
        }

        public final Preset.Builder getPreset() {
            return preset != null ? preset.toBuilder() : null;
        }

        @Override
        public final Builder preset(Preset preset) {
            this.preset = preset;
            return this;
        }

        public final void setPreset(Preset.BuilderImpl preset) {
            this.preset = preset != null ? preset.build() : null;
        }

        public final String getWarning() {
            return warning;
        }

        @Override
        public final Builder warning(String warning) {
            this.warning = warning;
            return this;
        }

        public final void setWarning(String warning) {
            this.warning = warning;
        }

        @Override
        public CreatePresetResponse build() {
            return new CreatePresetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
