/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchClusterConfig;
import software.amazon.awssdk.services.elasticsearch.model.OptionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ElasticsearchClusterConfigStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ElasticsearchClusterConfigStatus> {
    private static final SdkField<ElasticsearchClusterConfig> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchClusterConfigStatus.getter(ElasticsearchClusterConfigStatus::options)).setter(ElasticsearchClusterConfigStatus.setter(Builder::options)).constructor(ElasticsearchClusterConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()}).build();
    private static final SdkField<OptionStatus> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ElasticsearchClusterConfigStatus.getter(ElasticsearchClusterConfigStatus::status)).setter(ElasticsearchClusterConfigStatus.setter(Builder::status)).constructor(OptionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ElasticsearchClusterConfig options;
    private final OptionStatus status;

    private ElasticsearchClusterConfigStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    public ElasticsearchClusterConfig options() {
        return this.options;
    }

    public OptionStatus status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.options());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticsearchClusterConfigStatus)) {
            return false;
        }
        ElasticsearchClusterConfigStatus other = (ElasticsearchClusterConfigStatus)obj;
        return Objects.equals(this.options(), other.options()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"ElasticsearchClusterConfigStatus").add("Options", (Object)this.options()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticsearchClusterConfigStatus, T> g) {
        return obj -> g.apply((ElasticsearchClusterConfigStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ElasticsearchClusterConfig options;
        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticsearchClusterConfigStatus model) {
            this.options(model.options);
            this.status(model.status);
        }

        public final ElasticsearchClusterConfig.Builder getOptions() {
            return this.options != null ? this.options.toBuilder() : null;
        }

        @Override
        public final Builder options(ElasticsearchClusterConfig options) {
            this.options = options;
            return this;
        }

        public final void setOptions(ElasticsearchClusterConfig.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final OptionStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(OptionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public ElasticsearchClusterConfigStatus build() {
            return new ElasticsearchClusterConfigStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ElasticsearchClusterConfigStatus> {
        public Builder options(ElasticsearchClusterConfig var1);

        default public Builder options(Consumer<ElasticsearchClusterConfig.Builder> options) {
            return this.options((ElasticsearchClusterConfig)((ElasticsearchClusterConfig.Builder)ElasticsearchClusterConfig.builder().applyMutation(options)).build());
        }

        public Builder status(OptionStatus var1);

        default public Builder status(Consumer<OptionStatus.Builder> status) {
            return this.status((OptionStatus)((OptionStatus.Builder)OptionStatus.builder().applyMutation(status)).build());
        }
    }
}

