/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.elasticsearch.model.ElasticsearchResponse;
import software.amazon.awssdk.services.elasticsearch.model.Limits;
import software.amazon.awssdk.services.elasticsearch.model.LimitsByRoleCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeElasticsearchInstanceTypeLimitsResponse
extends ElasticsearchResponse
implements ToCopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsResponse> {
    private static final SdkField<Map<String, Limits>> LIMITS_BY_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(DescribeElasticsearchInstanceTypeLimitsResponse.getter(DescribeElasticsearchInstanceTypeLimitsResponse::limitsByRole)).setter(DescribeElasticsearchInstanceTypeLimitsResponse.setter(Builder::limitsByRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitsByRole").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Limits::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMITS_BY_ROLE_FIELD));
    private final Map<String, Limits> limitsByRole;

    private DescribeElasticsearchInstanceTypeLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.limitsByRole = builder.limitsByRole;
    }

    public Map<String, Limits> limitsByRole() {
        return this.limitsByRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.limitsByRole());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticsearchInstanceTypeLimitsResponse)) {
            return false;
        }
        DescribeElasticsearchInstanceTypeLimitsResponse other = (DescribeElasticsearchInstanceTypeLimitsResponse)((Object)obj);
        return Objects.equals(this.limitsByRole(), other.limitsByRole());
    }

    public String toString() {
        return ToString.builder((String)"DescribeElasticsearchInstanceTypeLimitsResponse").add("LimitsByRole", this.limitsByRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LimitsByRole": {
                return Optional.ofNullable(clazz.cast(this.limitsByRole()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticsearchInstanceTypeLimitsResponse, T> g) {
        return obj -> g.apply((DescribeElasticsearchInstanceTypeLimitsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticsearchResponse.BuilderImpl
    implements Builder {
        private Map<String, Limits> limitsByRole = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticsearchInstanceTypeLimitsResponse model) {
            super(model);
            this.limitsByRole(model.limitsByRole);
        }

        public final Map<String, Limits.Builder> getLimitsByRole() {
            return this.limitsByRole != null ? CollectionUtils.mapValues(this.limitsByRole, Limits::toBuilder) : null;
        }

        @Override
        public final Builder limitsByRole(Map<String, Limits> limitsByRole) {
            this.limitsByRole = LimitsByRoleCopier.copy(limitsByRole);
            return this;
        }

        public final void setLimitsByRole(Map<String, Limits.BuilderImpl> limitsByRole) {
            this.limitsByRole = LimitsByRoleCopier.copyFromBuilder(limitsByRole);
        }

        @Override
        public DescribeElasticsearchInstanceTypeLimitsResponse build() {
            return new DescribeElasticsearchInstanceTypeLimitsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticsearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeElasticsearchInstanceTypeLimitsResponse> {
        public Builder limitsByRole(Map<String, Limits> var1);
    }
}

