/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchAsyncClient;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryRequest;
import software.amazon.awssdk.services.elasticsearch.model.GetUpgradeHistoryResponse;

public class GetUpgradeHistoryPublisher
implements SdkPublisher<GetUpgradeHistoryResponse> {
    private final ElasticsearchAsyncClient client;
    private final GetUpgradeHistoryRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetUpgradeHistoryPublisher(ElasticsearchAsyncClient client, GetUpgradeHistoryRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetUpgradeHistoryPublisher(ElasticsearchAsyncClient client, GetUpgradeHistoryRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetUpgradeHistoryResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetUpgradeHistoryResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final GetUpgradeHistoryPublisher resume(GetUpgradeHistoryResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetUpgradeHistoryPublisher(this.client, (GetUpgradeHistoryRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetUpgradeHistoryPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetUpgradeHistoryResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetUpgradeHistoryResponseFetcher
    implements AsyncPageFetcher<GetUpgradeHistoryResponse> {
        private GetUpgradeHistoryResponseFetcher() {
        }

        public boolean hasNextPage(GetUpgradeHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetUpgradeHistoryResponse> nextPage(GetUpgradeHistoryResponse previousPage) {
            if (previousPage == null) {
                return GetUpgradeHistoryPublisher.this.client.getUpgradeHistory(GetUpgradeHistoryPublisher.this.firstRequest);
            }
            return GetUpgradeHistoryPublisher.this.client.getUpgradeHistory((GetUpgradeHistoryRequest)((Object)GetUpgradeHistoryPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

