/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticsearch.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticsearch.ElasticsearchClient;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesRequest;
import software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchInstanceTypesResponse;

public class ListElasticsearchInstanceTypesIterable
implements SdkIterable<ListElasticsearchInstanceTypesResponse> {
    private final ElasticsearchClient client;
    private final ListElasticsearchInstanceTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListElasticsearchInstanceTypesIterable(ElasticsearchClient client, ListElasticsearchInstanceTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListElasticsearchInstanceTypesResponseFetcher();
    }

    public Iterator<ListElasticsearchInstanceTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListElasticsearchInstanceTypesIterable resume(ListElasticsearchInstanceTypesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListElasticsearchInstanceTypesIterable(this.client, (ListElasticsearchInstanceTypesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListElasticsearchInstanceTypesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListElasticsearchInstanceTypesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListElasticsearchInstanceTypesResponseFetcher
    implements SyncPageFetcher<ListElasticsearchInstanceTypesResponse> {
        private ListElasticsearchInstanceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListElasticsearchInstanceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListElasticsearchInstanceTypesResponse nextPage(ListElasticsearchInstanceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListElasticsearchInstanceTypesIterable.this.client.listElasticsearchInstanceTypes(ListElasticsearchInstanceTypesIterable.this.firstRequest);
            }
            return ListElasticsearchInstanceTypesIterable.this.client.listElasticsearchInstanceTypes((ListElasticsearchInstanceTypesRequest)((Object)ListElasticsearchInstanceTypesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

