/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TransformTypeEnum {
    HOST_HEADER_REWRITE("host-header-rewrite"),
    URL_REWRITE("url-rewrite"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TransformTypeEnum> VALUE_MAP;
    private final String value;

    private TransformTypeEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TransformTypeEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TransformTypeEnum> knownValues() {
        EnumSet<TransformTypeEnum> knownValues = EnumSet.allOf(TransformTypeEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TransformTypeEnum.class, TransformTypeEnum::toString);
    }
}

