/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2AsyncClient;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Rule;

public class DescribeRulesPublisher
implements SdkPublisher<DescribeRulesResponse> {
    private final ElasticLoadBalancingV2AsyncClient client;
    private final DescribeRulesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeRulesPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeRulesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeRulesPublisher(ElasticLoadBalancingV2AsyncClient client, DescribeRulesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeRulesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeRulesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Rule> rules() {
        return this.flatMapIterable(response -> response.rules());
    }

    private class DescribeRulesResponseFetcher
    implements AsyncPageFetcher<DescribeRulesResponse> {
        private DescribeRulesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public CompletableFuture<DescribeRulesResponse> nextPage(DescribeRulesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRulesPublisher.this.client.describeRules(DescribeRulesPublisher.this.firstRequest);
            }
            return DescribeRulesPublisher.this.client.describeRules((DescribeRulesRequest)((Object)DescribeRulesPublisher.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

