/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a host header rewrite transform. This transform matches a pattern in the host header in an HTTP
 * request and replaces it with the specified string.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HostHeaderRewriteConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<HostHeaderRewriteConfig.Builder, HostHeaderRewriteConfig> {
    private static final SdkField<List<RewriteConfig>> REWRITES_FIELD = SdkField
            .<List<RewriteConfig>> builder(MarshallingType.LIST)
            .memberName("Rewrites")
            .getter(getter(HostHeaderRewriteConfig::rewrites))
            .setter(setter(Builder::rewrites))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rewrites").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RewriteConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(RewriteConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REWRITES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RewriteConfig> rewrites;

    private HostHeaderRewriteConfig(BuilderImpl builder) {
        this.rewrites = builder.rewrites;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rewrites property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRewrites() {
        return rewrites != null && !(rewrites instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The host header rewrite transform. Each transform consists of a regular expression to match and a replacement
     * string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRewrites} method.
     * </p>
     * 
     * @return The host header rewrite transform. Each transform consists of a regular expression to match and a
     *         replacement string.
     */
    public final List<RewriteConfig> rewrites() {
        return rewrites;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRewrites() ? rewrites() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HostHeaderRewriteConfig)) {
            return false;
        }
        HostHeaderRewriteConfig other = (HostHeaderRewriteConfig) obj;
        return hasRewrites() == other.hasRewrites() && Objects.equals(rewrites(), other.rewrites());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HostHeaderRewriteConfig").add("Rewrites", hasRewrites() ? rewrites() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rewrites":
            return Optional.ofNullable(clazz.cast(rewrites()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Rewrites", REWRITES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HostHeaderRewriteConfig, T> g) {
        return obj -> g.apply((HostHeaderRewriteConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HostHeaderRewriteConfig> {
        /**
         * <p>
         * The host header rewrite transform. Each transform consists of a regular expression to match and a replacement
         * string.
         * </p>
         * 
         * @param rewrites
         *        The host header rewrite transform. Each transform consists of a regular expression to match and a
         *        replacement string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rewrites(Collection<RewriteConfig> rewrites);

        /**
         * <p>
         * The host header rewrite transform. Each transform consists of a regular expression to match and a replacement
         * string.
         * </p>
         * 
         * @param rewrites
         *        The host header rewrite transform. Each transform consists of a regular expression to match and a
         *        replacement string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rewrites(RewriteConfig... rewrites);

        /**
         * <p>
         * The host header rewrite transform. Each transform consists of a regular expression to match and a replacement
         * string.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RewriteConfig.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RewriteConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RewriteConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #rewrites(List<RewriteConfig>)}.
         * 
         * @param rewrites
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.RewriteConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rewrites(java.util.Collection<RewriteConfig>)
         */
        Builder rewrites(Consumer<RewriteConfig.Builder>... rewrites);
    }

    static final class BuilderImpl implements Builder {
        private List<RewriteConfig> rewrites = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HostHeaderRewriteConfig model) {
            rewrites(model.rewrites);
        }

        public final List<RewriteConfig.Builder> getRewrites() {
            List<RewriteConfig.Builder> result = RewriteConfigListCopier.copyToBuilder(this.rewrites);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRewrites(Collection<RewriteConfig.BuilderImpl> rewrites) {
            this.rewrites = RewriteConfigListCopier.copyFromBuilder(rewrites);
        }

        @Override
        public final Builder rewrites(Collection<RewriteConfig> rewrites) {
            this.rewrites = RewriteConfigListCopier.copy(rewrites);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rewrites(RewriteConfig... rewrites) {
            rewrites(Arrays.asList(rewrites));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rewrites(Consumer<RewriteConfig.Builder>... rewrites) {
            rewrites(Stream.of(rewrites).map(c -> RewriteConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public HostHeaderRewriteConfig build() {
            return new HostHeaderRewriteConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
