/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStore;

public class DescribeTrustStoresIterable
implements SdkIterable<DescribeTrustStoresResponse> {
    private final ElasticLoadBalancingV2Client client;
    private final DescribeTrustStoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTrustStoresIterable(ElasticLoadBalancingV2Client client, DescribeTrustStoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTrustStoresResponseFetcher();
    }

    public Iterator<DescribeTrustStoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TrustStore> trustStores() {
        Function<DescribeTrustStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.trustStores() != null) {
                return response.trustStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTrustStoresResponseFetcher
    implements SyncPageFetcher<DescribeTrustStoresResponse> {
        private DescribeTrustStoresResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrustStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextMarker());
        }

        public DescribeTrustStoresResponse nextPage(DescribeTrustStoresResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrustStoresIterable.this.client.describeTrustStores(DescribeTrustStoresIterable.this.firstRequest);
            }
            return DescribeTrustStoresIterable.this.client.describeTrustStores((DescribeTrustStoresRequest)((Object)DescribeTrustStoresIterable.this.firstRequest.toBuilder().marker(previousPage.nextMarker()).build()));
        }
    }
}

