/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about anomaly detection and mitigation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyDetection implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalyDetection.Builder, AnomalyDetection> {
    private static final SdkField<String> RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Result")
            .getter(getter(AnomalyDetection::resultAsString)).setter(setter(Builder::result))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Result").build()).build();

    private static final SdkField<String> MITIGATION_IN_EFFECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MitigationInEffect").getter(getter(AnomalyDetection::mitigationInEffectAsString))
            .setter(setter(Builder::mitigationInEffect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MitigationInEffect").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_FIELD,
            MITIGATION_IN_EFFECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String result;

    private final String mitigationInEffect;

    private AnomalyDetection(BuilderImpl builder) {
        this.result = builder.result;
        this.mitigationInEffect = builder.mitigationInEffect;
    }

    /**
     * <p>
     * The latest anomaly detection result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link AnomalyResultEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The latest anomaly detection result.
     * @see AnomalyResultEnum
     */
    public final AnomalyResultEnum result() {
        return AnomalyResultEnum.fromValue(result);
    }

    /**
     * <p>
     * The latest anomaly detection result.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #result} will
     * return {@link AnomalyResultEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resultAsString}.
     * </p>
     * 
     * @return The latest anomaly detection result.
     * @see AnomalyResultEnum
     */
    public final String resultAsString() {
        return result;
    }

    /**
     * <p>
     * Indicates whether anomaly mitigation is in progress.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mitigationInEffect} will return {@link MitigationInEffectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mitigationInEffectAsString}.
     * </p>
     * 
     * @return Indicates whether anomaly mitigation is in progress.
     * @see MitigationInEffectEnum
     */
    public final MitigationInEffectEnum mitigationInEffect() {
        return MitigationInEffectEnum.fromValue(mitigationInEffect);
    }

    /**
     * <p>
     * Indicates whether anomaly mitigation is in progress.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #mitigationInEffect} will return {@link MitigationInEffectEnum#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #mitigationInEffectAsString}.
     * </p>
     * 
     * @return Indicates whether anomaly mitigation is in progress.
     * @see MitigationInEffectEnum
     */
    public final String mitigationInEffectAsString() {
        return mitigationInEffect;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mitigationInEffectAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyDetection)) {
            return false;
        }
        AnomalyDetection other = (AnomalyDetection) obj;
        return Objects.equals(resultAsString(), other.resultAsString())
                && Objects.equals(mitigationInEffectAsString(), other.mitigationInEffectAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyDetection").add("Result", resultAsString())
                .add("MitigationInEffect", mitigationInEffectAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Result":
            return Optional.ofNullable(clazz.cast(resultAsString()));
        case "MitigationInEffect":
            return Optional.ofNullable(clazz.cast(mitigationInEffectAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Result", RESULT_FIELD);
        map.put("MitigationInEffect", MITIGATION_IN_EFFECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnomalyDetection, T> g) {
        return obj -> g.apply((AnomalyDetection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyDetection> {
        /**
         * <p>
         * The latest anomaly detection result.
         * </p>
         * 
         * @param result
         *        The latest anomaly detection result.
         * @see AnomalyResultEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyResultEnum
         */
        Builder result(String result);

        /**
         * <p>
         * The latest anomaly detection result.
         * </p>
         * 
         * @param result
         *        The latest anomaly detection result.
         * @see AnomalyResultEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyResultEnum
         */
        Builder result(AnomalyResultEnum result);

        /**
         * <p>
         * Indicates whether anomaly mitigation is in progress.
         * </p>
         * 
         * @param mitigationInEffect
         *        Indicates whether anomaly mitigation is in progress.
         * @see MitigationInEffectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MitigationInEffectEnum
         */
        Builder mitigationInEffect(String mitigationInEffect);

        /**
         * <p>
         * Indicates whether anomaly mitigation is in progress.
         * </p>
         * 
         * @param mitigationInEffect
         *        Indicates whether anomaly mitigation is in progress.
         * @see MitigationInEffectEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MitigationInEffectEnum
         */
        Builder mitigationInEffect(MitigationInEffectEnum mitigationInEffect);
    }

    static final class BuilderImpl implements Builder {
        private String result;

        private String mitigationInEffect;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyDetection model) {
            result(model.result);
            mitigationInEffect(model.mitigationInEffect);
        }

        public final String getResult() {
            return result;
        }

        public final void setResult(String result) {
            this.result = result;
        }

        @Override
        public final Builder result(String result) {
            this.result = result;
            return this;
        }

        @Override
        public final Builder result(AnomalyResultEnum result) {
            this.result(result == null ? null : result.toString());
            return this;
        }

        public final String getMitigationInEffect() {
            return mitigationInEffect;
        }

        public final void setMitigationInEffect(String mitigationInEffect) {
            this.mitigationInEffect = mitigationInEffect;
        }

        @Override
        public final Builder mitigationInEffect(String mitigationInEffect) {
            this.mitigationInEffect = mitigationInEffect;
            return this;
        }

        @Override
        public final Builder mitigationInEffect(MitigationInEffectEnum mitigationInEffect) {
            this.mitigationInEffect(mitigationInEffect == null ? null : mitigationInEffect.toString());
            return this;
        }

        @Override
        public AnomalyDetection build() {
            return new AnomalyDetection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
