/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The capacity reservation status for each availability zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ZonalCapacityReservationState implements SdkPojo, Serializable,
        ToCopyableBuilder<ZonalCapacityReservationState.Builder, ZonalCapacityReservationState> {
    private static final SdkField<CapacityReservationStatus> STATE_FIELD = SdkField
            .<CapacityReservationStatus> builder(MarshallingType.SDK_POJO).memberName("State")
            .getter(getter(ZonalCapacityReservationState::state)).setter(setter(Builder::state))
            .constructor(CapacityReservationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(ZonalCapacityReservationState::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<Double> EFFECTIVE_CAPACITY_UNITS_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("EffectiveCapacityUnits").getter(getter(ZonalCapacityReservationState::effectiveCapacityUnits))
            .setter(setter(Builder::effectiveCapacityUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveCapacityUnits").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATE_FIELD,
            AVAILABILITY_ZONE_FIELD, EFFECTIVE_CAPACITY_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CapacityReservationStatus state;

    private final String availabilityZone;

    private final Double effectiveCapacityUnits;

    private ZonalCapacityReservationState(BuilderImpl builder) {
        this.state = builder.state;
        this.availabilityZone = builder.availabilityZone;
        this.effectiveCapacityUnits = builder.effectiveCapacityUnits;
    }

    /**
     * <p>
     * The state of the capacity reservation.
     * </p>
     * 
     * @return The state of the capacity reservation.
     */
    public final CapacityReservationStatus state() {
        return state;
    }

    /**
     * <p>
     * Information about the availability zone.
     * </p>
     * 
     * @return Information about the availability zone.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The number of effective capacity units.
     * </p>
     * 
     * @return The number of effective capacity units.
     */
    public final Double effectiveCapacityUnits() {
        return effectiveCapacityUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveCapacityUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ZonalCapacityReservationState)) {
            return false;
        }
        ZonalCapacityReservationState other = (ZonalCapacityReservationState) obj;
        return Objects.equals(state(), other.state()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(effectiveCapacityUnits(), other.effectiveCapacityUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ZonalCapacityReservationState").add("State", state())
                .add("AvailabilityZone", availabilityZone()).add("EffectiveCapacityUnits", effectiveCapacityUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "EffectiveCapacityUnits":
            return Optional.ofNullable(clazz.cast(effectiveCapacityUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("State", STATE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("EffectiveCapacityUnits", EFFECTIVE_CAPACITY_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ZonalCapacityReservationState, T> g) {
        return obj -> g.apply((ZonalCapacityReservationState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ZonalCapacityReservationState> {
        /**
         * <p>
         * The state of the capacity reservation.
         * </p>
         * 
         * @param state
         *        The state of the capacity reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(CapacityReservationStatus state);

        /**
         * <p>
         * The state of the capacity reservation.
         * </p>
         * This is a convenience method that creates an instance of the {@link CapacityReservationStatus.Builder}
         * avoiding the need to create one manually via {@link CapacityReservationStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityReservationStatus.Builder#build()} is called immediately
         * and its result is passed to {@link #state(CapacityReservationStatus)}.
         * 
         * @param state
         *        a consumer that will call methods on {@link CapacityReservationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #state(CapacityReservationStatus)
         */
        default Builder state(Consumer<CapacityReservationStatus.Builder> state) {
            return state(CapacityReservationStatus.builder().applyMutation(state).build());
        }

        /**
         * <p>
         * Information about the availability zone.
         * </p>
         * 
         * @param availabilityZone
         *        Information about the availability zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The number of effective capacity units.
         * </p>
         * 
         * @param effectiveCapacityUnits
         *        The number of effective capacity units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveCapacityUnits(Double effectiveCapacityUnits);
    }

    static final class BuilderImpl implements Builder {
        private CapacityReservationStatus state;

        private String availabilityZone;

        private Double effectiveCapacityUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(ZonalCapacityReservationState model) {
            state(model.state);
            availabilityZone(model.availabilityZone);
            effectiveCapacityUnits(model.effectiveCapacityUnits);
        }

        public final CapacityReservationStatus.Builder getState() {
            return state != null ? state.toBuilder() : null;
        }

        public final void setState(CapacityReservationStatus.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(CapacityReservationStatus state) {
            this.state = state;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Double getEffectiveCapacityUnits() {
            return effectiveCapacityUnits;
        }

        public final void setEffectiveCapacityUnits(Double effectiveCapacityUnits) {
            this.effectiveCapacityUnits = effectiveCapacityUnits;
        }

        @Override
        public final Builder effectiveCapacityUnits(Double effectiveCapacityUnits) {
            this.effectiveCapacityUnits = effectiveCapacityUnits;
            return this;
        }

        @Override
        public ZonalCapacityReservationState build() {
            return new ZonalCapacityReservationState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
