/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the health of a target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetHealthDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetHealthDescription.Builder, TargetHealthDescription> {
    private static final SdkField<TargetDescription> TARGET_FIELD = SdkField
            .<TargetDescription> builder(MarshallingType.SDK_POJO).memberName("Target")
            .getter(getter(TargetHealthDescription::target)).setter(setter(Builder::target))
            .constructor(TargetDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> HEALTH_CHECK_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckPort").getter(getter(TargetHealthDescription::healthCheckPort))
            .setter(setter(Builder::healthCheckPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckPort").build()).build();

    private static final SdkField<TargetHealth> TARGET_HEALTH_FIELD = SdkField.<TargetHealth> builder(MarshallingType.SDK_POJO)
            .memberName("TargetHealth").getter(getter(TargetHealthDescription::targetHealth))
            .setter(setter(Builder::targetHealth)).constructor(TargetHealth::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetHealth").build()).build();

    private static final SdkField<AnomalyDetection> ANOMALY_DETECTION_FIELD = SdkField
            .<AnomalyDetection> builder(MarshallingType.SDK_POJO).memberName("AnomalyDetection")
            .getter(getter(TargetHealthDescription::anomalyDetection)).setter(setter(Builder::anomalyDetection))
            .constructor(AnomalyDetection::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetection").build()).build();

    private static final SdkField<AdministrativeOverride> ADMINISTRATIVE_OVERRIDE_FIELD = SdkField
            .<AdministrativeOverride> builder(MarshallingType.SDK_POJO).memberName("AdministrativeOverride")
            .getter(getter(TargetHealthDescription::administrativeOverride)).setter(setter(Builder::administrativeOverride))
            .constructor(AdministrativeOverride::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdministrativeOverride").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_FIELD,
            HEALTH_CHECK_PORT_FIELD, TARGET_HEALTH_FIELD, ANOMALY_DETECTION_FIELD, ADMINISTRATIVE_OVERRIDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TargetDescription target;

    private final String healthCheckPort;

    private final TargetHealth targetHealth;

    private final AnomalyDetection anomalyDetection;

    private final AdministrativeOverride administrativeOverride;

    private TargetHealthDescription(BuilderImpl builder) {
        this.target = builder.target;
        this.healthCheckPort = builder.healthCheckPort;
        this.targetHealth = builder.targetHealth;
        this.anomalyDetection = builder.anomalyDetection;
        this.administrativeOverride = builder.administrativeOverride;
    }

    /**
     * <p>
     * The description of the target.
     * </p>
     * 
     * @return The description of the target.
     */
    public final TargetDescription target() {
        return target;
    }

    /**
     * <p>
     * The port to use to connect with the target.
     * </p>
     * 
     * @return The port to use to connect with the target.
     */
    public final String healthCheckPort() {
        return healthCheckPort;
    }

    /**
     * <p>
     * The health information for the target.
     * </p>
     * 
     * @return The health information for the target.
     */
    public final TargetHealth targetHealth() {
        return targetHealth;
    }

    /**
     * <p>
     * The anomaly detection result for the target.
     * </p>
     * <p>
     * If no anomalies were detected, the result is <code>normal</code>.
     * </p>
     * <p>
     * If anomalies were detected, the result is <code>anomalous</code>.
     * </p>
     * 
     * @return The anomaly detection result for the target.</p>
     *         <p>
     *         If no anomalies were detected, the result is <code>normal</code>.
     *         </p>
     *         <p>
     *         If anomalies were detected, the result is <code>anomalous</code>.
     */
    public final AnomalyDetection anomalyDetection() {
        return anomalyDetection;
    }

    /**
     * <p>
     * The administrative override information for the target.
     * </p>
     * 
     * @return The administrative override information for the target.
     */
    public final AdministrativeOverride administrativeOverride() {
        return administrativeOverride;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckPort());
        hashCode = 31 * hashCode + Objects.hashCode(targetHealth());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetection());
        hashCode = 31 * hashCode + Objects.hashCode(administrativeOverride());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetHealthDescription)) {
            return false;
        }
        TargetHealthDescription other = (TargetHealthDescription) obj;
        return Objects.equals(target(), other.target()) && Objects.equals(healthCheckPort(), other.healthCheckPort())
                && Objects.equals(targetHealth(), other.targetHealth())
                && Objects.equals(anomalyDetection(), other.anomalyDetection())
                && Objects.equals(administrativeOverride(), other.administrativeOverride());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetHealthDescription").add("Target", target()).add("HealthCheckPort", healthCheckPort())
                .add("TargetHealth", targetHealth()).add("AnomalyDetection", anomalyDetection())
                .add("AdministrativeOverride", administrativeOverride()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "HealthCheckPort":
            return Optional.ofNullable(clazz.cast(healthCheckPort()));
        case "TargetHealth":
            return Optional.ofNullable(clazz.cast(targetHealth()));
        case "AnomalyDetection":
            return Optional.ofNullable(clazz.cast(anomalyDetection()));
        case "AdministrativeOverride":
            return Optional.ofNullable(clazz.cast(administrativeOverride()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Target", TARGET_FIELD);
        map.put("HealthCheckPort", HEALTH_CHECK_PORT_FIELD);
        map.put("TargetHealth", TARGET_HEALTH_FIELD);
        map.put("AnomalyDetection", ANOMALY_DETECTION_FIELD);
        map.put("AdministrativeOverride", ADMINISTRATIVE_OVERRIDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TargetHealthDescription, T> g) {
        return obj -> g.apply((TargetHealthDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetHealthDescription> {
        /**
         * <p>
         * The description of the target.
         * </p>
         * 
         * @param target
         *        The description of the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(TargetDescription target);

        /**
         * <p>
         * The description of the target.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetDescription.Builder} avoiding the
         * need to create one manually via {@link TargetDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetDescription.Builder#build()} is called immediately and its
         * result is passed to {@link #target(TargetDescription)}.
         * 
         * @param target
         *        a consumer that will call methods on {@link TargetDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #target(TargetDescription)
         */
        default Builder target(Consumer<TargetDescription.Builder> target) {
            return target(TargetDescription.builder().applyMutation(target).build());
        }

        /**
         * <p>
         * The port to use to connect with the target.
         * </p>
         * 
         * @param healthCheckPort
         *        The port to use to connect with the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckPort(String healthCheckPort);

        /**
         * <p>
         * The health information for the target.
         * </p>
         * 
         * @param targetHealth
         *        The health information for the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetHealth(TargetHealth targetHealth);

        /**
         * <p>
         * The health information for the target.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetHealth.Builder} avoiding the need
         * to create one manually via {@link TargetHealth#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetHealth.Builder#build()} is called immediately and its
         * result is passed to {@link #targetHealth(TargetHealth)}.
         * 
         * @param targetHealth
         *        a consumer that will call methods on {@link TargetHealth.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetHealth(TargetHealth)
         */
        default Builder targetHealth(Consumer<TargetHealth.Builder> targetHealth) {
            return targetHealth(TargetHealth.builder().applyMutation(targetHealth).build());
        }

        /**
         * <p>
         * The anomaly detection result for the target.
         * </p>
         * <p>
         * If no anomalies were detected, the result is <code>normal</code>.
         * </p>
         * <p>
         * If anomalies were detected, the result is <code>anomalous</code>.
         * </p>
         * 
         * @param anomalyDetection
         *        The anomaly detection result for the target.</p>
         *        <p>
         *        If no anomalies were detected, the result is <code>normal</code>.
         *        </p>
         *        <p>
         *        If anomalies were detected, the result is <code>anomalous</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetection(AnomalyDetection anomalyDetection);

        /**
         * <p>
         * The anomaly detection result for the target.
         * </p>
         * <p>
         * If no anomalies were detected, the result is <code>normal</code>.
         * </p>
         * <p>
         * If anomalies were detected, the result is <code>anomalous</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnomalyDetection.Builder} avoiding the
         * need to create one manually via {@link AnomalyDetection#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnomalyDetection.Builder#build()} is called immediately and its
         * result is passed to {@link #anomalyDetection(AnomalyDetection)}.
         * 
         * @param anomalyDetection
         *        a consumer that will call methods on {@link AnomalyDetection.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyDetection(AnomalyDetection)
         */
        default Builder anomalyDetection(Consumer<AnomalyDetection.Builder> anomalyDetection) {
            return anomalyDetection(AnomalyDetection.builder().applyMutation(anomalyDetection).build());
        }

        /**
         * <p>
         * The administrative override information for the target.
         * </p>
         * 
         * @param administrativeOverride
         *        The administrative override information for the target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder administrativeOverride(AdministrativeOverride administrativeOverride);

        /**
         * <p>
         * The administrative override information for the target.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdministrativeOverride.Builder} avoiding
         * the need to create one manually via {@link AdministrativeOverride#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdministrativeOverride.Builder#build()} is called immediately and
         * its result is passed to {@link #administrativeOverride(AdministrativeOverride)}.
         * 
         * @param administrativeOverride
         *        a consumer that will call methods on {@link AdministrativeOverride.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #administrativeOverride(AdministrativeOverride)
         */
        default Builder administrativeOverride(Consumer<AdministrativeOverride.Builder> administrativeOverride) {
            return administrativeOverride(AdministrativeOverride.builder().applyMutation(administrativeOverride).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TargetDescription target;

        private String healthCheckPort;

        private TargetHealth targetHealth;

        private AnomalyDetection anomalyDetection;

        private AdministrativeOverride administrativeOverride;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetHealthDescription model) {
            target(model.target);
            healthCheckPort(model.healthCheckPort);
            targetHealth(model.targetHealth);
            anomalyDetection(model.anomalyDetection);
            administrativeOverride(model.administrativeOverride);
        }

        public final TargetDescription.Builder getTarget() {
            return target != null ? target.toBuilder() : null;
        }

        public final void setTarget(TargetDescription.BuilderImpl target) {
            this.target = target != null ? target.build() : null;
        }

        @Override
        public final Builder target(TargetDescription target) {
            this.target = target;
            return this;
        }

        public final String getHealthCheckPort() {
            return healthCheckPort;
        }

        public final void setHealthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
        }

        @Override
        public final Builder healthCheckPort(String healthCheckPort) {
            this.healthCheckPort = healthCheckPort;
            return this;
        }

        public final TargetHealth.Builder getTargetHealth() {
            return targetHealth != null ? targetHealth.toBuilder() : null;
        }

        public final void setTargetHealth(TargetHealth.BuilderImpl targetHealth) {
            this.targetHealth = targetHealth != null ? targetHealth.build() : null;
        }

        @Override
        public final Builder targetHealth(TargetHealth targetHealth) {
            this.targetHealth = targetHealth;
            return this;
        }

        public final AnomalyDetection.Builder getAnomalyDetection() {
            return anomalyDetection != null ? anomalyDetection.toBuilder() : null;
        }

        public final void setAnomalyDetection(AnomalyDetection.BuilderImpl anomalyDetection) {
            this.anomalyDetection = anomalyDetection != null ? anomalyDetection.build() : null;
        }

        @Override
        public final Builder anomalyDetection(AnomalyDetection anomalyDetection) {
            this.anomalyDetection = anomalyDetection;
            return this;
        }

        public final AdministrativeOverride.Builder getAdministrativeOverride() {
            return administrativeOverride != null ? administrativeOverride.toBuilder() : null;
        }

        public final void setAdministrativeOverride(AdministrativeOverride.BuilderImpl administrativeOverride) {
            this.administrativeOverride = administrativeOverride != null ? administrativeOverride.build() : null;
        }

        @Override
        public final Builder administrativeOverride(AdministrativeOverride administrativeOverride) {
            this.administrativeOverride = administrativeOverride;
            return this;
        }

        @Override
        public TargetHealthDescription build() {
            return new TargetHealthDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
