/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCapacityReservationResponse extends ElasticLoadBalancingV2Response implements
        ToCopyableBuilder<DescribeCapacityReservationResponse.Builder, DescribeCapacityReservationResponse> {
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeCapacityReservationResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<Integer> DECREASE_REQUESTS_REMAINING_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("DecreaseRequestsRemaining")
            .getter(getter(DescribeCapacityReservationResponse::decreaseRequestsRemaining))
            .setter(setter(Builder::decreaseRequestsRemaining))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DecreaseRequestsRemaining").build())
            .build();

    private static final SdkField<MinimumLoadBalancerCapacity> MINIMUM_LOAD_BALANCER_CAPACITY_FIELD = SdkField
            .<MinimumLoadBalancerCapacity> builder(MarshallingType.SDK_POJO)
            .memberName("MinimumLoadBalancerCapacity")
            .getter(getter(DescribeCapacityReservationResponse::minimumLoadBalancerCapacity))
            .setter(setter(Builder::minimumLoadBalancerCapacity))
            .constructor(MinimumLoadBalancerCapacity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumLoadBalancerCapacity")
                    .build()).build();

    private static final SdkField<List<ZonalCapacityReservationState>> CAPACITY_RESERVATION_STATE_FIELD = SdkField
            .<List<ZonalCapacityReservationState>> builder(MarshallingType.LIST)
            .memberName("CapacityReservationState")
            .getter(getter(DescribeCapacityReservationResponse::capacityReservationState))
            .setter(setter(Builder::capacityReservationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationState").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ZonalCapacityReservationState> builder(MarshallingType.SDK_POJO)
                                            .constructor(ZonalCapacityReservationState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_MODIFIED_TIME_FIELD,
            DECREASE_REQUESTS_REMAINING_FIELD, MINIMUM_LOAD_BALANCER_CAPACITY_FIELD, CAPACITY_RESERVATION_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant lastModifiedTime;

    private final Integer decreaseRequestsRemaining;

    private final MinimumLoadBalancerCapacity minimumLoadBalancerCapacity;

    private final List<ZonalCapacityReservationState> capacityReservationState;

    private DescribeCapacityReservationResponse(BuilderImpl builder) {
        super(builder);
        this.lastModifiedTime = builder.lastModifiedTime;
        this.decreaseRequestsRemaining = builder.decreaseRequestsRemaining;
        this.minimumLoadBalancerCapacity = builder.minimumLoadBalancerCapacity;
        this.capacityReservationState = builder.capacityReservationState;
    }

    /**
     * <p>
     * The last time the capacity reservation was modified.
     * </p>
     * 
     * @return The last time the capacity reservation was modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The amount of daily capacity decreases remaining.
     * </p>
     * 
     * @return The amount of daily capacity decreases remaining.
     */
    public final Integer decreaseRequestsRemaining() {
        return decreaseRequestsRemaining;
    }

    /**
     * <p>
     * The requested minimum capacity reservation for the load balancer
     * </p>
     * 
     * @return The requested minimum capacity reservation for the load balancer
     */
    public final MinimumLoadBalancerCapacity minimumLoadBalancerCapacity() {
        return minimumLoadBalancerCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityReservationState property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCapacityReservationState() {
        return capacityReservationState != null && !(capacityReservationState instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The state of the capacity reservation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityReservationState} method.
     * </p>
     * 
     * @return The state of the capacity reservation.
     */
    public final List<ZonalCapacityReservationState> capacityReservationState() {
        return capacityReservationState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(decreaseRequestsRemaining());
        hashCode = 31 * hashCode + Objects.hashCode(minimumLoadBalancerCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityReservationState() ? capacityReservationState() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityReservationResponse)) {
            return false;
        }
        DescribeCapacityReservationResponse other = (DescribeCapacityReservationResponse) obj;
        return Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(decreaseRequestsRemaining(), other.decreaseRequestsRemaining())
                && Objects.equals(minimumLoadBalancerCapacity(), other.minimumLoadBalancerCapacity())
                && hasCapacityReservationState() == other.hasCapacityReservationState()
                && Objects.equals(capacityReservationState(), other.capacityReservationState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCapacityReservationResponse").add("LastModifiedTime", lastModifiedTime())
                .add("DecreaseRequestsRemaining", decreaseRequestsRemaining())
                .add("MinimumLoadBalancerCapacity", minimumLoadBalancerCapacity())
                .add("CapacityReservationState", hasCapacityReservationState() ? capacityReservationState() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "DecreaseRequestsRemaining":
            return Optional.ofNullable(clazz.cast(decreaseRequestsRemaining()));
        case "MinimumLoadBalancerCapacity":
            return Optional.ofNullable(clazz.cast(minimumLoadBalancerCapacity()));
        case "CapacityReservationState":
            return Optional.ofNullable(clazz.cast(capacityReservationState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("DecreaseRequestsRemaining", DECREASE_REQUESTS_REMAINING_FIELD);
        map.put("MinimumLoadBalancerCapacity", MINIMUM_LOAD_BALANCER_CAPACITY_FIELD);
        map.put("CapacityReservationState", CAPACITY_RESERVATION_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityReservationResponse, T> g) {
        return obj -> g.apply((DescribeCapacityReservationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCapacityReservationResponse> {
        /**
         * <p>
         * The last time the capacity reservation was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time the capacity reservation was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The amount of daily capacity decreases remaining.
         * </p>
         * 
         * @param decreaseRequestsRemaining
         *        The amount of daily capacity decreases remaining.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder decreaseRequestsRemaining(Integer decreaseRequestsRemaining);

        /**
         * <p>
         * The requested minimum capacity reservation for the load balancer
         * </p>
         * 
         * @param minimumLoadBalancerCapacity
         *        The requested minimum capacity reservation for the load balancer
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity minimumLoadBalancerCapacity);

        /**
         * <p>
         * The requested minimum capacity reservation for the load balancer
         * </p>
         * This is a convenience method that creates an instance of the {@link MinimumLoadBalancerCapacity.Builder}
         * avoiding the need to create one manually via {@link MinimumLoadBalancerCapacity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MinimumLoadBalancerCapacity.Builder#build()} is called
         * immediately and its result is passed to {@link #minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity)}.
         * 
         * @param minimumLoadBalancerCapacity
         *        a consumer that will call methods on {@link MinimumLoadBalancerCapacity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity)
         */
        default Builder minimumLoadBalancerCapacity(Consumer<MinimumLoadBalancerCapacity.Builder> minimumLoadBalancerCapacity) {
            return minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity.builder().applyMutation(minimumLoadBalancerCapacity)
                    .build());
        }

        /**
         * <p>
         * The state of the capacity reservation.
         * </p>
         * 
         * @param capacityReservationState
         *        The state of the capacity reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationState(Collection<ZonalCapacityReservationState> capacityReservationState);

        /**
         * <p>
         * The state of the capacity reservation.
         * </p>
         * 
         * @param capacityReservationState
         *        The state of the capacity reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationState(ZonalCapacityReservationState... capacityReservationState);

        /**
         * <p>
         * The state of the capacity reservation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ZonalCapacityReservationState.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ZonalCapacityReservationState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ZonalCapacityReservationState.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #capacityReservationState(List<ZonalCapacityReservationState>)}.
         * 
         * @param capacityReservationState
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.elasticloadbalancingv2.model.ZonalCapacityReservationState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationState(java.util.Collection<ZonalCapacityReservationState>)
         */
        Builder capacityReservationState(Consumer<ZonalCapacityReservationState.Builder>... capacityReservationState);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Response.BuilderImpl implements Builder {
        private Instant lastModifiedTime;

        private Integer decreaseRequestsRemaining;

        private MinimumLoadBalancerCapacity minimumLoadBalancerCapacity;

        private List<ZonalCapacityReservationState> capacityReservationState = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityReservationResponse model) {
            super(model);
            lastModifiedTime(model.lastModifiedTime);
            decreaseRequestsRemaining(model.decreaseRequestsRemaining);
            minimumLoadBalancerCapacity(model.minimumLoadBalancerCapacity);
            capacityReservationState(model.capacityReservationState);
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Integer getDecreaseRequestsRemaining() {
            return decreaseRequestsRemaining;
        }

        public final void setDecreaseRequestsRemaining(Integer decreaseRequestsRemaining) {
            this.decreaseRequestsRemaining = decreaseRequestsRemaining;
        }

        @Override
        public final Builder decreaseRequestsRemaining(Integer decreaseRequestsRemaining) {
            this.decreaseRequestsRemaining = decreaseRequestsRemaining;
            return this;
        }

        public final MinimumLoadBalancerCapacity.Builder getMinimumLoadBalancerCapacity() {
            return minimumLoadBalancerCapacity != null ? minimumLoadBalancerCapacity.toBuilder() : null;
        }

        public final void setMinimumLoadBalancerCapacity(MinimumLoadBalancerCapacity.BuilderImpl minimumLoadBalancerCapacity) {
            this.minimumLoadBalancerCapacity = minimumLoadBalancerCapacity != null ? minimumLoadBalancerCapacity.build() : null;
        }

        @Override
        public final Builder minimumLoadBalancerCapacity(MinimumLoadBalancerCapacity minimumLoadBalancerCapacity) {
            this.minimumLoadBalancerCapacity = minimumLoadBalancerCapacity;
            return this;
        }

        public final List<ZonalCapacityReservationState.Builder> getCapacityReservationState() {
            List<ZonalCapacityReservationState.Builder> result = ZonalCapacityReservationStatesCopier
                    .copyToBuilder(this.capacityReservationState);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityReservationState(
                Collection<ZonalCapacityReservationState.BuilderImpl> capacityReservationState) {
            this.capacityReservationState = ZonalCapacityReservationStatesCopier.copyFromBuilder(capacityReservationState);
        }

        @Override
        public final Builder capacityReservationState(Collection<ZonalCapacityReservationState> capacityReservationState) {
            this.capacityReservationState = ZonalCapacityReservationStatesCopier.copy(capacityReservationState);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationState(ZonalCapacityReservationState... capacityReservationState) {
            capacityReservationState(Arrays.asList(capacityReservationState));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationState(Consumer<ZonalCapacityReservationState.Builder>... capacityReservationState) {
            capacityReservationState(Stream.of(capacityReservationState)
                    .map(c -> ZonalCapacityReservationState.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCapacityReservationResponse build() {
            return new DescribeCapacityReservationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
