/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.elasticloadbalancingv2.internal.ElasticLoadBalancingV2ServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTrustStoreRevocationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTrustStoreRevocationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AllocationIdNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AlpnPolicyNotSupportedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZoneNotSupportedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CaCertificatesBundleNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CapacityDecreaseRequestsLimitExceededException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CapacityReservationPendingException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CapacityUnitsLimitExceededException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTrustStoreRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTrustStoreResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteAssociationSameAccountException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteSharedTrustStoreAssociationRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteSharedTrustStoreAssociationResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTrustStoreRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTrustStoreResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeCapacityReservationRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeCapacityReservationResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreAssociationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoreRevocationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTrustStoresResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateListenerException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateLoadBalancerNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTargetGroupNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTrustStoreNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreCaCertificatesBundleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreCaCertificatesBundleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreRevocationContentRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.GetTrustStoreRevocationContentResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HealthUnavailableException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IncompatibleProtocolsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InsufficientCapacityException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidCaCertificatesBundleException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidConfigurationRequestException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidLoadBalancerActionException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidRevocationContentException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSchemeException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSecurityGroupException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidTargetException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyCapacityReservationRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyCapacityReservationResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyIpPoolsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyIpPoolsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTrustStoreRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTrustStoreResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.OperationNotPermittedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.PriorRequestNotCompleteException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.PriorityInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTrustStoreRevocationsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTrustStoreRevocationsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ResourceInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ResourceNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationContentNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationIdNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicyNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAssociationLimitException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyActionsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyCertificatesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyListenersException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyLoadBalancersException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyRegistrationsForTargetIdException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyRulesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTargetGroupsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTargetsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTrustStoreRevocationEntriesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTrustStoresException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyUniqueTargetGroupsPerLoadBalancerException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreAssociationNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TrustStoreNotReadyException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.UnsupportedProtocolException;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AddListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AddTrustStoreRevocationsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteSharedTrustStoreAssociationRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeregisterTargetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeListenerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeRulesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeSslPoliciesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetGroupAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTrustStoreAssociationsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTrustStoreRevocationsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTrustStoresRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.GetTrustStoreCaCertificatesBundleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.GetTrustStoreRevocationContentRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyCapacityReservationRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyIpPoolsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyListenerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyTargetGroupAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RegisterTargetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RemoveListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RemoveTrustStoreRevocationsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetIpAddressTypeRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetRulePrioritiesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.ElasticLoadBalancingV2Waiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link ElasticLoadBalancingV2Client}.
 *
 * @see ElasticLoadBalancingV2Client#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultElasticLoadBalancingV2Client implements ElasticLoadBalancingV2Client {
    private static final Logger log = Logger.loggerFor(DefaultElasticLoadBalancingV2Client.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.QUERY).build();

    private final SyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticLoadBalancingV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init();
    }

    /**
     * <p>
     * Adds the specified SSL server certificate to the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the certificate in already in the certificate list, the call is successful but the certificate is not added
     * again.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html">HTTPS
     * listeners</a> in the <i>Application Load Balancers Guide</i> or <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html">TLS listeners</a>
     * in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param addListenerCertificatesRequest
     * @return Result of the AddListenerCertificates operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws TooManyCertificatesException
     *         You've reached the limit on the number of certificates per load balancer.
     * @throws CertificateNotFoundException
     *         The specified certificate does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.AddListenerCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddListenerCertificatesResponse addListenerCertificates(AddListenerCertificatesRequest addListenerCertificatesRequest)
            throws ListenerNotFoundException, TooManyCertificatesException, CertificateNotFoundException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<AddListenerCertificatesResponse> responseHandler = protocolFactory
                .createResponseHandler(AddListenerCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addListenerCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addListenerCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddListenerCertificates");

            return clientHandler
                    .execute(new ClientExecutionParams<AddListenerCertificatesRequest, AddListenerCertificatesResponse>()
                            .withOperationName("AddListenerCertificates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(addListenerCertificatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddListenerCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified tags to the specified Elastic Load Balancing resource. You can tag your Application Load
     * Balancers, Network Load Balancers, Gateway Load Balancers, target groups, trust stores, listeners, and rules.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key,
     * <code>AddTags</code> updates its value.
     * </p>
     *
     * @param addTagsRequest
     * @return Result of the AddTags operation returned by the service.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags for this resource.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.AddTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws DuplicateTagKeysException, TooManyTagsException,
            LoadBalancerNotFoundException, TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException,
            TrustStoreNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<AddTagsResponse> responseHandler = protocolFactory.createResponseHandler(AddTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTags");

            return clientHandler.execute(new ClientExecutionParams<AddTagsRequest, AddTagsResponse>()
                    .withOperationName("AddTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(addTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified revocation file to the specified trust store.
     * </p>
     *
     * @param addTrustStoreRevocationsRequest
     * @return Result of the AddTrustStoreRevocations operation returned by the service.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws InvalidRevocationContentException
     *         The provided revocation file is an invalid format, or uses an incorrect algorithm.
     * @throws TooManyTrustStoreRevocationEntriesException
     *         The specified trust store has too many revocation entries.
     * @throws RevocationContentNotFoundException
     *         The specified revocation file does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.AddTrustStoreRevocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/AddTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddTrustStoreRevocationsResponse addTrustStoreRevocations(
            AddTrustStoreRevocationsRequest addTrustStoreRevocationsRequest) throws TrustStoreNotFoundException,
            InvalidRevocationContentException, TooManyTrustStoreRevocationEntriesException, RevocationContentNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<AddTrustStoreRevocationsResponse> responseHandler = protocolFactory
                .createResponseHandler(AddTrustStoreRevocationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTrustStoreRevocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTrustStoreRevocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTrustStoreRevocations");

            return clientHandler
                    .execute(new ClientExecutionParams<AddTrustStoreRevocationsRequest, AddTrustStoreRevocationsResponse>()
                            .withOperationName("AddTrustStoreRevocations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(addTrustStoreRevocationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddTrustStoreRevocationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a listener for the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html">
     * Listeners for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-listeners.html">Listeners
     * for your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-listeners.html">Listeners for
     * your Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * listeners with the same settings, each call succeeds.
     * </p>
     *
     * @param createListenerRequest
     * @return Result of the CreateListener operation returned by the service.
     * @throws DuplicateListenerException
     *         A listener with the specified port already exists.
     * @throws TooManyListenersException
     *         You've reached the limit on the number of listeners per load balancer.
     * @throws TooManyCertificatesException
     *         You've reached the limit on the number of certificates per load balancer.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws TargetGroupAssociationLimitException
     *         You've reached the limit on the number of load balancers per target group.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws IncompatibleProtocolsException
     *         The specified configuration is not valid with this protocol.
     * @throws SslPolicyNotFoundException
     *         The specified SSL policy does not exist.
     * @throws CertificateNotFoundException
     *         The specified certificate does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws TooManyActionsException
     *         You've reached the limit on the number of actions per rule.
     * @throws InvalidLoadBalancerActionException
     *         The requested action is not valid.
     * @throws TooManyUniqueTargetGroupsPerLoadBalancerException
     *         You've reached the limit on the number of unique target groups per load balancer across all listeners. If
     *         a target group is used by multiple actions for a load balancer, it is counted as only one use.
     * @throws AlpnPolicyNotSupportedException
     *         The specified ALPN policy is not supported.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags for this resource.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws TrustStoreNotReadyException
     *         The specified trust store is not active.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateListenerResponse createListener(CreateListenerRequest createListenerRequest) throws DuplicateListenerException,
            TooManyListenersException, TooManyCertificatesException, LoadBalancerNotFoundException, TargetGroupNotFoundException,
            TargetGroupAssociationLimitException, InvalidConfigurationRequestException, IncompatibleProtocolsException,
            SslPolicyNotFoundException, CertificateNotFoundException, UnsupportedProtocolException,
            TooManyRegistrationsForTargetIdException, TooManyTargetsException, TooManyActionsException,
            InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException,
            AlpnPolicyNotSupportedException, TooManyTagsException, TrustStoreNotFoundException, TrustStoreNotReadyException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<CreateListenerResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateListenerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateListener");

            return clientHandler.execute(new ClientExecutionParams<CreateListenerRequest, CreateListenerResponse>()
                    .withOperationName("CreateListener").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createListenerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateListenerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Application Load Balancer, Network Load Balancer, or Gateway Load Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html">
     * Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html">Network
     * Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html">Gateway
     * Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * load balancers with the same settings, each call succeeds.
     * </p>
     *
     * @param createLoadBalancerRequest
     * @return Result of the CreateLoadBalancer operation returned by the service.
     * @throws DuplicateLoadBalancerNameException
     *         A load balancer with the specified name already exists.
     * @throws TooManyLoadBalancersException
     *         You've reached the limit on the number of load balancers for your Amazon Web Services account.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SubnetNotFoundException
     *         The specified subnet does not exist.
     * @throws InvalidSubnetException
     *         The specified subnet is out of available addresses.
     * @throws InvalidSecurityGroupException
     *         The specified security group does not exist.
     * @throws InvalidSchemeException
     *         The requested scheme is not valid.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags for this resource.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws ResourceInUseException
     *         A specified resource is in use.
     * @throws AllocationIdNotFoundException
     *         The specified allocation ID does not exist.
     * @throws AvailabilityZoneNotSupportedException
     *         The specified Availability Zone is not supported.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateLoadBalancer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateLoadBalancerResponse createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest)
            throws DuplicateLoadBalancerNameException, TooManyLoadBalancersException, InvalidConfigurationRequestException,
            SubnetNotFoundException, InvalidSubnetException, InvalidSecurityGroupException, InvalidSchemeException,
            TooManyTagsException, DuplicateTagKeysException, ResourceInUseException, AllocationIdNotFoundException,
            AvailabilityZoneNotSupportedException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {

        HttpResponseHandler<CreateLoadBalancerResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateLoadBalancerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLoadBalancerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLoadBalancerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLoadBalancer");

            return clientHandler.execute(new ClientExecutionParams<CreateLoadBalancerRequest, CreateLoadBalancerResponse>()
                    .withOperationName("CreateLoadBalancer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createLoadBalancerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateLoadBalancerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a rule for the specified listener. The listener must be associated with an Application Load Balancer.
     * </p>
     * <p>
     * Each rule consists of a priority, one or more actions, and one or more conditions. Rules are evaluated in
     * priority order, from the lowest value to the highest value. When the conditions for a rule are met, its actions
     * are performed. If the conditions for no rules are met, the actions for the default rule are performed. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-listeners.html#listener-rules"
     * >Listener rules</a> in the <i>Application Load Balancers Guide</i>.
     * </p>
     *
     * @param createRuleRequest
     * @return Result of the CreateRule operation returned by the service.
     * @throws PriorityInUseException
     *         The specified priority is in use.
     * @throws TooManyTargetGroupsException
     *         You've reached the limit on the number of target groups for your Amazon Web Services account.
     * @throws TooManyRulesException
     *         You've reached the limit on the number of rules per load balancer.
     * @throws TargetGroupAssociationLimitException
     *         You've reached the limit on the number of load balancers per target group.
     * @throws IncompatibleProtocolsException
     *         The specified configuration is not valid with this protocol.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws TooManyActionsException
     *         You've reached the limit on the number of actions per rule.
     * @throws InvalidLoadBalancerActionException
     *         The requested action is not valid.
     * @throws TooManyUniqueTargetGroupsPerLoadBalancerException
     *         You've reached the limit on the number of unique target groups per load balancer across all listeners. If
     *         a target group is used by multiple actions for a load balancer, it is counted as only one use.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags for this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws PriorityInUseException,
            TooManyTargetGroupsException, TooManyRulesException, TargetGroupAssociationLimitException,
            IncompatibleProtocolsException, ListenerNotFoundException, TargetGroupNotFoundException,
            InvalidConfigurationRequestException, TooManyRegistrationsForTargetIdException, TooManyTargetsException,
            UnsupportedProtocolException, TooManyActionsException, InvalidLoadBalancerActionException,
            TooManyUniqueTargetGroupsPerLoadBalancerException, TooManyTagsException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {

        HttpResponseHandler<CreateRuleResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRule");

            return clientHandler.execute(new ClientExecutionParams<CreateRuleRequest, CreateRuleResponse>()
                    .withOperationName("CreateRule").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createRuleRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html">
     * Target groups for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html">Target
     * groups for your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html">Target groups for
     * your Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation is idempotent, which means that it completes at most one time. If you attempt to create multiple
     * target groups with the same settings, each call succeeds.
     * </p>
     *
     * @param createTargetGroupRequest
     * @return Result of the CreateTargetGroup operation returned by the service.
     * @throws DuplicateTargetGroupNameException
     *         A target group with the specified name already exists.
     * @throws TooManyTargetGroupsException
     *         You've reached the limit on the number of target groups for your Amazon Web Services account.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags for this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTargetGroupResponse createTargetGroup(CreateTargetGroupRequest createTargetGroupRequest)
            throws DuplicateTargetGroupNameException, TooManyTargetGroupsException, InvalidConfigurationRequestException,
            TooManyTagsException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<CreateTargetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTargetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTargetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTargetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTargetGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateTargetGroupRequest, CreateTargetGroupResponse>()
                    .withOperationName("CreateTargetGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTargetGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTargetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a trust store.
     * </p>
     *
     * @param createTrustStoreRequest
     * @return Result of the CreateTrustStore operation returned by the service.
     * @throws DuplicateTrustStoreNameException
     *         A trust store with the specified name already exists.
     * @throws TooManyTrustStoresException
     *         You've reached the limit on the number of trust stores for your Amazon Web Services account.
     * @throws InvalidCaCertificatesBundleException
     *         The specified ca certificate bundle is in an invalid format, or corrupt.
     * @throws CaCertificatesBundleNotFoundException
     *         The specified ca certificate bundle does not exist.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags for this resource.
     * @throws DuplicateTagKeysException
     *         A tag key was specified more than once.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.CreateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/CreateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTrustStoreResponse createTrustStore(CreateTrustStoreRequest createTrustStoreRequest)
            throws DuplicateTrustStoreNameException, TooManyTrustStoresException, InvalidCaCertificatesBundleException,
            CaCertificatesBundleNotFoundException, TooManyTagsException, DuplicateTagKeysException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<CreateTrustStoreResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrustStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrustStore");

            return clientHandler.execute(new ClientExecutionParams<CreateTrustStoreRequest, CreateTrustStoreResponse>()
                    .withOperationName("CreateTrustStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified listener.
     * </p>
     * <p>
     * Alternatively, your listener is deleted when you delete the load balancer to which it is attached.
     * </p>
     *
     * @param deleteListenerRequest
     * @return Result of the DeleteListener operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws ResourceInUseException
     *         A specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteListenerResponse deleteListener(DeleteListenerRequest deleteListenerRequest) throws ListenerNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DeleteListenerResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteListenerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteListener");

            return clientHandler.execute(new ClientExecutionParams<DeleteListenerRequest, DeleteListenerResponse>()
                    .withOperationName("DeleteListener").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteListenerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteListenerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified Application Load Balancer, Network Load Balancer, or Gateway Load Balancer. Deleting a load
     * balancer also deletes its listeners.
     * </p>
     * <p>
     * You can't delete a load balancer if deletion protection is enabled. If the load balancer does not exist or has
     * already been deleted, the call succeeds.
     * </p>
     * <p>
     * Deleting a load balancer does not affect its registered targets. For example, your EC2 instances continue to run
     * and are still registered to their target groups. If you no longer need these EC2 instances, you can stop or
     * terminate them.
     * </p>
     *
     * @param deleteLoadBalancerRequest
     * @return Result of the DeleteLoadBalancer operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws ResourceInUseException
     *         A specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteLoadBalancer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteLoadBalancer"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLoadBalancerResponse deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest)
            throws LoadBalancerNotFoundException, OperationNotPermittedException, ResourceInUseException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DeleteLoadBalancerResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteLoadBalancerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLoadBalancerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLoadBalancerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLoadBalancer");

            return clientHandler.execute(new ClientExecutionParams<DeleteLoadBalancerRequest, DeleteLoadBalancerResponse>()
                    .withOperationName("DeleteLoadBalancer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteLoadBalancerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteLoadBalancerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified rule.
     * </p>
     * <p>
     * You can't delete the default rule.
     * </p>
     *
     * @param deleteRuleRequest
     * @return Result of the DeleteRule operation returned by the service.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws RuleNotFoundException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DeleteRuleResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRule");

            return clientHandler.execute(new ClientExecutionParams<DeleteRuleRequest, DeleteRuleResponse>()
                    .withOperationName("DeleteRule").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteRuleRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a shared trust store association.
     * </p>
     *
     * @param deleteSharedTrustStoreAssociationRequest
     * @return Result of the DeleteSharedTrustStoreAssociation operation returned by the service.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws DeleteAssociationSameAccountException
     *         The specified association can't be within the same account.
     * @throws TrustStoreAssociationNotFoundException
     *         The specified association does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteSharedTrustStoreAssociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteSharedTrustStoreAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSharedTrustStoreAssociationResponse deleteSharedTrustStoreAssociation(
            DeleteSharedTrustStoreAssociationRequest deleteSharedTrustStoreAssociationRequest)
            throws TrustStoreNotFoundException, DeleteAssociationSameAccountException, TrustStoreAssociationNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DeleteSharedTrustStoreAssociationResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteSharedTrustStoreAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSharedTrustStoreAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteSharedTrustStoreAssociationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSharedTrustStoreAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteSharedTrustStoreAssociationRequest, DeleteSharedTrustStoreAssociationResponse>()
                            .withOperationName("DeleteSharedTrustStoreAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteSharedTrustStoreAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteSharedTrustStoreAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified target group.
     * </p>
     * <p>
     * You can delete a target group if it is not referenced by any actions. Deleting a target group also deletes any
     * associated health checks. Deleting a target group does not affect its registered targets. For example, any EC2
     * instances continue to run until you stop or terminate them.
     * </p>
     *
     * @param deleteTargetGroupRequest
     * @return Result of the DeleteTargetGroup operation returned by the service.
     * @throws ResourceInUseException
     *         A specified resource is in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTargetGroupResponse deleteTargetGroup(DeleteTargetGroupRequest deleteTargetGroupRequest)
            throws ResourceInUseException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DeleteTargetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTargetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTargetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTargetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTargetGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteTargetGroupRequest, DeleteTargetGroupResponse>()
                    .withOperationName("DeleteTargetGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteTargetGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTargetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a trust store.
     * </p>
     *
     * @param deleteTrustStoreRequest
     * @return Result of the DeleteTrustStore operation returned by the service.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws TrustStoreInUseException
     *         The specified trust store is currently in use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeleteTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeleteTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTrustStoreResponse deleteTrustStore(DeleteTrustStoreRequest deleteTrustStoreRequest)
            throws TrustStoreNotFoundException, TrustStoreInUseException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DeleteTrustStoreResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrustStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrustStore");

            return clientHandler.execute(new ClientExecutionParams<DeleteTrustStoreRequest, DeleteTrustStoreResponse>()
                    .withOperationName("DeleteTrustStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deregisters the specified targets from the specified target group. After the targets are deregistered, they no
     * longer receive traffic from the load balancer.
     * </p>
     * <p>
     * The load balancer stops sending requests to targets that are deregistering, but uses connection draining to
     * ensure that in-flight traffic completes on the existing connections. This deregistration delay is configured by
     * default but can be updated for each target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Application Load Balancers User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#deregistration-delay"
     * > Deregistration delay</a> in the <i>Network Load Balancers User Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a
     * href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#deregistration-delay">
     * Deregistration delay</a> in the <i>Gateway Load Balancers User Guide</i>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note: If the specified target does not exist, the action returns successfully.
     * </p>
     *
     * @param deregisterTargetsRequest
     * @return Result of the DeregisterTargets operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws InvalidTargetException
     *         The specified target does not exist, is not in the same VPC as the target group, or has an unsupported
     *         instance type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DeregisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeregisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterTargetsResponse deregisterTargets(DeregisterTargetsRequest deregisterTargetsRequest)
            throws TargetGroupNotFoundException, InvalidTargetException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DeregisterTargetsResponse> responseHandler = protocolFactory
                .createResponseHandler(DeregisterTargetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterTargets");

            return clientHandler.execute(new ClientExecutionParams<DeregisterTargetsRequest, DeregisterTargetsResponse>()
                    .withOperationName("DeregisterTargets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deregisterTargetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeregisterTargetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the current Elastic Load Balancing resource limits for your Amazon Web Services account.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-limits.html">Quotas
     * for your Application Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-limits.html">Quotas for
     * your Network Load Balancers</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/quotas-limits.html">Quotas for your
     * Gateway Load Balancers</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountLimitsRequest
     * @return Result of the DescribeAccountLimits operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeAccountLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeAccountLimits"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest)
            throws AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeAccountLimitsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeAccountLimitsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountLimits");

            return clientHandler.execute(new ClientExecutionParams<DescribeAccountLimitsRequest, DescribeAccountLimitsResponse>()
                    .withOperationName("DescribeAccountLimits").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAccountLimitsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAccountLimitsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the capacity reservation status for the specified load balancer.
     * </p>
     *
     * @param describeCapacityReservationRequest
     * @return Result of the DescribeCapacityReservation operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeCapacityReservation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeCapacityReservationResponse describeCapacityReservation(
            DescribeCapacityReservationRequest describeCapacityReservationRequest) throws LoadBalancerNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeCapacityReservationResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeCapacityReservationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCapacityReservation");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCapacityReservationRequest, DescribeCapacityReservationResponse>()
                            .withOperationName("DescribeCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeCapacityReservationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCapacityReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the attributes for the specified listener.
     * </p>
     *
     * @param describeListenerAttributesRequest
     * @return Result of the DescribeListenerAttributes operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeListenerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeListenerAttributesResponse describeListenerAttributes(
            DescribeListenerAttributesRequest describeListenerAttributesRequest) throws ListenerNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeListenerAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeListenerAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeListenerAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeListenerAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeListenerAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeListenerAttributesRequest, DescribeListenerAttributesResponse>()
                            .withOperationName("DescribeListenerAttributes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeListenerAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeListenerAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the default certificate and the certificate list for the specified HTTPS or TLS listener.
     * </p>
     * <p>
     * If the default certificate is also in the certificate list, it appears twice in the results (once with
     * <code>IsDefault</code> set to true and once with <code>IsDefault</code> set to false).
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#https-listener-certificates"
     * >SSL certificates</a> in the <i>Application Load Balancers Guide</i> or <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#tls-listener-certificate"
     * >Server certificates</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param describeListenerCertificatesRequest
     * @return Result of the DescribeListenerCertificates operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeListenerCertificatesResponse describeListenerCertificates(
            DescribeListenerCertificatesRequest describeListenerCertificatesRequest) throws ListenerNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeListenerCertificatesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeListenerCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeListenerCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeListenerCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeListenerCertificates");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeListenerCertificatesRequest, DescribeListenerCertificatesResponse>()
                            .withOperationName("DescribeListenerCertificates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeListenerCertificatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeListenerCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified listeners or the listeners for the specified Application Load Balancer, Network Load
     * Balancer, or Gateway Load Balancer. You must specify either a load balancer or one or more listeners.
     * </p>
     *
     * @param describeListenersRequest
     * @return Result of the DescribeListeners operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeListeners
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeListeners"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeListenersResponse describeListeners(DescribeListenersRequest describeListenersRequest)
            throws ListenerNotFoundException, LoadBalancerNotFoundException, UnsupportedProtocolException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeListenersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeListenersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeListenersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeListenersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeListeners");

            return clientHandler.execute(new ClientExecutionParams<DescribeListenersRequest, DescribeListenersResponse>()
                    .withOperationName("DescribeListeners").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeListenersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeListenersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the attributes for the specified Application Load Balancer, Network Load Balancer, or Gateway Load
     * Balancer.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/application-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Application Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/network-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Network Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/gateway-load-balancers.html#load-balancer-attributes"
     * >Load balancer attributes</a> in the <i>Gateway Load Balancers Guide</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeLoadBalancerAttributesRequest
     * @return Result of the DescribeLoadBalancerAttributes operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeLoadBalancerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeLoadBalancerAttributesResponse describeLoadBalancerAttributes(
            DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) throws LoadBalancerNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeLoadBalancerAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeLoadBalancerAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLoadBalancerAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeLoadBalancerAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLoadBalancerAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeLoadBalancerAttributesRequest, DescribeLoadBalancerAttributesResponse>()
                            .withOperationName("DescribeLoadBalancerAttributes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeLoadBalancerAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeLoadBalancerAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified load balancers or all of your load balancers.
     * </p>
     *
     * @param describeLoadBalancersRequest
     * @return Result of the DescribeLoadBalancers operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeLoadBalancers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeLoadBalancers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeLoadBalancersResponse describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest)
            throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeLoadBalancersResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeLoadBalancersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLoadBalancersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLoadBalancersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLoadBalancers");

            return clientHandler.execute(new ClientExecutionParams<DescribeLoadBalancersRequest, DescribeLoadBalancersResponse>()
                    .withOperationName("DescribeLoadBalancers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeLoadBalancersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeLoadBalancersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified rules or the rules for the specified listener. You must specify either a listener or one
     * or more rules.
     * </p>
     *
     * @param describeRulesRequest
     * @return Result of the DescribeRules operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeRules"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeRulesResponse describeRules(DescribeRulesRequest describeRulesRequest) throws ListenerNotFoundException,
            RuleNotFoundException, UnsupportedProtocolException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeRulesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRules");

            return clientHandler.execute(new ClientExecutionParams<DescribeRulesRequest, DescribeRulesResponse>()
                    .withOperationName("DescribeRules").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeRulesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified policies or all policies used for SSL negotiation.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies"
     * >Security policies</a> in the <i>Application Load Balancers Guide</i> or <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/create-tls-listener.html#describe-ssl-policies"
     * >Security policies</a> in the <i>Network Load Balancers Guide</i>.
     * </p>
     *
     * @param describeSslPoliciesRequest
     * @return Result of the DescribeSSLPolicies operation returned by the service.
     * @throws SslPolicyNotFoundException
     *         The specified SSL policy does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeSSLPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeSSLPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeSslPoliciesResponse describeSSLPolicies(DescribeSslPoliciesRequest describeSslPoliciesRequest)
            throws SslPolicyNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeSslPoliciesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeSslPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSslPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSslPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSSLPolicies");

            return clientHandler.execute(new ClientExecutionParams<DescribeSslPoliciesRequest, DescribeSslPoliciesResponse>()
                    .withOperationName("DescribeSSLPolicies").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeSslPoliciesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSslPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the tags for the specified Elastic Load Balancing resources. You can describe the tags for one or more
     * Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or rules.
     * </p>
     *
     * @param describeTagsRequest
     * @return Result of the DescribeTags operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws LoadBalancerNotFoundException,
            TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException, TrustStoreNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeTagsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTags");

            return clientHandler.execute(new ClientExecutionParams<DescribeTagsRequest, DescribeTagsResponse>()
                    .withOperationName("DescribeTags").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeTagsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the attributes for the specified target group.
     * </p>
     * <p>
     * For more information, see the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Application Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/network/load-balancer-target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Network Load Balancers Guide</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/elasticloadbalancing/latest/gateway/target-groups.html#target-group-attributes"
     * >Target group attributes</a> in the <i>Gateway Load Balancers Guide</i>
     * </p>
     * </li>
     * </ul>
     *
     * @param describeTargetGroupAttributesRequest
     * @return Result of the DescribeTargetGroupAttributes operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetGroupAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTargetGroupAttributesResponse describeTargetGroupAttributes(
            DescribeTargetGroupAttributesRequest describeTargetGroupAttributesRequest) throws TargetGroupNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeTargetGroupAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeTargetGroupAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTargetGroupAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeTargetGroupAttributesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTargetGroupAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTargetGroupAttributesRequest, DescribeTargetGroupAttributesResponse>()
                            .withOperationName("DescribeTargetGroupAttributes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeTargetGroupAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeTargetGroupAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the specified target groups or all of your target groups. By default, all target groups are described.
     * Alternatively, you can specify one of the following to filter the results: the ARN of the load balancer, the
     * names of one or more target groups, or the ARNs of one or more target groups.
     * </p>
     *
     * @param describeTargetGroupsRequest
     * @return Result of the DescribeTargetGroups operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTargetGroupsResponse describeTargetGroups(DescribeTargetGroupsRequest describeTargetGroupsRequest)
            throws LoadBalancerNotFoundException, TargetGroupNotFoundException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeTargetGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeTargetGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTargetGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTargetGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTargetGroups");

            return clientHandler.execute(new ClientExecutionParams<DescribeTargetGroupsRequest, DescribeTargetGroupsResponse>()
                    .withOperationName("DescribeTargetGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeTargetGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTargetGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the health of the specified targets or all of your targets.
     * </p>
     *
     * @param describeTargetHealthRequest
     * @return Result of the DescribeTargetHealth operation returned by the service.
     * @throws InvalidTargetException
     *         The specified target does not exist, is not in the same VPC as the target group, or has an unsupported
     *         instance type.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws HealthUnavailableException
     *         The health of the specified targets could not be retrieved due to an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTargetHealth
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTargetHealth"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTargetHealthResponse describeTargetHealth(DescribeTargetHealthRequest describeTargetHealthRequest)
            throws InvalidTargetException, TargetGroupNotFoundException, HealthUnavailableException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeTargetHealthResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeTargetHealthResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTargetHealthRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTargetHealthRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTargetHealth");

            return clientHandler.execute(new ClientExecutionParams<DescribeTargetHealthRequest, DescribeTargetHealthResponse>()
                    .withOperationName("DescribeTargetHealth").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeTargetHealthRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTargetHealthRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes all resources associated with the specified trust store.
     * </p>
     *
     * @param describeTrustStoreAssociationsRequest
     * @return Result of the DescribeTrustStoreAssociations operation returned by the service.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTrustStoreAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStoreAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTrustStoreAssociationsResponse describeTrustStoreAssociations(
            DescribeTrustStoreAssociationsRequest describeTrustStoreAssociationsRequest) throws TrustStoreNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeTrustStoreAssociationsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeTrustStoreAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrustStoreAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeTrustStoreAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrustStoreAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTrustStoreAssociationsRequest, DescribeTrustStoreAssociationsResponse>()
                            .withOperationName("DescribeTrustStoreAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeTrustStoreAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeTrustStoreAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the revocation files in use by the specified trust store or revocation files.
     * </p>
     *
     * @param describeTrustStoreRevocationsRequest
     * @return Result of the DescribeTrustStoreRevocations operation returned by the service.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws RevocationIdNotFoundException
     *         The specified revocation ID does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTrustStoreRevocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTrustStoreRevocationsResponse describeTrustStoreRevocations(
            DescribeTrustStoreRevocationsRequest describeTrustStoreRevocationsRequest) throws TrustStoreNotFoundException,
            RevocationIdNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeTrustStoreRevocationsResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeTrustStoreRevocationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrustStoreRevocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeTrustStoreRevocationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrustStoreRevocations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTrustStoreRevocationsRequest, DescribeTrustStoreRevocationsResponse>()
                            .withOperationName("DescribeTrustStoreRevocations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeTrustStoreRevocationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeTrustStoreRevocationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes all trust stores for the specified account.
     * </p>
     *
     * @param describeTrustStoresRequest
     * @return Result of the DescribeTrustStores operation returned by the service.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.DescribeTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DescribeTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTrustStoresResponse describeTrustStores(DescribeTrustStoresRequest describeTrustStoresRequest)
            throws TrustStoreNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<DescribeTrustStoresResponse> responseHandler = protocolFactory
                .createResponseHandler(DescribeTrustStoresResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrustStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrustStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrustStores");

            return clientHandler.execute(new ClientExecutionParams<DescribeTrustStoresRequest, DescribeTrustStoresResponse>()
                    .withOperationName("DescribeTrustStores").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeTrustStoresRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTrustStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the resource policy for a specified resource.
     * </p>
     *
     * @param getResourcePolicyRequest
     * @return Result of the GetResourcePolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.GetResourcePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/GetResourcePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<GetResourcePolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(GetResourcePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourcePolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourcePolicy");

            return clientHandler.execute(new ClientExecutionParams<GetResourcePolicyRequest, GetResourcePolicyResponse>()
                    .withOperationName("GetResourcePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getResourcePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetResourcePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the ca certificate bundle.
     * </p>
     * <p>
     * This action returns a pre-signed S3 URI which is active for ten minutes.
     * </p>
     *
     * @param getTrustStoreCaCertificatesBundleRequest
     * @return Result of the GetTrustStoreCaCertificatesBundle operation returned by the service.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.GetTrustStoreCaCertificatesBundle
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/GetTrustStoreCaCertificatesBundle"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetTrustStoreCaCertificatesBundleResponse getTrustStoreCaCertificatesBundle(
            GetTrustStoreCaCertificatesBundleRequest getTrustStoreCaCertificatesBundleRequest)
            throws TrustStoreNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<GetTrustStoreCaCertificatesBundleResponse> responseHandler = protocolFactory
                .createResponseHandler(GetTrustStoreCaCertificatesBundleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrustStoreCaCertificatesBundleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getTrustStoreCaCertificatesBundleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrustStoreCaCertificatesBundle");

            return clientHandler
                    .execute(new ClientExecutionParams<GetTrustStoreCaCertificatesBundleRequest, GetTrustStoreCaCertificatesBundleResponse>()
                            .withOperationName("GetTrustStoreCaCertificatesBundle").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getTrustStoreCaCertificatesBundleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetTrustStoreCaCertificatesBundleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the specified revocation file.
     * </p>
     * <p>
     * This action returns a pre-signed S3 URI which is active for ten minutes.
     * </p>
     *
     * @param getTrustStoreRevocationContentRequest
     * @return Result of the GetTrustStoreRevocationContent operation returned by the service.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws RevocationIdNotFoundException
     *         The specified revocation ID does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.GetTrustStoreRevocationContent
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/GetTrustStoreRevocationContent"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetTrustStoreRevocationContentResponse getTrustStoreRevocationContent(
            GetTrustStoreRevocationContentRequest getTrustStoreRevocationContentRequest) throws TrustStoreNotFoundException,
            RevocationIdNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<GetTrustStoreRevocationContentResponse> responseHandler = protocolFactory
                .createResponseHandler(GetTrustStoreRevocationContentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrustStoreRevocationContentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getTrustStoreRevocationContentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrustStoreRevocationContent");

            return clientHandler
                    .execute(new ClientExecutionParams<GetTrustStoreRevocationContentRequest, GetTrustStoreRevocationContentResponse>()
                            .withOperationName("GetTrustStoreRevocationContent").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getTrustStoreRevocationContentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetTrustStoreRevocationContentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the capacity reservation of the specified load balancer.
     * </p>
     * <p>
     * When modifying capacity reservation, you must include at least one <code>MinimumLoadBalancerCapacity</code> or
     * <code>ResetCapacityReservation</code>.
     * </p>
     *
     * @param modifyCapacityReservationRequest
     * @return Result of the ModifyCapacityReservation operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws CapacityUnitsLimitExceededException
     *         You've exceeded the capacity units limit.
     * @throws CapacityReservationPendingException
     *         There is a pending capacity reservation.
     * @throws InsufficientCapacityException
     *         There is insufficient capacity to reserve.
     * @throws CapacityDecreaseRequestsLimitExceededException
     *         You've exceeded the daily capacity decrease limit for this reservation.
     * @throws PriorRequestNotCompleteException
     *         This operation is not allowed while a prior request has not been completed.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyCapacityReservation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyCapacityReservation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyCapacityReservationResponse modifyCapacityReservation(
            ModifyCapacityReservationRequest modifyCapacityReservationRequest) throws LoadBalancerNotFoundException,
            InvalidConfigurationRequestException, CapacityUnitsLimitExceededException, CapacityReservationPendingException,
            InsufficientCapacityException, CapacityDecreaseRequestsLimitExceededException, PriorRequestNotCompleteException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<ModifyCapacityReservationResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyCapacityReservationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyCapacityReservationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyCapacityReservationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyCapacityReservation");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyCapacityReservationRequest, ModifyCapacityReservationResponse>()
                            .withOperationName("ModifyCapacityReservation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyCapacityReservationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyCapacityReservationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * [Application Load Balancers] Modify the IP pool associated to a load balancer.
     * </p>
     *
     * @param modifyIpPoolsRequest
     * @return Result of the ModifyIpPools operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyIpPools
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyIpPools"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyIpPoolsResponse modifyIpPools(ModifyIpPoolsRequest modifyIpPoolsRequest) throws LoadBalancerNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<ModifyIpPoolsResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyIpPoolsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyIpPoolsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyIpPoolsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyIpPools");

            return clientHandler.execute(new ClientExecutionParams<ModifyIpPoolsRequest, ModifyIpPoolsResponse>()
                    .withOperationName("ModifyIpPools").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyIpPoolsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyIpPoolsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Replaces the specified properties of the specified listener. Any properties that you do not specify remain
     * unchanged.
     * </p>
     * <p>
     * Changing the protocol from HTTPS to HTTP, or from TLS to TCP, removes the security policy and default certificate
     * properties. If you change the protocol from HTTP to HTTPS, or from TCP to TLS, you must add the security policy
     * and default certificate properties.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     *
     * @param modifyListenerRequest
     * @return Result of the ModifyListener operation returned by the service.
     * @throws DuplicateListenerException
     *         A listener with the specified port already exists.
     * @throws TooManyListenersException
     *         You've reached the limit on the number of listeners per load balancer.
     * @throws TooManyCertificatesException
     *         You've reached the limit on the number of certificates per load balancer.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws TargetGroupAssociationLimitException
     *         You've reached the limit on the number of load balancers per target group.
     * @throws IncompatibleProtocolsException
     *         The specified configuration is not valid with this protocol.
     * @throws SslPolicyNotFoundException
     *         The specified SSL policy does not exist.
     * @throws CertificateNotFoundException
     *         The specified certificate does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws TooManyActionsException
     *         You've reached the limit on the number of actions per rule.
     * @throws InvalidLoadBalancerActionException
     *         The requested action is not valid.
     * @throws TooManyUniqueTargetGroupsPerLoadBalancerException
     *         You've reached the limit on the number of unique target groups per load balancer across all listeners. If
     *         a target group is used by multiple actions for a load balancer, it is counted as only one use.
     * @throws AlpnPolicyNotSupportedException
     *         The specified ALPN policy is not supported.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws TrustStoreNotReadyException
     *         The specified trust store is not active.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyListener
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyListener"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyListenerResponse modifyListener(ModifyListenerRequest modifyListenerRequest) throws DuplicateListenerException,
            TooManyListenersException, TooManyCertificatesException, ListenerNotFoundException, TargetGroupNotFoundException,
            TargetGroupAssociationLimitException, IncompatibleProtocolsException, SslPolicyNotFoundException,
            CertificateNotFoundException, InvalidConfigurationRequestException, UnsupportedProtocolException,
            TooManyRegistrationsForTargetIdException, TooManyTargetsException, TooManyActionsException,
            InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException,
            AlpnPolicyNotSupportedException, TrustStoreNotFoundException, TrustStoreNotReadyException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<ModifyListenerResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyListenerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyListenerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyListenerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyListener");

            return clientHandler.execute(new ClientExecutionParams<ModifyListenerRequest, ModifyListenerResponse>()
                    .withOperationName("ModifyListener").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyListenerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyListenerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified listener.
     * </p>
     *
     * @param modifyListenerAttributesRequest
     * @return Result of the ModifyListenerAttributes operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyListenerAttributes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyListenerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyListenerAttributesResponse modifyListenerAttributes(
            ModifyListenerAttributesRequest modifyListenerAttributesRequest) throws ListenerNotFoundException,
            InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<ModifyListenerAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyListenerAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyListenerAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyListenerAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyListenerAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyListenerAttributesRequest, ModifyListenerAttributesResponse>()
                            .withOperationName("ModifyListenerAttributes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyListenerAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyListenerAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified Application Load Balancer, Network Load Balancer, or Gateway
     * Load Balancer.
     * </p>
     * <p>
     * If any of the specified attributes can't be modified as requested, the call fails. Any existing attributes that
     * you do not modify retain their current values.
     * </p>
     *
     * @param modifyLoadBalancerAttributesRequest
     * @return Result of the ModifyLoadBalancerAttributes operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyLoadBalancerAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyLoadBalancerAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyLoadBalancerAttributesResponse modifyLoadBalancerAttributes(
            ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) throws LoadBalancerNotFoundException,
            InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<ModifyLoadBalancerAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyLoadBalancerAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyLoadBalancerAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyLoadBalancerAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyLoadBalancerAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyLoadBalancerAttributesRequest, ModifyLoadBalancerAttributesResponse>()
                            .withOperationName("ModifyLoadBalancerAttributes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyLoadBalancerAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyLoadBalancerAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Replaces the specified properties of the specified rule. Any properties that you do not specify are unchanged.
     * </p>
     * <p>
     * To add an item to a list, remove an item from a list, or update an item in a list, you must provide the entire
     * list. For example, to add an action, specify a list with the current actions plus the new action.
     * </p>
     *
     * @param modifyRuleRequest
     * @return Result of the ModifyRule operation returned by the service.
     * @throws TargetGroupAssociationLimitException
     *         You've reached the limit on the number of load balancers per target group.
     * @throws IncompatibleProtocolsException
     *         The specified configuration is not valid with this protocol.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws UnsupportedProtocolException
     *         The specified protocol is not supported.
     * @throws TooManyActionsException
     *         You've reached the limit on the number of actions per rule.
     * @throws InvalidLoadBalancerActionException
     *         The requested action is not valid.
     * @throws TooManyUniqueTargetGroupsPerLoadBalancerException
     *         You've reached the limit on the number of unique target groups per load balancer across all listeners. If
     *         a target group is used by multiple actions for a load balancer, it is counted as only one use.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyRule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyRuleResponse modifyRule(ModifyRuleRequest modifyRuleRequest) throws TargetGroupAssociationLimitException,
            IncompatibleProtocolsException, RuleNotFoundException, OperationNotPermittedException,
            TooManyRegistrationsForTargetIdException, TooManyTargetsException, TargetGroupNotFoundException,
            UnsupportedProtocolException, TooManyActionsException, InvalidLoadBalancerActionException,
            TooManyUniqueTargetGroupsPerLoadBalancerException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {

        HttpResponseHandler<ModifyRuleResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyRule");

            return clientHandler.execute(new ClientExecutionParams<ModifyRuleRequest, ModifyRuleResponse>()
                    .withOperationName("ModifyRule").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(modifyRuleRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the health checks used when evaluating the health state of the targets in the specified target group.
     * </p>
     *
     * @param modifyTargetGroupRequest
     * @return Result of the ModifyTargetGroup operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyTargetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyTargetGroupResponse modifyTargetGroup(ModifyTargetGroupRequest modifyTargetGroupRequest)
            throws TargetGroupNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {

        HttpResponseHandler<ModifyTargetGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyTargetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyTargetGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyTargetGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyTargetGroup");

            return clientHandler.execute(new ClientExecutionParams<ModifyTargetGroupRequest, ModifyTargetGroupResponse>()
                    .withOperationName("ModifyTargetGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyTargetGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyTargetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the specified attributes of the specified target group.
     * </p>
     *
     * @param modifyTargetGroupAttributesRequest
     * @return Result of the ModifyTargetGroupAttributes operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyTargetGroupAttributes
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTargetGroupAttributes"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyTargetGroupAttributesResponse modifyTargetGroupAttributes(
            ModifyTargetGroupAttributesRequest modifyTargetGroupAttributesRequest) throws TargetGroupNotFoundException,
            InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<ModifyTargetGroupAttributesResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyTargetGroupAttributesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyTargetGroupAttributesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyTargetGroupAttributesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyTargetGroupAttributes");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyTargetGroupAttributesRequest, ModifyTargetGroupAttributesResponse>()
                            .withOperationName("ModifyTargetGroupAttributes").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(modifyTargetGroupAttributesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyTargetGroupAttributesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update the ca certificate bundle for the specified trust store.
     * </p>
     *
     * @param modifyTrustStoreRequest
     * @return Result of the ModifyTrustStore operation returned by the service.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws InvalidCaCertificatesBundleException
     *         The specified ca certificate bundle is in an invalid format, or corrupt.
     * @throws CaCertificatesBundleNotFoundException
     *         The specified ca certificate bundle does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.ModifyTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/ModifyTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ModifyTrustStoreResponse modifyTrustStore(ModifyTrustStoreRequest modifyTrustStoreRequest)
            throws TrustStoreNotFoundException, InvalidCaCertificatesBundleException, CaCertificatesBundleNotFoundException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<ModifyTrustStoreResponse> responseHandler = protocolFactory
                .createResponseHandler(ModifyTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(modifyTrustStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyTrustStore");

            return clientHandler.execute(new ClientExecutionParams<ModifyTrustStoreRequest, ModifyTrustStoreResponse>()
                    .withOperationName("ModifyTrustStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(modifyTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ModifyTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers the specified targets with the specified target group.
     * </p>
     * <p>
     * If the target is an EC2 instance, it must be in the <code>running</code> state when you register it.
     * </p>
     * <p>
     * By default, the load balancer routes requests to registered targets using the protocol and port for the target
     * group. Alternatively, you can override the port for a target when you register it. You can register each EC2
     * instance or IP address with the same target group multiple times using different ports.
     * </p>
     * <p>
     * With a Network Load Balancer, you can't register instances by instance ID if they have the following instance
     * types: C1, CC1, CC2, CG1, CG2, CR1, CS1, G1, G2, HI1, HS1, M1, M2, M3, and T1. You can register instances of
     * these types by IP address.
     * </p>
     *
     * @param registerTargetsRequest
     * @return Result of the RegisterTargets operation returned by the service.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws TooManyTargetsException
     *         You've reached the limit on the number of targets.
     * @throws InvalidTargetException
     *         The specified target does not exist, is not in the same VPC as the target group, or has an unsupported
     *         instance type.
     * @throws TooManyRegistrationsForTargetIdException
     *         You've reached the limit on the number of times a target can be registered with a load balancer.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.RegisterTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RegisterTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterTargetsResponse registerTargets(RegisterTargetsRequest registerTargetsRequest)
            throws TargetGroupNotFoundException, TooManyTargetsException, InvalidTargetException,
            TooManyRegistrationsForTargetIdException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<RegisterTargetsResponse> responseHandler = protocolFactory
                .createResponseHandler(RegisterTargetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerTargetsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerTargetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterTargets");

            return clientHandler.execute(new ClientExecutionParams<RegisterTargetsRequest, RegisterTargetsResponse>()
                    .withOperationName("RegisterTargets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(registerTargetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RegisterTargetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified certificate from the certificate list for the specified HTTPS or TLS listener.
     * </p>
     *
     * @param removeListenerCertificatesRequest
     * @return Result of the RemoveListenerCertificates operation returned by the service.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.RemoveListenerCertificates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveListenerCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveListenerCertificatesResponse removeListenerCertificates(
            RemoveListenerCertificatesRequest removeListenerCertificatesRequest) throws ListenerNotFoundException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<RemoveListenerCertificatesResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveListenerCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeListenerCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeListenerCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveListenerCertificates");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveListenerCertificatesRequest, RemoveListenerCertificatesResponse>()
                            .withOperationName("RemoveListenerCertificates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeListenerCertificatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveListenerCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified tags from the specified Elastic Load Balancing resources. You can remove the tags for one
     * or more Application Load Balancers, Network Load Balancers, Gateway Load Balancers, target groups, listeners, or
     * rules.
     * </p>
     *
     * @param removeTagsRequest
     * @return Result of the RemoveTags operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws TargetGroupNotFoundException
     *         The specified target group does not exist.
     * @throws ListenerNotFoundException
     *         The specified listener does not exist.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws TooManyTagsException
     *         You've reached the limit on the number of tags for this resource.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.RemoveTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws LoadBalancerNotFoundException,
            TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException, TooManyTagsException,
            TrustStoreNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<RemoveTagsResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTags");

            return clientHandler.execute(new ClientExecutionParams<RemoveTagsRequest, RemoveTagsResponse>()
                    .withOperationName("RemoveTags").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(removeTagsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified revocation file from the specified trust store.
     * </p>
     *
     * @param removeTrustStoreRevocationsRequest
     * @return Result of the RemoveTrustStoreRevocations operation returned by the service.
     * @throws TrustStoreNotFoundException
     *         The specified trust store does not exist.
     * @throws RevocationIdNotFoundException
     *         The specified revocation ID does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.RemoveTrustStoreRevocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/RemoveTrustStoreRevocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveTrustStoreRevocationsResponse removeTrustStoreRevocations(
            RemoveTrustStoreRevocationsRequest removeTrustStoreRevocationsRequest) throws TrustStoreNotFoundException,
            RevocationIdNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<RemoveTrustStoreRevocationsResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveTrustStoreRevocationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeTrustStoreRevocationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTrustStoreRevocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTrustStoreRevocations");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveTrustStoreRevocationsRequest, RemoveTrustStoreRevocationsResponse>()
                            .withOperationName("RemoveTrustStoreRevocations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeTrustStoreRevocationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveTrustStoreRevocationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the type of IP addresses used by the subnets of the specified load balancer.
     * </p>
     *
     * @param setIpAddressTypeRequest
     * @return Result of the SetIpAddressType operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws InvalidSubnetException
     *         The specified subnet is out of available addresses.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.SetIpAddressType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetIpAddressType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SetIpAddressTypeResponse setIpAddressType(SetIpAddressTypeRequest setIpAddressTypeRequest)
            throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, InvalidSubnetException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<SetIpAddressTypeResponse> responseHandler = protocolFactory
                .createResponseHandler(SetIpAddressTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setIpAddressTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setIpAddressTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetIpAddressType");

            return clientHandler.execute(new ClientExecutionParams<SetIpAddressTypeRequest, SetIpAddressTypeResponse>()
                    .withOperationName("SetIpAddressType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(setIpAddressTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetIpAddressTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the priorities of the specified rules.
     * </p>
     * <p>
     * You can reorder the rules as long as there are no priority conflicts in the new order. Any existing rules that
     * you do not specify retain their current priority.
     * </p>
     *
     * @param setRulePrioritiesRequest
     * @return Result of the SetRulePriorities operation returned by the service.
     * @throws RuleNotFoundException
     *         The specified rule does not exist.
     * @throws PriorityInUseException
     *         The specified priority is in use.
     * @throws OperationNotPermittedException
     *         This operation is not allowed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.SetRulePriorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetRulePriorities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SetRulePrioritiesResponse setRulePriorities(SetRulePrioritiesRequest setRulePrioritiesRequest)
            throws RuleNotFoundException, PriorityInUseException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<SetRulePrioritiesResponse> responseHandler = protocolFactory
                .createResponseHandler(SetRulePrioritiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setRulePrioritiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setRulePrioritiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetRulePriorities");

            return clientHandler.execute(new ClientExecutionParams<SetRulePrioritiesRequest, SetRulePrioritiesResponse>()
                    .withOperationName("SetRulePriorities").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(setRulePrioritiesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetRulePrioritiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified security groups with the specified Application Load Balancer or Network Load Balancer.
     * The specified security groups override the previously associated security groups.
     * </p>
     * <p>
     * You can't perform this operation on a Network Load Balancer unless you specified a security group for the load
     * balancer when you created it.
     * </p>
     * <p>
     * You can't associate a security group with a Gateway Load Balancer.
     * </p>
     *
     * @param setSecurityGroupsRequest
     * @return Result of the SetSecurityGroups operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws InvalidSecurityGroupException
     *         The specified security group does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.SetSecurityGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSecurityGroups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SetSecurityGroupsResponse setSecurityGroups(SetSecurityGroupsRequest setSecurityGroupsRequest)
            throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, InvalidSecurityGroupException,
            AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {

        HttpResponseHandler<SetSecurityGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(SetSecurityGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setSecurityGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setSecurityGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetSecurityGroups");

            return clientHandler.execute(new ClientExecutionParams<SetSecurityGroupsRequest, SetSecurityGroupsResponse>()
                    .withOperationName("SetSecurityGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(setSecurityGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetSecurityGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the Availability Zones for the specified public subnets for the specified Application Load Balancer,
     * Network Load Balancer or Gateway Load Balancer. The specified subnets replace the previously enabled subnets.
     * </p>
     * <p>
     * When you specify subnets for a Network Load Balancer, or Gateway Load Balancer you must include all subnets that
     * were enabled previously, with their existing configurations, plus any additional subnets.
     * </p>
     *
     * @param setSubnetsRequest
     * @return Result of the SetSubnets operation returned by the service.
     * @throws LoadBalancerNotFoundException
     *         The specified load balancer does not exist.
     * @throws InvalidConfigurationRequestException
     *         The requested configuration is not valid.
     * @throws SubnetNotFoundException
     *         The specified subnet does not exist.
     * @throws InvalidSubnetException
     *         The specified subnet is out of available addresses.
     * @throws AllocationIdNotFoundException
     *         The specified allocation ID does not exist.
     * @throws AvailabilityZoneNotSupportedException
     *         The specified Availability Zone is not supported.
     * @throws CapacityReservationPendingException
     *         There is a pending capacity reservation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ElasticLoadBalancingV2Exception
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ElasticLoadBalancingV2Client.SetSubnets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/SetSubnets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SetSubnetsResponse setSubnets(SetSubnetsRequest setSubnetsRequest) throws LoadBalancerNotFoundException,
            InvalidConfigurationRequestException, SubnetNotFoundException, InvalidSubnetException, AllocationIdNotFoundException,
            AvailabilityZoneNotSupportedException, CapacityReservationPendingException, AwsServiceException, SdkClientException,
            ElasticLoadBalancingV2Exception {

        HttpResponseHandler<SetSubnetsResponse> responseHandler = protocolFactory
                .createResponseHandler(SetSubnetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setSubnetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setSubnetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetSubnets");

            return clientHandler.execute(new ClientExecutionParams<SetSubnetsRequest, SetSubnetsResponse>()
                    .withOperationName("SetSubnets").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(setSubnetsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetSubnetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link ElasticLoadBalancingV2Waiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link ElasticLoadBalancingV2Waiter}
     */
    @Override
    public ElasticLoadBalancingV2Waiter waiter() {
        return ElasticLoadBalancingV2Waiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        ElasticLoadBalancingV2ServiceClientConfigurationBuilder serviceConfigBuilder = new ElasticLoadBalancingV2ServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CapacityDecreaseRequestLimitExceeded")
                                .exceptionBuilderSupplier(CapacityDecreaseRequestsLimitExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedProtocol")
                                .exceptionBuilderSupplier(UnsupportedProtocolException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AllocationIdNotFound")
                                .exceptionBuilderSupplier(AllocationIdNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateTargetGroupName")
                                .exceptionBuilderSupplier(DuplicateTargetGroupNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RevocationContentNotFound")
                                .exceptionBuilderSupplier(RevocationContentNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LoadBalancerNotFound")
                                .exceptionBuilderSupplier(LoadBalancerNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyLoadBalancers")
                                .exceptionBuilderSupplier(TooManyLoadBalancersException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidConfigurationRequest")
                                .exceptionBuilderSupplier(InvalidConfigurationRequestException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyActions")
                                .exceptionBuilderSupplier(TooManyActionsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateLoadBalancerName")
                                .exceptionBuilderSupplier(DuplicateLoadBalancerNameException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InsufficientCapacity")
                                .exceptionBuilderSupplier(InsufficientCapacityException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLoadBalancerAction")
                                .exceptionBuilderSupplier(InvalidLoadBalancerActionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrustStoreInUse")
                                .exceptionBuilderSupplier(TrustStoreInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CaCertificatesBundleNotFound")
                                .exceptionBuilderSupplier(CaCertificatesBundleNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CertificateNotFound")
                                .exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetGroupNotFound")
                                .exceptionBuilderSupplier(TargetGroupNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ListenerNotFound")
                                .exceptionBuilderSupplier(ListenerNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFound")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PriorityInUse")
                                .exceptionBuilderSupplier(PriorityInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRevocationContent")
                                .exceptionBuilderSupplier(InvalidRevocationContentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SSLPolicyNotFound")
                                .exceptionBuilderSupplier(SslPolicyNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateListener")
                                .exceptionBuilderSupplier(DuplicateListenerException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidScheme")
                                .exceptionBuilderSupplier(InvalidSchemeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSubnet")
                                .exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrustStores")
                                .exceptionBuilderSupplier(TooManyTrustStoresException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTargets")
                                .exceptionBuilderSupplier(TooManyTargetsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ALPNPolicyNotFound")
                                .exceptionBuilderSupplier(AlpnPolicyNotSupportedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyUniqueTargetGroupsPerLoadBalancer")
                                .exceptionBuilderSupplier(TooManyUniqueTargetGroupsPerLoadBalancerException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociationNotFound")
                                .exceptionBuilderSupplier(TrustStoreAssociationNotFoundException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUse")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRules")
                                .exceptionBuilderSupplier(TooManyRulesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCertificates")
                                .exceptionBuilderSupplier(TooManyCertificatesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTargetGroups")
                                .exceptionBuilderSupplier(TooManyTargetGroupsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CapacityUnitsLimitExceeded")
                                .exceptionBuilderSupplier(CapacityUnitsLimitExceededException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetGroupAssociationLimit")
                                .exceptionBuilderSupplier(TargetGroupAssociationLimitException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrustStoreNotReady")
                                .exceptionBuilderSupplier(TrustStoreNotReadyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSecurityGroup")
                                .exceptionBuilderSupplier(InvalidSecurityGroupException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncompatibleProtocols")
                                .exceptionBuilderSupplier(IncompatibleProtocolsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RevocationIdNotFound")
                                .exceptionBuilderSupplier(RevocationIdNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyListeners")
                                .exceptionBuilderSupplier(TooManyListenersException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OperationNotPermitted")
                                .exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateTagKeys")
                                .exceptionBuilderSupplier(DuplicateTagKeysException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTags")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRegistrationsForTargetId")
                                .exceptionBuilderSupplier(TooManyRegistrationsForTargetIdException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PriorRequestNotComplete")
                                .exceptionBuilderSupplier(PriorRequestNotCompleteException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateTrustStoreName")
                                .exceptionBuilderSupplier(DuplicateTrustStoreNameException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCaCertificatesBundle")
                                .exceptionBuilderSupplier(InvalidCaCertificatesBundleException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CapacityReservationPending")
                                .exceptionBuilderSupplier(CapacityReservationPendingException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTarget")
                                .exceptionBuilderSupplier(InvalidTargetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrustStoreNotFound")
                                .exceptionBuilderSupplier(TrustStoreNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrustStoreRevocationEntries")
                                .exceptionBuilderSupplier(TooManyTrustStoreRevocationEntriesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubnetNotFound")
                                .exceptionBuilderSupplier(SubnetNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AvailabilityZoneNotSupported")
                                .exceptionBuilderSupplier(AvailabilityZoneNotSupportedException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RuleNotFound")
                                .exceptionBuilderSupplier(RuleNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeleteAssociationSameAccount")
                                .exceptionBuilderSupplier(DeleteAssociationSameAccountException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HealthUnavailable")
                                .exceptionBuilderSupplier(HealthUnavailableException::builder).httpStatusCode(500).build())
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(ElasticLoadBalancingV2Exception::builder).build();
    }

    @Override
    public final ElasticLoadBalancingV2ServiceClientConfiguration serviceClientConfiguration() {
        return new ElasticLoadBalancingV2ServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
