/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTrustStoreRevocationContentRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, GetTrustStoreRevocationContentRequest> {
    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrustStoreArn").getter(GetTrustStoreRevocationContentRequest.getter(GetTrustStoreRevocationContentRequest::trustStoreArn)).setter(GetTrustStoreRevocationContentRequest.setter(Builder::trustStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStoreArn").build()}).build();
    private static final SdkField<Long> REVOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RevocationId").getter(GetTrustStoreRevocationContentRequest.getter(GetTrustStoreRevocationContentRequest::revocationId)).setter(GetTrustStoreRevocationContentRequest.setter(Builder::revocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRUST_STORE_ARN_FIELD, REVOCATION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTrustStoreRevocationContentRequest.memberNameToFieldInitializer();
    private final String trustStoreArn;
    private final Long revocationId;

    private GetTrustStoreRevocationContentRequest(BuilderImpl builder) {
        super(builder);
        this.trustStoreArn = builder.trustStoreArn;
        this.revocationId = builder.revocationId;
    }

    public final String trustStoreArn() {
        return this.trustStoreArn;
    }

    public final Long revocationId() {
        return this.revocationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTrustStoreRevocationContentRequest)) {
            return false;
        }
        GetTrustStoreRevocationContentRequest other = (GetTrustStoreRevocationContentRequest)((Object)obj);
        return Objects.equals(this.trustStoreArn(), other.trustStoreArn()) && Objects.equals(this.revocationId(), other.revocationId());
    }

    public final String toString() {
        return ToString.builder((String)"GetTrustStoreRevocationContentRequest").add("TrustStoreArn", (Object)this.trustStoreArn()).add("RevocationId", (Object)this.revocationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrustStoreArn": {
                return Optional.ofNullable(clazz.cast(this.trustStoreArn()));
            }
            case "RevocationId": {
                return Optional.ofNullable(clazz.cast(this.revocationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrustStoreArn", TRUST_STORE_ARN_FIELD);
        map.put("RevocationId", REVOCATION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTrustStoreRevocationContentRequest, T> g) {
        return obj -> g.apply((GetTrustStoreRevocationContentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String trustStoreArn;
        private Long revocationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTrustStoreRevocationContentRequest model) {
            super(model);
            this.trustStoreArn(model.trustStoreArn);
            this.revocationId(model.revocationId);
        }

        public final String getTrustStoreArn() {
            return this.trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final Long getRevocationId() {
            return this.revocationId;
        }

        public final void setRevocationId(Long revocationId) {
            this.revocationId = revocationId;
        }

        @Override
        public final Builder revocationId(Long revocationId) {
            this.revocationId = revocationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTrustStoreRevocationContentRequest build() {
            return new GetTrustStoreRevocationContentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTrustStoreRevocationContentRequest> {
        public Builder trustStoreArn(String var1);

        public Builder revocationId(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

