/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZone;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.EnablePrefixForIpv6SourceNatEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IpAddressType;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerSchemeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerState;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerTypeEnum;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SecurityGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBalancer> {
    private static final SdkField<String> LOAD_BALANCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerArn").getter(LoadBalancer.getter(LoadBalancer::loadBalancerArn)).setter(LoadBalancer.setter(Builder::loadBalancerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerArn").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DNSName").getter(LoadBalancer.getter(LoadBalancer::dnsName)).setter(LoadBalancer.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSName").build()}).build();
    private static final SdkField<String> CANONICAL_HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CanonicalHostedZoneId").getter(LoadBalancer.getter(LoadBalancer::canonicalHostedZoneId)).setter(LoadBalancer.setter(Builder::canonicalHostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanonicalHostedZoneId").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(LoadBalancer.getter(LoadBalancer::createdTime)).setter(LoadBalancer.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<String> LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LoadBalancerName").getter(LoadBalancer.getter(LoadBalancer::loadBalancerName)).setter(LoadBalancer.setter(Builder::loadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerName").build()}).build();
    private static final SdkField<String> SCHEME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scheme").getter(LoadBalancer.getter(LoadBalancer::schemeAsString)).setter(LoadBalancer.setter(Builder::scheme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scheme").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(LoadBalancer.getter(LoadBalancer::vpcId)).setter(LoadBalancer.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<LoadBalancerState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("State").getter(LoadBalancer.getter(LoadBalancer::state)).setter(LoadBalancer.setter(Builder::state)).constructor(LoadBalancerState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(LoadBalancer.getter(LoadBalancer::typeAsString)).setter(LoadBalancer.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<AvailabilityZone>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(LoadBalancer.getter(LoadBalancer::availabilityZones)).setter(LoadBalancer.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AvailabilityZone::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(LoadBalancer.getter(LoadBalancer::securityGroups)).setter(LoadBalancer.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IP_ADDRESS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddressType").getter(LoadBalancer.getter(LoadBalancer::ipAddressTypeAsString)).setter(LoadBalancer.setter(Builder::ipAddressType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressType").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOwnedIpv4Pool").getter(LoadBalancer.getter(LoadBalancer::customerOwnedIpv4Pool)).setter(LoadBalancer.setter(Builder::customerOwnedIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool").build()}).build();
    private static final SdkField<String> ENFORCE_SECURITY_GROUP_INBOUND_RULES_ON_PRIVATE_LINK_TRAFFIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic").getter(LoadBalancer.getter(LoadBalancer::enforceSecurityGroupInboundRulesOnPrivateLinkTraffic)).setter(LoadBalancer.setter(Builder::enforceSecurityGroupInboundRulesOnPrivateLinkTraffic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic").build()}).build();
    private static final SdkField<String> ENABLE_PREFIX_FOR_IPV6_SOURCE_NAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnablePrefixForIpv6SourceNat").getter(LoadBalancer.getter(LoadBalancer::enablePrefixForIpv6SourceNatAsString)).setter(LoadBalancer.setter(Builder::enablePrefixForIpv6SourceNat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePrefixForIpv6SourceNat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOAD_BALANCER_ARN_FIELD, DNS_NAME_FIELD, CANONICAL_HOSTED_ZONE_ID_FIELD, CREATED_TIME_FIELD, LOAD_BALANCER_NAME_FIELD, SCHEME_FIELD, VPC_ID_FIELD, STATE_FIELD, TYPE_FIELD, AVAILABILITY_ZONES_FIELD, SECURITY_GROUPS_FIELD, IP_ADDRESS_TYPE_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD, ENFORCE_SECURITY_GROUP_INBOUND_RULES_ON_PRIVATE_LINK_TRAFFIC_FIELD, ENABLE_PREFIX_FOR_IPV6_SOURCE_NAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LoadBalancer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String loadBalancerArn;
    private final String dnsName;
    private final String canonicalHostedZoneId;
    private final Instant createdTime;
    private final String loadBalancerName;
    private final String scheme;
    private final String vpcId;
    private final LoadBalancerState state;
    private final String type;
    private final List<AvailabilityZone> availabilityZones;
    private final List<String> securityGroups;
    private final String ipAddressType;
    private final String customerOwnedIpv4Pool;
    private final String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
    private final String enablePrefixForIpv6SourceNat;

    private LoadBalancer(BuilderImpl builder) {
        this.loadBalancerArn = builder.loadBalancerArn;
        this.dnsName = builder.dnsName;
        this.canonicalHostedZoneId = builder.canonicalHostedZoneId;
        this.createdTime = builder.createdTime;
        this.loadBalancerName = builder.loadBalancerName;
        this.scheme = builder.scheme;
        this.vpcId = builder.vpcId;
        this.state = builder.state;
        this.type = builder.type;
        this.availabilityZones = builder.availabilityZones;
        this.securityGroups = builder.securityGroups;
        this.ipAddressType = builder.ipAddressType;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
        this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = builder.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        this.enablePrefixForIpv6SourceNat = builder.enablePrefixForIpv6SourceNat;
    }

    public final String loadBalancerArn() {
        return this.loadBalancerArn;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final String canonicalHostedZoneId() {
        return this.canonicalHostedZoneId;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final String loadBalancerName() {
        return this.loadBalancerName;
    }

    public final LoadBalancerSchemeEnum scheme() {
        return LoadBalancerSchemeEnum.fromValue(this.scheme);
    }

    public final String schemeAsString() {
        return this.scheme;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final LoadBalancerState state() {
        return this.state;
    }

    public final LoadBalancerTypeEnum type() {
        return LoadBalancerTypeEnum.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<AvailabilityZone> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroups() {
        return this.securityGroups;
    }

    public final IpAddressType ipAddressType() {
        return IpAddressType.fromValue(this.ipAddressType);
    }

    public final String ipAddressTypeAsString() {
        return this.ipAddressType;
    }

    public final String customerOwnedIpv4Pool() {
        return this.customerOwnedIpv4Pool;
    }

    public final String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic() {
        return this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
    }

    public final EnablePrefixForIpv6SourceNatEnum enablePrefixForIpv6SourceNat() {
        return EnablePrefixForIpv6SourceNatEnum.fromValue(this.enablePrefixForIpv6SourceNat);
    }

    public final String enablePrefixForIpv6SourceNatAsString() {
        return this.enablePrefixForIpv6SourceNat;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.canonicalHostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddressTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePrefixForIpv6SourceNatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancer)) {
            return false;
        }
        LoadBalancer other = (LoadBalancer)obj;
        return Objects.equals(this.loadBalancerArn(), other.loadBalancerArn()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.canonicalHostedZoneId(), other.canonicalHostedZoneId()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.loadBalancerName(), other.loadBalancerName()) && Objects.equals(this.schemeAsString(), other.schemeAsString()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.ipAddressTypeAsString(), other.ipAddressTypeAsString()) && Objects.equals(this.customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool()) && Objects.equals(this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(), other.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic()) && Objects.equals(this.enablePrefixForIpv6SourceNatAsString(), other.enablePrefixForIpv6SourceNatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LoadBalancer").add("LoadBalancerArn", (Object)this.loadBalancerArn()).add("DNSName", (Object)this.dnsName()).add("CanonicalHostedZoneId", (Object)this.canonicalHostedZoneId()).add("CreatedTime", (Object)this.createdTime()).add("LoadBalancerName", (Object)this.loadBalancerName()).add("Scheme", (Object)this.schemeAsString()).add("VpcId", (Object)this.vpcId()).add("State", (Object)this.state()).add("Type", (Object)this.typeAsString()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("IpAddressType", (Object)this.ipAddressTypeAsString()).add("CustomerOwnedIpv4Pool", (Object)this.customerOwnedIpv4Pool()).add("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic", (Object)this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic()).add("EnablePrefixForIpv6SourceNat", (Object)this.enablePrefixForIpv6SourceNatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LoadBalancerArn": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerArn()));
            }
            case "DNSName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "CanonicalHostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.canonicalHostedZoneId()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerName()));
            }
            case "Scheme": {
                return Optional.ofNullable(clazz.cast(this.schemeAsString()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "IpAddressType": {
                return Optional.ofNullable(clazz.cast(this.ipAddressTypeAsString()));
            }
            case "CustomerOwnedIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIpv4Pool()));
            }
            case "EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic": {
                return Optional.ofNullable(clazz.cast(this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic()));
            }
            case "EnablePrefixForIpv6SourceNat": {
                return Optional.ofNullable(clazz.cast(this.enablePrefixForIpv6SourceNatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LoadBalancerArn", LOAD_BALANCER_ARN_FIELD);
        map.put("DNSName", DNS_NAME_FIELD);
        map.put("CanonicalHostedZoneId", CANONICAL_HOSTED_ZONE_ID_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("LoadBalancerName", LOAD_BALANCER_NAME_FIELD);
        map.put("Scheme", SCHEME_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("IpAddressType", IP_ADDRESS_TYPE_FIELD);
        map.put("CustomerOwnedIpv4Pool", CUSTOMER_OWNED_IPV4_POOL_FIELD);
        map.put("EnforceSecurityGroupInboundRulesOnPrivateLinkTraffic", ENFORCE_SECURITY_GROUP_INBOUND_RULES_ON_PRIVATE_LINK_TRAFFIC_FIELD);
        map.put("EnablePrefixForIpv6SourceNat", ENABLE_PREFIX_FOR_IPV6_SOURCE_NAT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancer, T> g) {
        return obj -> g.apply((LoadBalancer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String loadBalancerArn;
        private String dnsName;
        private String canonicalHostedZoneId;
        private Instant createdTime;
        private String loadBalancerName;
        private String scheme;
        private String vpcId;
        private LoadBalancerState state;
        private String type;
        private List<AvailabilityZone> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String ipAddressType;
        private String customerOwnedIpv4Pool;
        private String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        private String enablePrefixForIpv6SourceNat;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancer model) {
            this.loadBalancerArn(model.loadBalancerArn);
            this.dnsName(model.dnsName);
            this.canonicalHostedZoneId(model.canonicalHostedZoneId);
            this.createdTime(model.createdTime);
            this.loadBalancerName(model.loadBalancerName);
            this.scheme(model.scheme);
            this.vpcId(model.vpcId);
            this.state(model.state);
            this.type(model.type);
            this.availabilityZones(model.availabilityZones);
            this.securityGroups(model.securityGroups);
            this.ipAddressType(model.ipAddressType);
            this.customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(model.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic);
            this.enablePrefixForIpv6SourceNat(model.enablePrefixForIpv6SourceNat);
        }

        public final String getLoadBalancerArn() {
            return this.loadBalancerArn;
        }

        public final void setLoadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
        }

        @Override
        public final Builder loadBalancerArn(String loadBalancerArn) {
            this.loadBalancerArn = loadBalancerArn;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getCanonicalHostedZoneId() {
            return this.canonicalHostedZoneId;
        }

        public final void setCanonicalHostedZoneId(String canonicalHostedZoneId) {
            this.canonicalHostedZoneId = canonicalHostedZoneId;
        }

        @Override
        public final Builder canonicalHostedZoneId(String canonicalHostedZoneId) {
            this.canonicalHostedZoneId = canonicalHostedZoneId;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final String getLoadBalancerName() {
            return this.loadBalancerName;
        }

        public final void setLoadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
        }

        @Override
        public final Builder loadBalancerName(String loadBalancerName) {
            this.loadBalancerName = loadBalancerName;
            return this;
        }

        public final String getScheme() {
            return this.scheme;
        }

        public final void setScheme(String scheme) {
            this.scheme = scheme;
        }

        @Override
        public final Builder scheme(String scheme) {
            this.scheme = scheme;
            return this;
        }

        @Override
        public final Builder scheme(LoadBalancerSchemeEnum scheme) {
            this.scheme(scheme == null ? null : scheme.toString());
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final LoadBalancerState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(LoadBalancerState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(LoadBalancerState state) {
            this.state = state;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LoadBalancerTypeEnum type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<AvailabilityZone.Builder> getAvailabilityZones() {
            List<AvailabilityZone.Builder> result = AvailabilityZonesCopier.copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(Collection<AvailabilityZone.BuilderImpl> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<AvailabilityZone> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AvailabilityZone ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... availabilityZones) {
            this.availabilityZones(Stream.of(availabilityZones).map(c -> (AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSecurityGroups() {
            if (this.securityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroups;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = SecurityGroupsCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final String getIpAddressType() {
            return this.ipAddressType;
        }

        public final void setIpAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
        }

        @Override
        public final Builder ipAddressType(String ipAddressType) {
            this.ipAddressType = ipAddressType;
            return this;
        }

        @Override
        public final Builder ipAddressType(IpAddressType ipAddressType) {
            this.ipAddressType(ipAddressType == null ? null : ipAddressType.toString());
            return this;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return this.customerOwnedIpv4Pool;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final String getEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic() {
            return this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        }

        public final void setEnforceSecurityGroupInboundRulesOnPrivateLinkTraffic(String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
        }

        @Override
        public final Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(String enforceSecurityGroupInboundRulesOnPrivateLinkTraffic) {
            this.enforceSecurityGroupInboundRulesOnPrivateLinkTraffic = enforceSecurityGroupInboundRulesOnPrivateLinkTraffic;
            return this;
        }

        public final String getEnablePrefixForIpv6SourceNat() {
            return this.enablePrefixForIpv6SourceNat;
        }

        public final void setEnablePrefixForIpv6SourceNat(String enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat = enablePrefixForIpv6SourceNat;
        }

        @Override
        public final Builder enablePrefixForIpv6SourceNat(String enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat = enablePrefixForIpv6SourceNat;
            return this;
        }

        @Override
        public final Builder enablePrefixForIpv6SourceNat(EnablePrefixForIpv6SourceNatEnum enablePrefixForIpv6SourceNat) {
            this.enablePrefixForIpv6SourceNat(enablePrefixForIpv6SourceNat == null ? null : enablePrefixForIpv6SourceNat.toString());
            return this;
        }

        public LoadBalancer build() {
            return new LoadBalancer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBalancer> {
        public Builder loadBalancerArn(String var1);

        public Builder dnsName(String var1);

        public Builder canonicalHostedZoneId(String var1);

        public Builder createdTime(Instant var1);

        public Builder loadBalancerName(String var1);

        public Builder scheme(String var1);

        public Builder scheme(LoadBalancerSchemeEnum var1);

        public Builder vpcId(String var1);

        public Builder state(LoadBalancerState var1);

        default public Builder state(Consumer<LoadBalancerState.Builder> state) {
            return this.state((LoadBalancerState)((LoadBalancerState.Builder)LoadBalancerState.builder().applyMutation(state)).build());
        }

        public Builder type(String var1);

        public Builder type(LoadBalancerTypeEnum var1);

        public Builder availabilityZones(Collection<AvailabilityZone> var1);

        public Builder availabilityZones(AvailabilityZone ... var1);

        public Builder availabilityZones(Consumer<AvailabilityZone.Builder> ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder ipAddressType(String var1);

        public Builder ipAddressType(IpAddressType var1);

        public Builder customerOwnedIpv4Pool(String var1);

        public Builder enforceSecurityGroupInboundRulesOnPrivateLinkTraffic(String var1);

        public Builder enablePrefixForIpv6SourceNat(String var1);

        public Builder enablePrefixForIpv6SourceNat(EnablePrefixForIpv6SourceNatEnum var1);
    }
}

