/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RevocationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RevocationContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RevocationContent> {
    private static final SdkField<String> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Bucket").getter(RevocationContent.getter(RevocationContent::s3Bucket)).setter(RevocationContent.setter(Builder::s3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Bucket").build()}).build();
    private static final SdkField<String> S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Key").getter(RevocationContent.getter(RevocationContent::s3Key)).setter(RevocationContent.setter(Builder::s3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Key").build()}).build();
    private static final SdkField<String> S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3ObjectVersion").getter(RevocationContent.getter(RevocationContent::s3ObjectVersion)).setter(RevocationContent.setter(Builder::s3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3ObjectVersion").build()}).build();
    private static final SdkField<String> REVOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RevocationType").getter(RevocationContent.getter(RevocationContent::revocationTypeAsString)).setter(RevocationContent.setter(Builder::revocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevocationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, S3_KEY_FIELD, S3_OBJECT_VERSION_FIELD, REVOCATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RevocationContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String s3Bucket;
    private final String s3Key;
    private final String s3ObjectVersion;
    private final String revocationType;

    private RevocationContent(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.s3Key = builder.s3Key;
        this.s3ObjectVersion = builder.s3ObjectVersion;
        this.revocationType = builder.revocationType;
    }

    public final String s3Bucket() {
        return this.s3Bucket;
    }

    public final String s3Key() {
        return this.s3Key;
    }

    public final String s3ObjectVersion() {
        return this.s3ObjectVersion;
    }

    public final RevocationType revocationType() {
        return RevocationType.fromValue(this.revocationType);
    }

    public final String revocationTypeAsString() {
        return this.revocationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.revocationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevocationContent)) {
            return false;
        }
        RevocationContent other = (RevocationContent)obj;
        return Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3Key(), other.s3Key()) && Objects.equals(this.s3ObjectVersion(), other.s3ObjectVersion()) && Objects.equals(this.revocationTypeAsString(), other.revocationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RevocationContent").add("S3Bucket", (Object)this.s3Bucket()).add("S3Key", (Object)this.s3Key()).add("S3ObjectVersion", (Object)this.s3ObjectVersion()).add("RevocationType", (Object)this.revocationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "S3Key": {
                return Optional.ofNullable(clazz.cast(this.s3Key()));
            }
            case "S3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.s3ObjectVersion()));
            }
            case "RevocationType": {
                return Optional.ofNullable(clazz.cast(this.revocationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("S3Bucket", S3_BUCKET_FIELD);
        map.put("S3Key", S3_KEY_FIELD);
        map.put("S3ObjectVersion", S3_OBJECT_VERSION_FIELD);
        map.put("RevocationType", REVOCATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevocationContent, T> g) {
        return obj -> g.apply((RevocationContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Bucket;
        private String s3Key;
        private String s3ObjectVersion;
        private String revocationType;

        private BuilderImpl() {
        }

        private BuilderImpl(RevocationContent model) {
            this.s3Bucket(model.s3Bucket);
            this.s3Key(model.s3Key);
            this.s3ObjectVersion(model.s3ObjectVersion);
            this.revocationType(model.revocationType);
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final String getS3Key() {
            return this.s3Key;
        }

        public final void setS3Key(String s3Key) {
            this.s3Key = s3Key;
        }

        @Override
        public final Builder s3Key(String s3Key) {
            this.s3Key = s3Key;
            return this;
        }

        public final String getS3ObjectVersion() {
            return this.s3ObjectVersion;
        }

        public final void setS3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
        }

        @Override
        public final Builder s3ObjectVersion(String s3ObjectVersion) {
            this.s3ObjectVersion = s3ObjectVersion;
            return this;
        }

        public final String getRevocationType() {
            return this.revocationType;
        }

        public final void setRevocationType(String revocationType) {
            this.revocationType = revocationType;
        }

        @Override
        public final Builder revocationType(String revocationType) {
            this.revocationType = revocationType;
            return this;
        }

        @Override
        public final Builder revocationType(RevocationType revocationType) {
            this.revocationType(revocationType == null ? null : revocationType.toString());
            return this;
        }

        public RevocationContent build() {
            return new RevocationContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RevocationContent> {
        public Builder s3Bucket(String var1);

        public Builder s3Key(String var1);

        public Builder s3ObjectVersion(String var1);

        public Builder revocationType(String var1);

        public Builder revocationType(RevocationType var1);
    }
}

