/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Response;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroup;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTargetGroupResponse
extends ElasticLoadBalancingV2Response
implements ToCopyableBuilder<Builder, CreateTargetGroupResponse> {
    private static final SdkField<List<TargetGroup>> TARGET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetGroups").getter(CreateTargetGroupResponse.getter(CreateTargetGroupResponse::targetGroups)).setter(CreateTargetGroupResponse.setter(Builder::targetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_GROUPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("TargetGroups", TARGET_GROUPS_FIELD);
        }
    });
    private final List<TargetGroup> targetGroups;

    private CreateTargetGroupResponse(BuilderImpl builder) {
        super(builder);
        this.targetGroups = builder.targetGroups;
    }

    public final boolean hasTargetGroups() {
        return this.targetGroups != null && !(this.targetGroups instanceof SdkAutoConstructList);
    }

    public final List<TargetGroup> targetGroups() {
        return this.targetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetGroups() ? this.targetGroups() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTargetGroupResponse)) {
            return false;
        }
        CreateTargetGroupResponse other = (CreateTargetGroupResponse)((Object)obj);
        return this.hasTargetGroups() == other.hasTargetGroups() && Objects.equals(this.targetGroups(), other.targetGroups());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTargetGroupResponse").add("TargetGroups", this.hasTargetGroups() ? this.targetGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetGroups": {
                return Optional.ofNullable(clazz.cast(this.targetGroups()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateTargetGroupResponse, T> g) {
        return obj -> g.apply((CreateTargetGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Response.BuilderImpl
    implements Builder {
        private List<TargetGroup> targetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTargetGroupResponse model) {
            super(model);
            this.targetGroups(model.targetGroups);
        }

        public final List<TargetGroup.Builder> getTargetGroups() {
            List<TargetGroup.Builder> result = TargetGroupsCopier.copyToBuilder(this.targetGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetGroups(Collection<TargetGroup.BuilderImpl> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copyFromBuilder(targetGroups);
        }

        @Override
        public final Builder targetGroups(Collection<TargetGroup> targetGroups) {
            this.targetGroups = TargetGroupsCopier.copy(targetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(TargetGroup ... targetGroups) {
            this.targetGroups(Arrays.asList(targetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroups(Consumer<TargetGroup.Builder> ... targetGroups) {
            this.targetGroups(Stream.of(targetGroups).map(c -> (TargetGroup)((TargetGroup.Builder)TargetGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateTargetGroupResponse build() {
            return new CreateTargetGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTargetGroupResponse> {
        public Builder targetGroups(Collection<TargetGroup> var1);

        public Builder targetGroups(TargetGroup ... var1);

        public Builder targetGroups(Consumer<TargetGroup.Builder> ... var1);
    }
}

