/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.Tag;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrustStoreRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, CreateTrustStoreRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateTrustStoreRequest.getter(CreateTrustStoreRequest::name)).setter(CreateTrustStoreRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> CA_CERTIFICATES_BUNDLE_S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaCertificatesBundleS3Bucket").getter(CreateTrustStoreRequest.getter(CreateTrustStoreRequest::caCertificatesBundleS3Bucket)).setter(CreateTrustStoreRequest.setter(Builder::caCertificatesBundleS3Bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificatesBundleS3Bucket").build()}).build();
    private static final SdkField<String> CA_CERTIFICATES_BUNDLE_S3_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaCertificatesBundleS3Key").getter(CreateTrustStoreRequest.getter(CreateTrustStoreRequest::caCertificatesBundleS3Key)).setter(CreateTrustStoreRequest.setter(Builder::caCertificatesBundleS3Key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificatesBundleS3Key").build()}).build();
    private static final SdkField<String> CA_CERTIFICATES_BUNDLE_S3_OBJECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaCertificatesBundleS3ObjectVersion").getter(CreateTrustStoreRequest.getter(CreateTrustStoreRequest::caCertificatesBundleS3ObjectVersion)).setter(CreateTrustStoreRequest.setter(Builder::caCertificatesBundleS3ObjectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaCertificatesBundleS3ObjectVersion").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateTrustStoreRequest.getter(CreateTrustStoreRequest::tags)).setter(CreateTrustStoreRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CA_CERTIFICATES_BUNDLE_S3_BUCKET_FIELD, CA_CERTIFICATES_BUNDLE_S3_KEY_FIELD, CA_CERTIFICATES_BUNDLE_S3_OBJECT_VERSION_FIELD, TAGS_FIELD));
    private final String name;
    private final String caCertificatesBundleS3Bucket;
    private final String caCertificatesBundleS3Key;
    private final String caCertificatesBundleS3ObjectVersion;
    private final List<Tag> tags;

    private CreateTrustStoreRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.caCertificatesBundleS3Bucket = builder.caCertificatesBundleS3Bucket;
        this.caCertificatesBundleS3Key = builder.caCertificatesBundleS3Key;
        this.caCertificatesBundleS3ObjectVersion = builder.caCertificatesBundleS3ObjectVersion;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String caCertificatesBundleS3Bucket() {
        return this.caCertificatesBundleS3Bucket;
    }

    public final String caCertificatesBundleS3Key() {
        return this.caCertificatesBundleS3Key;
    }

    public final String caCertificatesBundleS3ObjectVersion() {
        return this.caCertificatesBundleS3ObjectVersion;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificatesBundleS3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificatesBundleS3Key());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificatesBundleS3ObjectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustStoreRequest)) {
            return false;
        }
        CreateTrustStoreRequest other = (CreateTrustStoreRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.caCertificatesBundleS3Bucket(), other.caCertificatesBundleS3Bucket()) && Objects.equals(this.caCertificatesBundleS3Key(), other.caCertificatesBundleS3Key()) && Objects.equals(this.caCertificatesBundleS3ObjectVersion(), other.caCertificatesBundleS3ObjectVersion()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTrustStoreRequest").add("Name", (Object)this.name()).add("CaCertificatesBundleS3Bucket", (Object)this.caCertificatesBundleS3Bucket()).add("CaCertificatesBundleS3Key", (Object)this.caCertificatesBundleS3Key()).add("CaCertificatesBundleS3ObjectVersion", (Object)this.caCertificatesBundleS3ObjectVersion()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CaCertificatesBundleS3Bucket": {
                return Optional.ofNullable(clazz.cast(this.caCertificatesBundleS3Bucket()));
            }
            case "CaCertificatesBundleS3Key": {
                return Optional.ofNullable(clazz.cast(this.caCertificatesBundleS3Key()));
            }
            case "CaCertificatesBundleS3ObjectVersion": {
                return Optional.ofNullable(clazz.cast(this.caCertificatesBundleS3ObjectVersion()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrustStoreRequest, T> g) {
        return obj -> g.apply((CreateTrustStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private String name;
        private String caCertificatesBundleS3Bucket;
        private String caCertificatesBundleS3Key;
        private String caCertificatesBundleS3ObjectVersion;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrustStoreRequest model) {
            super(model);
            this.name(model.name);
            this.caCertificatesBundleS3Bucket(model.caCertificatesBundleS3Bucket);
            this.caCertificatesBundleS3Key(model.caCertificatesBundleS3Key);
            this.caCertificatesBundleS3ObjectVersion(model.caCertificatesBundleS3ObjectVersion);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCaCertificatesBundleS3Bucket() {
            return this.caCertificatesBundleS3Bucket;
        }

        public final void setCaCertificatesBundleS3Bucket(String caCertificatesBundleS3Bucket) {
            this.caCertificatesBundleS3Bucket = caCertificatesBundleS3Bucket;
        }

        @Override
        public final Builder caCertificatesBundleS3Bucket(String caCertificatesBundleS3Bucket) {
            this.caCertificatesBundleS3Bucket = caCertificatesBundleS3Bucket;
            return this;
        }

        public final String getCaCertificatesBundleS3Key() {
            return this.caCertificatesBundleS3Key;
        }

        public final void setCaCertificatesBundleS3Key(String caCertificatesBundleS3Key) {
            this.caCertificatesBundleS3Key = caCertificatesBundleS3Key;
        }

        @Override
        public final Builder caCertificatesBundleS3Key(String caCertificatesBundleS3Key) {
            this.caCertificatesBundleS3Key = caCertificatesBundleS3Key;
            return this;
        }

        public final String getCaCertificatesBundleS3ObjectVersion() {
            return this.caCertificatesBundleS3ObjectVersion;
        }

        public final void setCaCertificatesBundleS3ObjectVersion(String caCertificatesBundleS3ObjectVersion) {
            this.caCertificatesBundleS3ObjectVersion = caCertificatesBundleS3ObjectVersion;
        }

        @Override
        public final Builder caCertificatesBundleS3ObjectVersion(String caCertificatesBundleS3ObjectVersion) {
            this.caCertificatesBundleS3ObjectVersion = caCertificatesBundleS3ObjectVersion;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrustStoreRequest build() {
            return new CreateTrustStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrustStoreRequest> {
        public Builder name(String var1);

        public Builder caCertificatesBundleS3Bucket(String var1);

        public Builder caCertificatesBundleS3Key(String var1);

        public Builder caCertificatesBundleS3ObjectVersion(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

