/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AddTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AllocationIdNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AlpnPolicyNotSupportedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.AvailabilityZoneNotSupportedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CertificateNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.CreateTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteLoadBalancerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeleteTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DeregisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeAccountLimitsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeListenersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeLoadBalancersResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeRulesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeSslPoliciesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DescribeTargetHealthResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateListenerException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateLoadBalancerNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTagKeysException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.DuplicateTargetGroupNameException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Exception;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.HealthUnavailableException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.IncompatibleProtocolsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidConfigurationRequestException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidLoadBalancerActionException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSchemeException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSecurityGroupException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidSubnetException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.InvalidTargetException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ListenerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.LoadBalancerNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyListenerResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyLoadBalancerAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyRuleResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupAttributesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ModifyTargetGroupResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.OperationNotPermittedException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.PriorityInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RegisterTargetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveListenerCertificatesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RemoveTagsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ResourceInUseException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.RuleNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetIpAddressTypeResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetRulePrioritiesResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSecurityGroupsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsRequest;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SetSubnetsResponse;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicyNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SubnetNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupAssociationLimitException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TargetGroupNotFoundException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyActionsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyCertificatesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyListenersException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyLoadBalancersException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyRegistrationsForTargetIdException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyRulesException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTagsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTargetGroupsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyTargetsException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.TooManyUniqueTargetGroupsPerLoadBalancerException;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.UnsupportedProtocolException;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeListenersIterable;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeLoadBalancersIterable;
import software.amazon.awssdk.services.elasticloadbalancingv2.paginators.DescribeTargetGroupsIterable;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AddListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.CreateTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteLoadBalancerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeleteTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DeregisterTargetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeAccountLimitsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeListenersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeLoadBalancersRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeRulesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeSslPoliciesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetGroupAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.DescribeTargetHealthRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyListenerRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyLoadBalancerAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyRuleRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyTargetGroupAttributesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.ModifyTargetGroupRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RegisterTargetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RemoveListenerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetIpAddressTypeRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetRulePrioritiesRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetSecurityGroupsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.transform.SetSubnetsRequestMarshaller;
import software.amazon.awssdk.services.elasticloadbalancingv2.waiters.ElasticLoadBalancingV2Waiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultElasticLoadBalancingV2Client
implements ElasticLoadBalancingV2Client {
    private static final Logger log = Logger.loggerFor(DefaultElasticLoadBalancingV2Client.class);
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultElasticLoadBalancingV2Client(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "elasticloadbalancing";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddListenerCertificatesResponse addListenerCertificates(AddListenerCertificatesRequest addListenerCertificatesRequest) throws ListenerNotFoundException, TooManyCertificatesException, CertificateNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddListenerCertificatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, addListenerCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddListenerCertificates");
            AddListenerCertificatesResponse addListenerCertificatesResponse = (AddListenerCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddListenerCertificates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addListenerCertificatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddListenerCertificatesRequestMarshaller(this.protocolFactory)));
            return addListenerCertificatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$addListenerCertificates$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws DuplicateTagKeysException, TooManyTagsException, LoadBalancerNotFoundException, TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(AddTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, addTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTags");
            AddTagsResponse addTagsResponse = (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)addTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsRequestMarshaller(this.protocolFactory)));
            return addTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$addTags$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateListenerResponse createListener(CreateListenerRequest createListenerRequest) throws DuplicateListenerException, TooManyListenersException, TooManyCertificatesException, LoadBalancerNotFoundException, TargetGroupNotFoundException, TargetGroupAssociationLimitException, InvalidConfigurationRequestException, IncompatibleProtocolsException, SslPolicyNotFoundException, CertificateNotFoundException, UnsupportedProtocolException, TooManyRegistrationsForTargetIdException, TooManyTargetsException, TooManyActionsException, InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException, AlpnPolicyNotSupportedException, TooManyTagsException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateListenerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, createListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateListener");
            CreateListenerResponse createListenerResponse = (CreateListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createListenerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateListenerRequestMarshaller(this.protocolFactory)));
            return createListenerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$createListener$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateLoadBalancerResponse createLoadBalancer(CreateLoadBalancerRequest createLoadBalancerRequest) throws DuplicateLoadBalancerNameException, TooManyLoadBalancersException, InvalidConfigurationRequestException, SubnetNotFoundException, InvalidSubnetException, InvalidSecurityGroupException, InvalidSchemeException, TooManyTagsException, DuplicateTagKeysException, ResourceInUseException, AllocationIdNotFoundException, AvailabilityZoneNotSupportedException, OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, createLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLoadBalancer");
            CreateLoadBalancerResponse createLoadBalancerResponse = (CreateLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createLoadBalancerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateLoadBalancerRequestMarshaller(this.protocolFactory)));
            return createLoadBalancerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$createLoadBalancer$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRuleResponse createRule(CreateRuleRequest createRuleRequest) throws PriorityInUseException, TooManyTargetGroupsException, TooManyRulesException, TargetGroupAssociationLimitException, IncompatibleProtocolsException, ListenerNotFoundException, TargetGroupNotFoundException, InvalidConfigurationRequestException, TooManyRegistrationsForTargetIdException, TooManyTargetsException, UnsupportedProtocolException, TooManyActionsException, InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException, TooManyTagsException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, createRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRule");
            CreateRuleResponse createRuleResponse = (CreateRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRuleRequestMarshaller(this.protocolFactory)));
            return createRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$createRule$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTargetGroupResponse createTargetGroup(CreateTargetGroupRequest createTargetGroupRequest) throws DuplicateTargetGroupNameException, TooManyTargetGroupsException, InvalidConfigurationRequestException, TooManyTagsException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateTargetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, createTargetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTargetGroup");
            CreateTargetGroupResponse createTargetGroupResponse = (CreateTargetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTargetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createTargetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTargetGroupRequestMarshaller(this.protocolFactory)));
            return createTargetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$createTargetGroup$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteListenerResponse deleteListener(DeleteListenerRequest deleteListenerRequest) throws ListenerNotFoundException, ResourceInUseException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteListenerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, deleteListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteListener");
            DeleteListenerResponse deleteListenerResponse = (DeleteListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteListenerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteListenerRequestMarshaller(this.protocolFactory)));
            return deleteListenerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$deleteListener$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteLoadBalancerResponse deleteLoadBalancer(DeleteLoadBalancerRequest deleteLoadBalancerRequest) throws LoadBalancerNotFoundException, OperationNotPermittedException, ResourceInUseException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteLoadBalancerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, deleteLoadBalancerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLoadBalancer");
            DeleteLoadBalancerResponse deleteLoadBalancerResponse = (DeleteLoadBalancerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLoadBalancer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteLoadBalancerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteLoadBalancerRequestMarshaller(this.protocolFactory)));
            return deleteLoadBalancerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$deleteLoadBalancer$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRuleResponse deleteRule(DeleteRuleRequest deleteRuleRequest) throws RuleNotFoundException, OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, deleteRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRule");
            DeleteRuleResponse deleteRuleResponse = (DeleteRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRuleRequestMarshaller(this.protocolFactory)));
            return deleteRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$deleteRule$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTargetGroupResponse deleteTargetGroup(DeleteTargetGroupRequest deleteTargetGroupRequest) throws ResourceInUseException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteTargetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, deleteTargetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTargetGroup");
            DeleteTargetGroupResponse deleteTargetGroupResponse = (DeleteTargetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTargetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteTargetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTargetGroupRequestMarshaller(this.protocolFactory)));
            return deleteTargetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$deleteTargetGroup$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterTargetsResponse deregisterTargets(DeregisterTargetsRequest deregisterTargetsRequest) throws TargetGroupNotFoundException, InvalidTargetException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeregisterTargetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, deregisterTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterTargets");
            DeregisterTargetsResponse deregisterTargetsResponse = (DeregisterTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterTargets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterTargetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterTargetsRequestMarshaller(this.protocolFactory)));
            return deregisterTargetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$deregisterTargets$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountLimitsResponse describeAccountLimits(DescribeAccountLimitsRequest describeAccountLimitsRequest) throws AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAccountLimitsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, describeAccountLimitsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAccountLimits");
            DescribeAccountLimitsResponse describeAccountLimitsResponse = (DescribeAccountLimitsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountLimits").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAccountLimitsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAccountLimitsRequestMarshaller(this.protocolFactory)));
            return describeAccountLimitsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$describeAccountLimits$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeListenerCertificatesResponse describeListenerCertificates(DescribeListenerCertificatesRequest describeListenerCertificatesRequest) throws ListenerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeListenerCertificatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, describeListenerCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeListenerCertificates");
            DescribeListenerCertificatesResponse describeListenerCertificatesResponse = (DescribeListenerCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeListenerCertificates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeListenerCertificatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeListenerCertificatesRequestMarshaller(this.protocolFactory)));
            return describeListenerCertificatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$describeListenerCertificates$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeListenersResponse describeListeners(DescribeListenersRequest describeListenersRequest) throws ListenerNotFoundException, LoadBalancerNotFoundException, UnsupportedProtocolException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeListenersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, describeListenersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeListeners");
            DescribeListenersResponse describeListenersResponse = (DescribeListenersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeListeners").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeListenersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeListenersRequestMarshaller(this.protocolFactory)));
            return describeListenersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$describeListeners$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeListenersIterable describeListenersPaginator(DescribeListenersRequest describeListenersRequest) throws ListenerNotFoundException, LoadBalancerNotFoundException, UnsupportedProtocolException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return new DescribeListenersIterable(this, this.applyPaginatorUserAgent(describeListenersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancerAttributesResponse describeLoadBalancerAttributes(DescribeLoadBalancerAttributesRequest describeLoadBalancerAttributesRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancerAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, describeLoadBalancerAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancerAttributes");
            DescribeLoadBalancerAttributesResponse describeLoadBalancerAttributesResponse = (DescribeLoadBalancerAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancerAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancerAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoadBalancerAttributesRequestMarshaller(this.protocolFactory)));
            return describeLoadBalancerAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$describeLoadBalancerAttributes$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeLoadBalancersResponse describeLoadBalancers(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeLoadBalancersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, describeLoadBalancersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLoadBalancers");
            DescribeLoadBalancersResponse describeLoadBalancersResponse = (DescribeLoadBalancersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLoadBalancers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeLoadBalancersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeLoadBalancersRequestMarshaller(this.protocolFactory)));
            return describeLoadBalancersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$describeLoadBalancers$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeLoadBalancersIterable describeLoadBalancersPaginator(DescribeLoadBalancersRequest describeLoadBalancersRequest) throws LoadBalancerNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return new DescribeLoadBalancersIterable(this, this.applyPaginatorUserAgent(describeLoadBalancersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRulesResponse describeRules(DescribeRulesRequest describeRulesRequest) throws ListenerNotFoundException, RuleNotFoundException, UnsupportedProtocolException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeRulesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, describeRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRules");
            DescribeRulesResponse describeRulesResponse = (DescribeRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeRulesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeRulesRequestMarshaller(this.protocolFactory)));
            return describeRulesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$describeRules$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSslPoliciesResponse describeSSLPolicies(DescribeSslPoliciesRequest describeSslPoliciesRequest) throws SslPolicyNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeSslPoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, describeSslPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSSLPolicies");
            DescribeSslPoliciesResponse describeSslPoliciesResponse = (DescribeSslPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSSLPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSslPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSslPoliciesRequestMarshaller(this.protocolFactory)));
            return describeSslPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$describeSSLPolicies$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTagsResponse describeTags(DescribeTagsRequest describeTagsRequest) throws LoadBalancerNotFoundException, TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, describeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTags");
            DescribeTagsResponse describeTagsResponse = (DescribeTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTagsRequestMarshaller(this.protocolFactory)));
            return describeTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$describeTags$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTargetGroupAttributesResponse describeTargetGroupAttributes(DescribeTargetGroupAttributesRequest describeTargetGroupAttributesRequest) throws TargetGroupNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTargetGroupAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, describeTargetGroupAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTargetGroupAttributes");
            DescribeTargetGroupAttributesResponse describeTargetGroupAttributesResponse = (DescribeTargetGroupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTargetGroupAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTargetGroupAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTargetGroupAttributesRequestMarshaller(this.protocolFactory)));
            return describeTargetGroupAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$describeTargetGroupAttributes$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTargetGroupsResponse describeTargetGroups(DescribeTargetGroupsRequest describeTargetGroupsRequest) throws LoadBalancerNotFoundException, TargetGroupNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTargetGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, describeTargetGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTargetGroups");
            DescribeTargetGroupsResponse describeTargetGroupsResponse = (DescribeTargetGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTargetGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTargetGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTargetGroupsRequestMarshaller(this.protocolFactory)));
            return describeTargetGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$describeTargetGroups$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public DescribeTargetGroupsIterable describeTargetGroupsPaginator(DescribeTargetGroupsRequest describeTargetGroupsRequest) throws LoadBalancerNotFoundException, TargetGroupNotFoundException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        return new DescribeTargetGroupsIterable(this, this.applyPaginatorUserAgent(describeTargetGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTargetHealthResponse describeTargetHealth(DescribeTargetHealthRequest describeTargetHealthRequest) throws InvalidTargetException, TargetGroupNotFoundException, HealthUnavailableException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeTargetHealthResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, describeTargetHealthRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTargetHealth");
            DescribeTargetHealthResponse describeTargetHealthResponse = (DescribeTargetHealthResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTargetHealth").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeTargetHealthRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTargetHealthRequestMarshaller(this.protocolFactory)));
            return describeTargetHealthResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$describeTargetHealth$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyListenerResponse modifyListener(ModifyListenerRequest modifyListenerRequest) throws DuplicateListenerException, TooManyListenersException, TooManyCertificatesException, ListenerNotFoundException, TargetGroupNotFoundException, TargetGroupAssociationLimitException, IncompatibleProtocolsException, SslPolicyNotFoundException, CertificateNotFoundException, InvalidConfigurationRequestException, UnsupportedProtocolException, TooManyRegistrationsForTargetIdException, TooManyTargetsException, TooManyActionsException, InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException, AlpnPolicyNotSupportedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyListenerResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, modifyListenerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyListener");
            ModifyListenerResponse modifyListenerResponse = (ModifyListenerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyListener").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyListenerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyListenerRequestMarshaller(this.protocolFactory)));
            return modifyListenerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$modifyListener$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyLoadBalancerAttributesResponse modifyLoadBalancerAttributes(ModifyLoadBalancerAttributesRequest modifyLoadBalancerAttributesRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyLoadBalancerAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, modifyLoadBalancerAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyLoadBalancerAttributes");
            ModifyLoadBalancerAttributesResponse modifyLoadBalancerAttributesResponse = (ModifyLoadBalancerAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyLoadBalancerAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyLoadBalancerAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyLoadBalancerAttributesRequestMarshaller(this.protocolFactory)));
            return modifyLoadBalancerAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$modifyLoadBalancerAttributes$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyRuleResponse modifyRule(ModifyRuleRequest modifyRuleRequest) throws TargetGroupAssociationLimitException, IncompatibleProtocolsException, RuleNotFoundException, OperationNotPermittedException, TooManyRegistrationsForTargetIdException, TooManyTargetsException, TargetGroupNotFoundException, UnsupportedProtocolException, TooManyActionsException, InvalidLoadBalancerActionException, TooManyUniqueTargetGroupsPerLoadBalancerException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyRuleResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, modifyRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyRule");
            ModifyRuleResponse modifyRuleResponse = (ModifyRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyRuleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyRuleRequestMarshaller(this.protocolFactory)));
            return modifyRuleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$modifyRule$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyTargetGroupResponse modifyTargetGroup(ModifyTargetGroupRequest modifyTargetGroupRequest) throws TargetGroupNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyTargetGroupResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, modifyTargetGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyTargetGroup");
            ModifyTargetGroupResponse modifyTargetGroupResponse = (ModifyTargetGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyTargetGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyTargetGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyTargetGroupRequestMarshaller(this.protocolFactory)));
            return modifyTargetGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$modifyTargetGroup$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyTargetGroupAttributesResponse modifyTargetGroupAttributes(ModifyTargetGroupAttributesRequest modifyTargetGroupAttributesRequest) throws TargetGroupNotFoundException, InvalidConfigurationRequestException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ModifyTargetGroupAttributesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, modifyTargetGroupAttributesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ModifyTargetGroupAttributes");
            ModifyTargetGroupAttributesResponse modifyTargetGroupAttributesResponse = (ModifyTargetGroupAttributesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ModifyTargetGroupAttributes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)modifyTargetGroupAttributesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ModifyTargetGroupAttributesRequestMarshaller(this.protocolFactory)));
            return modifyTargetGroupAttributesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$modifyTargetGroupAttributes$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegisterTargetsResponse registerTargets(RegisterTargetsRequest registerTargetsRequest) throws TargetGroupNotFoundException, TooManyTargetsException, InvalidTargetException, TooManyRegistrationsForTargetIdException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RegisterTargetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, registerTargetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RegisterTargets");
            RegisterTargetsResponse registerTargetsResponse = (RegisterTargetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RegisterTargets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerTargetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RegisterTargetsRequestMarshaller(this.protocolFactory)));
            return registerTargetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$registerTargets$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveListenerCertificatesResponse removeListenerCertificates(RemoveListenerCertificatesRequest removeListenerCertificatesRequest) throws ListenerNotFoundException, OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveListenerCertificatesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, removeListenerCertificatesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveListenerCertificates");
            RemoveListenerCertificatesResponse removeListenerCertificatesResponse = (RemoveListenerCertificatesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveListenerCertificates").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeListenerCertificatesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveListenerCertificatesRequestMarshaller(this.protocolFactory)));
            return removeListenerCertificatesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$removeListenerCertificates$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoveTagsResponse removeTags(RemoveTagsRequest removeTagsRequest) throws LoadBalancerNotFoundException, TargetGroupNotFoundException, ListenerNotFoundException, RuleNotFoundException, TooManyTagsException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(RemoveTagsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, removeTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RemoveTags");
            RemoveTagsResponse removeTagsResponse = (RemoveTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RemoveTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)removeTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RemoveTagsRequestMarshaller(this.protocolFactory)));
            return removeTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$removeTags$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetIpAddressTypeResponse setIpAddressType(SetIpAddressTypeRequest setIpAddressTypeRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, InvalidSubnetException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetIpAddressTypeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, setIpAddressTypeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetIpAddressType");
            SetIpAddressTypeResponse setIpAddressTypeResponse = (SetIpAddressTypeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetIpAddressType").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setIpAddressTypeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetIpAddressTypeRequestMarshaller(this.protocolFactory)));
            return setIpAddressTypeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$setIpAddressType$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetRulePrioritiesResponse setRulePriorities(SetRulePrioritiesRequest setRulePrioritiesRequest) throws RuleNotFoundException, PriorityInUseException, OperationNotPermittedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetRulePrioritiesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, setRulePrioritiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetRulePriorities");
            SetRulePrioritiesResponse setRulePrioritiesResponse = (SetRulePrioritiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetRulePriorities").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setRulePrioritiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetRulePrioritiesRequestMarshaller(this.protocolFactory)));
            return setRulePrioritiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$setRulePriorities$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetSecurityGroupsResponse setSecurityGroups(SetSecurityGroupsRequest setSecurityGroupsRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, InvalidSecurityGroupException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetSecurityGroupsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, setSecurityGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetSecurityGroups");
            SetSecurityGroupsResponse setSecurityGroupsResponse = (SetSecurityGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetSecurityGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setSecurityGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetSecurityGroupsRequestMarshaller(this.protocolFactory)));
            return setSecurityGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$setSecurityGroups$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetSubnetsResponse setSubnets(SetSubnetsRequest setSubnetsRequest) throws LoadBalancerNotFoundException, InvalidConfigurationRequestException, SubnetNotFoundException, InvalidSubnetException, AllocationIdNotFoundException, AvailabilityZoneNotSupportedException, AwsServiceException, SdkClientException, ElasticLoadBalancingV2Exception {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetSubnetsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultElasticLoadBalancingV2Client.resolveMetricPublishers(this.clientConfiguration, setSubnetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Elastic Load Balancing v2");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetSubnets");
            SetSubnetsResponse setSubnetsResponse = (SetSubnetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetSubnets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)setSubnetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SetSubnetsRequestMarshaller(this.protocolFactory)));
            return setSubnetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultElasticLoadBalancingV2Client.lambda$setSubnets$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("ALPNPolicyNotFound").exceptionBuilderSupplier(AlpnPolicyNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedProtocol").exceptionBuilderSupplier(UnsupportedProtocolException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyUniqueTargetGroupsPerLoadBalancer").exceptionBuilderSupplier(TooManyUniqueTargetGroupsPerLoadBalancerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AllocationIdNotFound").exceptionBuilderSupplier(AllocationIdNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceInUse").exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateTargetGroupName").exceptionBuilderSupplier(DuplicateTargetGroupNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRules").exceptionBuilderSupplier(TooManyRulesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyCertificates").exceptionBuilderSupplier(TooManyCertificatesException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LoadBalancerNotFound").exceptionBuilderSupplier(LoadBalancerNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTargetGroups").exceptionBuilderSupplier(TooManyTargetGroupsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyLoadBalancers").exceptionBuilderSupplier(TooManyLoadBalancersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidConfigurationRequest").exceptionBuilderSupplier(InvalidConfigurationRequestException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TargetGroupAssociationLimit").exceptionBuilderSupplier(TargetGroupAssociationLimitException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSecurityGroup").exceptionBuilderSupplier(InvalidSecurityGroupException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("IncompatibleProtocols").exceptionBuilderSupplier(IncompatibleProtocolsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyActions").exceptionBuilderSupplier(TooManyActionsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyListeners").exceptionBuilderSupplier(TooManyListenersException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateLoadBalancerName").exceptionBuilderSupplier(DuplicateLoadBalancerNameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("OperationNotPermitted").exceptionBuilderSupplier(OperationNotPermittedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidLoadBalancerAction").exceptionBuilderSupplier(InvalidLoadBalancerActionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("CertificateNotFound").exceptionBuilderSupplier(CertificateNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateTagKeys").exceptionBuilderSupplier(DuplicateTagKeysException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTags").exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TargetGroupNotFound").exceptionBuilderSupplier(TargetGroupNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyRegistrationsForTargetId").exceptionBuilderSupplier(TooManyRegistrationsForTargetIdException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ListenerNotFound").exceptionBuilderSupplier(ListenerNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("PriorityInUse").exceptionBuilderSupplier(PriorityInUseException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidTarget").exceptionBuilderSupplier(InvalidTargetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SubnetNotFound").exceptionBuilderSupplier(SubnetNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AvailabilityZoneNotSupported").exceptionBuilderSupplier(AvailabilityZoneNotSupportedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RuleNotFound").exceptionBuilderSupplier(RuleNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SSLPolicyNotFound").exceptionBuilderSupplier(SslPolicyNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicateListener").exceptionBuilderSupplier(DuplicateListenerException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidScheme").exceptionBuilderSupplier(InvalidSchemeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("HealthUnavailable").exceptionBuilderSupplier(HealthUnavailableException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidSubnet").exceptionBuilderSupplier(InvalidSubnetException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("TooManyTargets").exceptionBuilderSupplier(TooManyTargetsException::builder).httpStatusCode(Integer.valueOf(400)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(ElasticLoadBalancingV2Exception::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends ElasticLoadBalancingV2Request> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.287").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ElasticLoadBalancingV2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    @Override
    public ElasticLoadBalancingV2Waiter waiter() {
        return ElasticLoadBalancingV2Waiter.builder().client(this).build();
    }

    private static /* synthetic */ void lambda$setSubnets$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setSecurityGroups$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setRulePriorities$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setIpAddressType$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeTags$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$removeListenerCertificates$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$registerTargets$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyTargetGroupAttributes$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyTargetGroup$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyRule$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyLoadBalancerAttributes$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$modifyListener$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTargetHealth$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTargetGroups$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTargetGroupAttributes$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeTags$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSSLPolicies$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRules$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoadBalancers$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLoadBalancerAttributes$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeListeners$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeListenerCertificates$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAccountLimits$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deregisterTargets$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTargetGroup$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRule$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLoadBalancer$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteListener$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTargetGroup$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRule$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLoadBalancer$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createListener$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addTags$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$addListenerCertificates$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

