/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.ElasticLoadBalancingV2Request;
import software.amazon.awssdk.services.elasticloadbalancingv2.model.SslPolicyNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSslPoliciesRequest
extends ElasticLoadBalancingV2Request
implements ToCopyableBuilder<Builder, DescribeSslPoliciesRequest> {
    private static final SdkField<List<String>> NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Names").getter(DescribeSslPoliciesRequest.getter(DescribeSslPoliciesRequest::names)).setter(DescribeSslPoliciesRequest.setter(Builder::names)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Names").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeSslPoliciesRequest.getter(DescribeSslPoliciesRequest::marker)).setter(DescribeSslPoliciesRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PageSize").getter(DescribeSslPoliciesRequest.getter(DescribeSslPoliciesRequest::pageSize)).setter(DescribeSslPoliciesRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMES_FIELD, MARKER_FIELD, PAGE_SIZE_FIELD));
    private final List<String> names;
    private final String marker;
    private final Integer pageSize;

    private DescribeSslPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.names = builder.names;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
    }

    public final boolean hasNames() {
        return this.names != null && !(this.names instanceof SdkAutoConstructList);
    }

    public final List<String> names() {
        return this.names;
    }

    public final String marker() {
        return this.marker;
    }

    public final Integer pageSize() {
        return this.pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNames() ? this.names() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSslPoliciesRequest)) {
            return false;
        }
        DescribeSslPoliciesRequest other = (DescribeSslPoliciesRequest)((Object)obj);
        return this.hasNames() == other.hasNames() && Objects.equals(this.names(), other.names()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.pageSize(), other.pageSize());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSslPoliciesRequest").add("Names", this.hasNames() ? this.names() : null).add("Marker", (Object)this.marker()).add("PageSize", (Object)this.pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Names": {
                return Optional.ofNullable(clazz.cast(this.names()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSslPoliciesRequest, T> g) {
        return obj -> g.apply((DescribeSslPoliciesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ElasticLoadBalancingV2Request.BuilderImpl
    implements Builder {
        private List<String> names = DefaultSdkAutoConstructList.getInstance();
        private String marker;
        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSslPoliciesRequest model) {
            super(model);
            this.names(model.names);
            this.marker(model.marker);
            this.pageSize(model.pageSize);
        }

        public final Collection<String> getNames() {
            if (this.names instanceof SdkAutoConstructList) {
                return null;
            }
            return this.names;
        }

        public final void setNames(Collection<String> names) {
            this.names = SslPolicyNamesCopier.copy(names);
        }

        @Override
        @Transient
        public final Builder names(Collection<String> names) {
            this.names = SslPolicyNamesCopier.copy(names);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder names(String ... names) {
            this.names(Arrays.asList(names));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        @Transient
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        @Transient
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSslPoliciesRequest build() {
            return new DescribeSslPoliciesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ElasticLoadBalancingV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSslPoliciesRequest> {
        public Builder names(Collection<String> var1);

        public Builder names(String ... var1);

        public Builder marker(String var1);

        public Builder pageSize(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

