/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveListenerCertificatesRequest extends ElasticLoadBalancingV2Request implements
        ToCopyableBuilder<RemoveListenerCertificatesRequest.Builder, RemoveListenerCertificatesRequest> {
    private static final SdkField<String> LISTENER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RemoveListenerCertificatesRequest::listenerArn)).setter(setter(Builder::listenerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerArn").build()).build();

    private static final SdkField<List<Certificate>> CERTIFICATES_FIELD = SdkField
            .<List<Certificate>> builder(MarshallingType.LIST)
            .getter(getter(RemoveListenerCertificatesRequest::certificates))
            .setter(setter(Builder::certificates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Certificate> builder(MarshallingType.SDK_POJO)
                                            .constructor(Certificate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LISTENER_ARN_FIELD,
            CERTIFICATES_FIELD));

    private final String listenerArn;

    private final List<Certificate> certificates;

    private RemoveListenerCertificatesRequest(BuilderImpl builder) {
        super(builder);
        this.listenerArn = builder.listenerArn;
        this.certificates = builder.certificates;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the listener.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the listener.
     */
    public String listenerArn() {
        return listenerArn;
    }

    /**
     * Returns true if the Certificates property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCertificates() {
        return certificates != null && !(certificates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code> to the
     * certificate ARN but do not set <code>IsDefault</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCertificates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code> to
     *         the certificate ARN but do not set <code>IsDefault</code>.
     */
    public List<Certificate> certificates() {
        return certificates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(listenerArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificates());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveListenerCertificatesRequest)) {
            return false;
        }
        RemoveListenerCertificatesRequest other = (RemoveListenerCertificatesRequest) obj;
        return Objects.equals(listenerArn(), other.listenerArn()) && Objects.equals(certificates(), other.certificates());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RemoveListenerCertificatesRequest").add("ListenerArn", listenerArn())
                .add("Certificates", certificates()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ListenerArn":
            return Optional.ofNullable(clazz.cast(listenerArn()));
        case "Certificates":
            return Optional.ofNullable(clazz.cast(certificates()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveListenerCertificatesRequest, T> g) {
        return obj -> g.apply((RemoveListenerCertificatesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ElasticLoadBalancingV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, RemoveListenerCertificatesRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the listener.
         * </p>
         * 
         * @param listenerArn
         *        The Amazon Resource Name (ARN) of the listener.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerArn(String listenerArn);

        /**
         * <p>
         * The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code> to the
         * certificate ARN but do not set <code>IsDefault</code>.
         * </p>
         * 
         * @param certificates
         *        The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code>
         *        to the certificate ARN but do not set <code>IsDefault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Collection<Certificate> certificates);

        /**
         * <p>
         * The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code> to the
         * certificate ARN but do not set <code>IsDefault</code>.
         * </p>
         * 
         * @param certificates
         *        The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code>
         *        to the certificate ARN but do not set <code>IsDefault</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificates(Certificate... certificates);

        /**
         * <p>
         * The certificate to remove. You can specify one certificate per call. Set <code>CertificateArn</code> to the
         * certificate ARN but do not set <code>IsDefault</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Certificate>.Builder} avoiding the need to
         * create one manually via {@link List<Certificate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Certificate>.Builder#build()} is called immediately and its
         * result is passed to {@link #certificates(List<Certificate>)}.
         * 
         * @param certificates
         *        a consumer that will call methods on {@link List<Certificate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificates(List<Certificate>)
         */
        Builder certificates(Consumer<Certificate.Builder>... certificates);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ElasticLoadBalancingV2Request.BuilderImpl implements Builder {
        private String listenerArn;

        private List<Certificate> certificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveListenerCertificatesRequest model) {
            super(model);
            listenerArn(model.listenerArn);
            certificates(model.certificates);
        }

        public final String getListenerArn() {
            return listenerArn;
        }

        @Override
        public final Builder listenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
            return this;
        }

        public final void setListenerArn(String listenerArn) {
            this.listenerArn = listenerArn;
        }

        public final Collection<Certificate.Builder> getCertificates() {
            return certificates != null ? certificates.stream().map(Certificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder certificates(Collection<Certificate> certificates) {
            this.certificates = CertificateListCopier.copy(certificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Certificate... certificates) {
            certificates(Arrays.asList(certificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificates(Consumer<Certificate.Builder>... certificates) {
            certificates(Stream.of(certificates).map(c -> Certificate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCertificates(Collection<Certificate.BuilderImpl> certificates) {
            this.certificates = CertificateListCopier.copyFromBuilder(certificates);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveListenerCertificatesRequest build() {
            return new RemoveListenerCertificatesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
