/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Availability Zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailabilityZone implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailabilityZone.Builder, AvailabilityZone> {
    private static final SdkField<String> ZONE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AvailabilityZone::zoneName)).setter(setter(Builder::zoneName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneName").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AvailabilityZone::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<List<LoadBalancerAddress>> LOAD_BALANCER_ADDRESSES_FIELD = SdkField
            .<List<LoadBalancerAddress>> builder(MarshallingType.LIST)
            .getter(getter(AvailabilityZone::loadBalancerAddresses))
            .setter(setter(Builder::loadBalancerAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBalancerAddress> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBalancerAddress::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ZONE_NAME_FIELD,
            SUBNET_ID_FIELD, LOAD_BALANCER_ADDRESSES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String zoneName;

    private final String subnetId;

    private final List<LoadBalancerAddress> loadBalancerAddresses;

    private AvailabilityZone(BuilderImpl builder) {
        this.zoneName = builder.zoneName;
        this.subnetId = builder.subnetId;
        this.loadBalancerAddresses = builder.loadBalancerAddresses;
    }

    /**
     * <p>
     * The name of the Availability Zone.
     * </p>
     * 
     * @return The name of the Availability Zone.
     */
    public String zoneName() {
        return zoneName;
    }

    /**
     * <p>
     * The ID of the subnet. You can specify one subnet per Availability Zone.
     * </p>
     * 
     * @return The ID of the subnet. You can specify one subnet per Availability Zone.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * Returns true if the LoadBalancerAddresses property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasLoadBalancerAddresses() {
        return loadBalancerAddresses != null && !(loadBalancerAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one Elastic IP
     * address per Availability Zone when you create an internal-facing load balancer. For internal load balancers, you
     * can specify a private IP address from the IPv4 range of the subnet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLoadBalancerAddresses()} to see if a value was sent in this field.
     * </p>
     * 
     * @return [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one
     *         Elastic IP address per Availability Zone when you create an internal-facing load balancer. For internal
     *         load balancers, you can specify a private IP address from the IPv4 range of the subnet.
     */
    public List<LoadBalancerAddress> loadBalancerAddresses() {
        return loadBalancerAddresses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(zoneName());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerAddresses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone) obj;
        return Objects.equals(zoneName(), other.zoneName()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(loadBalancerAddresses(), other.loadBalancerAddresses());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AvailabilityZone").add("ZoneName", zoneName()).add("SubnetId", subnetId())
                .add("LoadBalancerAddresses", loadBalancerAddresses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ZoneName":
            return Optional.ofNullable(clazz.cast(zoneName()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "LoadBalancerAddresses":
            return Optional.ofNullable(clazz.cast(loadBalancerAddresses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailabilityZone, T> g) {
        return obj -> g.apply((AvailabilityZone) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailabilityZone> {
        /**
         * <p>
         * The name of the Availability Zone.
         * </p>
         * 
         * @param zoneName
         *        The name of the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneName(String zoneName);

        /**
         * <p>
         * The ID of the subnet. You can specify one subnet per Availability Zone.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet. You can specify one subnet per Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one Elastic
         * IP address per Availability Zone when you create an internal-facing load balancer. For internal load
         * balancers, you can specify a private IP address from the IPv4 range of the subnet.
         * </p>
         * 
         * @param loadBalancerAddresses
         *        [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one
         *        Elastic IP address per Availability Zone when you create an internal-facing load balancer. For
         *        internal load balancers, you can specify a private IP address from the IPv4 range of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerAddresses(Collection<LoadBalancerAddress> loadBalancerAddresses);

        /**
         * <p>
         * [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one Elastic
         * IP address per Availability Zone when you create an internal-facing load balancer. For internal load
         * balancers, you can specify a private IP address from the IPv4 range of the subnet.
         * </p>
         * 
         * @param loadBalancerAddresses
         *        [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one
         *        Elastic IP address per Availability Zone when you create an internal-facing load balancer. For
         *        internal load balancers, you can specify a private IP address from the IPv4 range of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerAddresses(LoadBalancerAddress... loadBalancerAddresses);

        /**
         * <p>
         * [Network Load Balancers] If you need static IP addresses for your load balancer, you can specify one Elastic
         * IP address per Availability Zone when you create an internal-facing load balancer. For internal load
         * balancers, you can specify a private IP address from the IPv4 range of the subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBalancerAddress>.Builder} avoiding the
         * need to create one manually via {@link List<LoadBalancerAddress>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBalancerAddress>.Builder#build()} is called immediately
         * and its result is passed to {@link #loadBalancerAddresses(List<LoadBalancerAddress>)}.
         * 
         * @param loadBalancerAddresses
         *        a consumer that will call methods on {@link List<LoadBalancerAddress>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerAddresses(List<LoadBalancerAddress>)
         */
        Builder loadBalancerAddresses(Consumer<LoadBalancerAddress.Builder>... loadBalancerAddresses);
    }

    static final class BuilderImpl implements Builder {
        private String zoneName;

        private String subnetId;

        private List<LoadBalancerAddress> loadBalancerAddresses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            zoneName(model.zoneName);
            subnetId(model.subnetId);
            loadBalancerAddresses(model.loadBalancerAddresses);
        }

        public final String getZoneName() {
            return zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final Collection<LoadBalancerAddress.Builder> getLoadBalancerAddresses() {
            return loadBalancerAddresses != null ? loadBalancerAddresses.stream().map(LoadBalancerAddress::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancerAddresses(Collection<LoadBalancerAddress> loadBalancerAddresses) {
            this.loadBalancerAddresses = LoadBalancerAddressesCopier.copy(loadBalancerAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerAddresses(LoadBalancerAddress... loadBalancerAddresses) {
            loadBalancerAddresses(Arrays.asList(loadBalancerAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerAddresses(Consumer<LoadBalancerAddress.Builder>... loadBalancerAddresses) {
            loadBalancerAddresses(Stream.of(loadBalancerAddresses)
                    .map(c -> LoadBalancerAddress.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancerAddresses(Collection<LoadBalancerAddress.BuilderImpl> loadBalancerAddresses) {
            this.loadBalancerAddresses = LoadBalancerAddressesCopier.copyFromBuilder(loadBalancerAddresses);
        }

        @Override
        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
